/*
 * Decompiled with CFR 0.152.
 */
package waba.applet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Insets;
import waba.applet.JavaBridge;
import waba.applet.WinCanvas;
import waba.applet.WinTimer;
import waba.fx.ISurface;
import waba.sys.Settings;
import waba.sys.Vm;
import waba.ui.MainWindow;
import waba.ui.Window;

public class Applet
extends java.applet.Applet
implements ISurface {
    public static String creatorId;
    public static Applet currentApplet;
    String className;
    Frame frame;
    public MainWindow mainWindow;
    public boolean isApplication;
    public boolean isColor;
    private static final int defaultBPP = 8;
    public static int bpp;
    public int width;
    public int height;
    public static int appX;
    public static int appY;
    public WinTimer _winTimer;
    public String commandLine = "";
    public static String appTitle;
    static boolean appletInitialized;
    public static WinCanvas _winCanvas;
    boolean started;
    public static int toUI;
    public static waba.fx.Graphics mainG;
    public boolean destroyed;

    static {
        bpp = 8;
        toUI = -1;
    }

    public Applet() {
        JavaBridge.showMsgs = false;
        currentApplet = this;
        try {
            System.runFinalizersOnExit((boolean)true);
        }
        catch (Throwable throwable) {}
    }

    public void _setTimerInterval(int milliseconds) {
        this._winTimer.setInterval(milliseconds);
    }

    public void destroy() {
        if (this.mainWindow == null || this.destroyed) {
            return;
        }
        this._winTimer.stopGracefully();
        WinCanvas.invokeInEventThread(true, new Runnable(){

            public void run() {
                Applet.this.mainWindow.appEnding();
                JavaBridge.storeSettings();
            }
        });
        this.destroyed = true;
    }

    public void destroyCurrentMainWindow() {
        this.eraseScreen();
        this._winTimer.stopGracefully();
        this.remove(_winCanvas);
        Window.destroyZStack();
    }

    public void eraseScreen() {
        Graphics g = WinCanvas.currentCanvas.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, Applet.currentApplet.getBounds().width, Applet.currentApplet.getBounds().height);
    }

    public void exit(int exitCode) {
        this.destroy();
        System.exit(exitCode);
    }

    public void init() {
        appletInitialized = true;
        JavaBridge.showMsgs = true;
        try {
            System.out.println("Key emulations:");
            System.out.println("F1-F4 : HARD1 to HARD4");
            System.out.println("F5 : COMMAND");
            System.out.println("F6 : MENU");
            System.out.println("F7 : CALC");
            System.out.println("F8 : FIND");
            System.out.println("F9 : LAUNCH (HOME)");
            System.out.println("F10: KEYBOARD_ABC");
            System.out.println("F11: KEYBOARD_123");
            System.out.println("F12: ACTION (Center button press)");
            this.setLayout(new BorderLayout());
            if (!this.isApplication) {
                this.loadAppletParameters();
            }
            if (Settings.dataPath == null) {
                Settings.dataPath = "./";
            }
            JavaBridge.fillSettings();
            try {
                JavaBridge._class = this.getClass();
                this.getClass();
                Class<?> c = Class.forName(this.className);
                this.mainWindow = (MainWindow)c.newInstance();
                if (toUI != -1) {
                    Settings.setUIStyle((byte)toUI);
                }
            }
            catch (LinkageError le) {
                System.out.println("Fatal Error when running applet: there is an error in the constructor of the class " + this.className + " and it could not be instantiated. Stack trace: ");
                le.printStackTrace();
                if (this.isApplication) {
                    System.exit(0);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("The MainWindow class specified was not found: " + this.className + "\nCommon causes are: the name is misspelled, the package name is incorrect, or its location was not added to the classpath.");
                if (this.isApplication) {
                    System.exit(-1);
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.frame != null) {
                this.frame.setResizable(false);
                this.frame.show();
                WinCanvas.currentCanvas.requestFocus();
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private void loadAppletParameters() throws Exception {
        String s;
        this.className = this.getParameter("appClass");
        if (this.className == null) {
            throw new Exception("please use a parameter \"appClass\" specifying the class name");
        }
        Settings.dataPath = this.getParameter("appPath");
        if (Settings.dataPath == null) {
            Settings.dataPath = this.getParameter("dataPath");
        }
        if (this.getParameter("useSonyFonts") != null) {
            JavaBridge.useSonyFonts = true;
        }
        if ((s = this.getParameter("bpp")) != null) {
            try {
                int nbpp = Integer.parseInt(s);
                if (nbpp != 2 && nbpp != 4 && nbpp != 8 && nbpp != 16) {
                    System.out.println("ERROR: bpp must be 2,4,8 or 16");
                } else {
                    bpp = nbpp;
                    this.isColor = nbpp > 4;
                }
            }
            catch (Exception exception) {
                System.out.println("ERROR: bad bpp on parameter 'bpp'");
            }
        }
        if ((s = this.getParameter("scale")) != null) {
            try {
                int scale = Integer.parseInt(s);
                if (scale >= 1 && scale <= 4) {
                    JavaBridge.scale = scale;
                }
            }
            catch (Exception exception) {
                System.out.println("ERROR: bad scale");
            }
        }
        this.width = this.size().width / JavaBridge.scale;
        this.height = this.size().height / JavaBridge.scale;
        s = this.getParameter("uiStyle");
        if ("PalmOS".equalsIgnoreCase(s)) {
            toUI = 1;
        } else if ("Flat".equalsIgnoreCase(s)) {
            toUI = 2;
        } else if ("Vista".equalsIgnoreCase(s)) {
            toUI = 3;
        } else if ("WinCE".equalsIgnoreCase(s)) {
            toUI = 0;
        }
        if (this.getParameter("penlessDevice") != null) {
            Settings.keyboardFocusTraversable = true;
        }
        if (this.getParameter("keypadOnly") != null) {
            Settings.keypadOnly = true;
        }
        if ((s = this.getParameter("CrId")) != null) {
            creatorId = s;
        }
    }

    public static void main(String[] args) {
        Insets insets;
        int width = 160;
        int height = 160;
        int count = args.length;
        String newDataPath = null;
        int nbpp = -1;
        int toUI = -1;
        String cmdLine = "";
        System.out.println("Current path : " + System.getProperty("user.dir"));
        if (count == 0) {
            System.out.println("ERROR: you must supply a class name as the last argument");
            System.out.println("Possible Arguments (in any order and case insensitive): /x <x> /y <y> /w <width> /h <height> /uiStyle <WinCE/PalmOS/Flat/Vista> /penlessDevice /keypadOnly /bpp <bitsPerPixel_2_4_or_8> /scale <scale_1_to_4> /t <title> /dataPath <path> /useSonyFonts /cmdLine <the rest of arguments-1 are passed to the app as the commandline>");
            System.out.println("The class name must always be the last argument");
            System.out.println("The dataPath is used to set where the catalog and images are stored");
            return;
        }
        int i = 0;
        while (i < count - 1) {
            if (args[i].equalsIgnoreCase("/useSonyFonts")) {
                JavaBridge.useSonyFonts = true;
            } else if (args[i].equalsIgnoreCase("/appPath") || args[i].equalsIgnoreCase("/dataPath")) {
                if (++i < count - 1) {
                    newDataPath = args[i];
                }
            } else if (args[i].equalsIgnoreCase("/t")) {
                if (++i < count - 1) {
                    appTitle = args[i];
                }
            } else if (args[i].equalsIgnoreCase("/w")) {
                if (++i < count - 1) {
                    try {
                        width = Integer.parseInt(args[i]);
                    }
                    catch (Exception exception) {
                        System.out.println("ERROR: bad width");
                    }
                }
            } else if (args[i].equalsIgnoreCase("/h")) {
                if (++i < count - 1) {
                    try {
                        height = Integer.parseInt(args[i]);
                    }
                    catch (Exception exception) {
                        System.out.println("ERROR: bad height");
                    }
                }
            } else if (args[i].equalsIgnoreCase("/cmdline")) {
                cmdLine = "";
                while (++i < count - 1) {
                    cmdLine = String.valueOf(cmdLine) + args[i] + (i < count - 2 ? " " : "");
                }
                System.out.println("Command line : '" + cmdLine + "'");
            } else if (args[i].equalsIgnoreCase("/x")) {
                if (++i < count - 1) {
                    try {
                        appX = Integer.parseInt(args[i]);
                    }
                    catch (Exception exception) {
                        System.out.println("ERROR: bad x coordinate");
                    }
                }
            } else if (args[i].equalsIgnoreCase("/y")) {
                if (++i < count - 1) {
                    try {
                        appY = Integer.parseInt(args[i]);
                    }
                    catch (Exception exception) {
                        System.out.println("ERROR: bad y coordinate");
                    }
                }
            } else if (args[i].equalsIgnoreCase("/uiStyle")) {
                if (++i < count - 1) {
                    if (args[i].equalsIgnoreCase("PalmOS")) {
                        toUI = 1;
                    } else if (args[i].equalsIgnoreCase("Flat")) {
                        toUI = 2;
                    } else if (args[i].equalsIgnoreCase("Vista")) {
                        toUI = 3;
                    } else if (args[i].equalsIgnoreCase("WinCE")) {
                        toUI = 0;
                    }
                }
            } else if (args[i].equalsIgnoreCase("/penlessDevice")) {
                Settings.keyboardFocusTraversable = true;
            }
            if (args[i].equalsIgnoreCase("/keypadOnly")) {
                Settings.keypadOnly = true;
            } else if (args[i].equalsIgnoreCase("/color") && nbpp == -1) {
                nbpp = 8;
            } else if (args[i].equalsIgnoreCase("/bpp")) {
                if (++i < count - 1) {
                    try {
                        nbpp = Integer.parseInt(args[i]);
                        if (nbpp != 2 && nbpp != 4 && nbpp != 8 && nbpp != 16) {
                            System.out.println("ERROR: bpp must be 2,4,8 or 16");
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("ERROR: bad bpp");
                    }
                }
            } else if (args[i].equalsIgnoreCase("/scale")) {
                if (++i < count - 1) {
                    try {
                        int scale = Integer.parseInt(args[i]);
                        if (scale >= 1 && scale <= 4) {
                            JavaBridge.scale = scale;
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("ERROR: bad scale");
                    }
                }
            } else if (args[i].equalsIgnoreCase("/CrId") && ++i < count - 1) {
                creatorId = args[i];
            }
            ++i;
        }
        if (nbpp == -1) {
            nbpp = 8;
        }
        bpp = nbpp;
        Applet applet = new Applet();
        applet.className = args[count - 1];
        applet.isApplication = true;
        boolean bl = applet.isColor = nbpp > 4;
        if (width == 0) {
            System.out.println("Please use another JDK version, this one is buggy! Assuming width=160.");
            width = 160;
        }
        if (height == 0) {
            System.out.println("Please use another JDK version, this one is buggy! Assuming height=160.");
            height = 160;
        }
        applet.width = width;
        applet.height = height;
        Applet.toUI = toUI;
        applet.commandLine = cmdLine;
        if (newDataPath != null) {
            Settings.dataPath = newDataPath;
        }
        Frame frame = new Frame();
        if (appTitle != null) {
            frame.setTitle(appTitle);
        }
        frame.setLayout(new BorderLayout());
        frame.add("Center", applet);
        frame.resize(width * JavaBridge.scale, height * JavaBridge.scale);
        ((Component)frame).setLocation(appX, appY);
        frame.show();
        applet.frame = frame;
        frame.hide();
        try {
            insets = frame.getInsets();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            insets = frame.insets();
        }
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        frame.resize(width * JavaBridge.scale + insets.left + insets.right, height * JavaBridge.scale + insets.top + insets.bottom);
        applet.init();
    }

    public void paint(waba.fx.Graphics g) {
    }

    public void print(waba.fx.Graphics g) {
    }

    public void registerMainWindow(MainWindow main) {
        _winCanvas = new WinCanvas(main);
        this.add(_winCanvas);
        _winCanvas.setBounds(0, 0, this.width * JavaBridge.scale, this.height * JavaBridge.scale);
        _winCanvas.requestFocus();
        mainG = null;
        mainG = new waba.fx.Graphics(main);
        this._winTimer = new WinTimer(main);
    }

    public void start() {
        this.mainWindow = MainWindow.getMainWindow();
    }

    void startApp() {
        if (!this.started) {
            try {
                WinCanvas.invokeInEventThread(true, new Runnable(){

                    public void run() {
                        while (Applet.this.mainWindow == null) {
                            Vm.sleep(10);
                        }
                        Applet.this.mainWindow.appStarting();
                    }
                });
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.started = true;
        }
    }

    public void update(waba.fx.Graphics g) {
        this.paint(g);
    }

    static class Frame
    extends java.awt.Frame {
        Frame() {
        }

        public boolean handleEvent(Event event) {
            if (event.id == 201) {
                currentApplet.destroy();
                System.exit(0);
            } else if (_winCanvas != null && event.id != 1005 && this.getFocusOwner() != _winCanvas && !Applet.currentApplet.destroyed) {
                _winCanvas.requestFocus();
            }
            return super.handleEvent(event);
        }
    }
}

