/*
 * Decompiled with CFR 0.152.
 */
package moio.util;

import moio.util.AbstractCollection;
import moio.util.AbstractMap;
import moio.util.AbstractSet;
import moio.util.Cloneable;
import moio.util.Collection;
import moio.util.Comparable;
import moio.util.Comparator;
import moio.util.IllegalArgumentException;
import moio.util.IllegalStateException;
import moio.util.Iterator;
import moio.util.Map;
import moio.util.NoSuchElementException;
import moio.util.Serializable;
import moio.util.Set;
import moio.util.SortedMap;

public class TreeMap
extends AbstractMap
implements SortedMap,
Cloneable,
Serializable {
    private static final long serialVersionUID = 919286545866124006L;
    static final int RED = -1;
    static final int BLACK = 1;
    static final Node nil;
    private transient Node root;
    transient int size;
    private transient Set entries;
    transient int modCount;
    final Comparator comparator;

    public TreeMap() {
        this((Comparator)null);
    }

    public TreeMap(Comparator comparator) {
        this.comparator = comparator;
        this.fabricateTree(0);
    }

    public TreeMap(Map map) {
        this((Comparator)null);
        this.putAll(map);
    }

    public TreeMap(SortedMap sortedMap) {
        this(sortedMap.comparator());
        int n = sortedMap.size();
        Iterator iterator = sortedMap.entrySet().iterator();
        this.fabricateTree(n);
        Node node = this.firstNode();
        while (--n >= 0) {
            Map.Entry entry = (Map.Entry)iterator.next();
            node.key = entry.getKey();
            node.value = entry.getValue();
            node = this.successor(node);
        }
    }

    public void clear() {
        if (this.size > 0) {
            ++this.modCount;
            this.root = nil;
            this.size = 0;
        }
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public boolean containsKey(Object object) {
        return this.getNode(object) != nil;
    }

    public boolean containsValue(Object object) {
        Node node = this.firstNode();
        while (node != nil) {
            if (AbstractMap.equals(object, node.value)) {
                return true;
            }
            node = this.successor(node);
        }
        return false;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet(){

                public int size() {
                    return TreeMap.this.size;
                }

                public Iterator iterator() {
                    return new TreeIterator(2);
                }

                public void clear() {
                    TreeMap.this.clear();
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Node node = TreeMap.this.getNode(entry.getKey());
                    return node != nil && AbstractCollection.equals(entry.getValue(), node.value);
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Node node = TreeMap.this.getNode(entry.getKey());
                    if (node != nil && AbstractCollection.equals(entry.getValue(), node.value)) {
                        TreeMap.this.removeNode(node);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.entries;
    }

    public Object firstKey() {
        if (this.root == nil) {
            throw new NoSuchElementException();
        }
        return this.firstNode().key;
    }

    public Object get(Object object) {
        return this.getNode((Object)object).value;
    }

    public SortedMap headMap(Object object) {
        return new SubMap(nil, object);
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet(){

                public int size() {
                    return TreeMap.this.size;
                }

                public Iterator iterator() {
                    return new TreeIterator(0);
                }

                public void clear() {
                    TreeMap.this.clear();
                }

                public boolean contains(Object object) {
                    return TreeMap.this.containsKey(object);
                }

                public boolean remove(Object object) {
                    Node node = TreeMap.this.getNode(object);
                    if (node == nil) {
                        return false;
                    }
                    TreeMap.this.removeNode(node);
                    return true;
                }
            };
        }
        return this.keys;
    }

    public Object lastKey() {
        if (this.root == nil) {
            throw new NoSuchElementException("empty");
        }
        return this.lastNode().key;
    }

    public Object put(Object object, Object object2) {
        Node node = this.root;
        Node node2 = nil;
        int n = 0;
        while (node != nil) {
            node2 = node;
            n = this.compare(object, node.key);
            if (n > 0) {
                node = node.right;
                continue;
            }
            if (n < 0) {
                node = node.left;
                continue;
            }
            return node.setValue(object2);
        }
        Node node3 = new Node(object, object2, -1);
        node3.parent = node2;
        ++this.modCount;
        ++this.size;
        if (node2 == nil) {
            this.root = node3;
            return null;
        }
        if (n > 0) {
            node2.right = node3;
        } else {
            node2.left = node3;
        }
        this.insertFixup(node3);
        return null;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        int n = map.size();
        while (--n >= 0) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        Node node = this.getNode(object);
        if (node == nil) {
            return null;
        }
        Object object2 = node.value;
        this.removeNode(node);
        return object2;
    }

    public int size() {
        return this.size;
    }

    public SortedMap subMap(Object object, Object object2) {
        return new SubMap(object, object2);
    }

    public SortedMap tailMap(Object object) {
        return new SubMap(object, nil);
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public int size() {
                    return TreeMap.this.size;
                }

                public Iterator iterator() {
                    return new TreeIterator(1);
                }

                public void clear() {
                    TreeMap.this.clear();
                }
            };
        }
        return this.values;
    }

    final int compare(Object object, Object object2) {
        return this.comparator == null ? ((Comparable)object).compareTo(object2) : this.comparator.compare(object, object2);
    }

    private void deleteFixup(Node node, Node node2) {
        while (node != this.root && node.color == 1) {
            Node node3;
            if (node == node2.left) {
                node3 = node2.right;
                if (node3.color == -1) {
                    node3.color = 1;
                    node2.color = -1;
                    this.rotateLeft(node2);
                    node3 = node2.right;
                }
                if (node3.left.color == 1 && node3.right.color == 1) {
                    node3.color = -1;
                    node = node2;
                    node2 = node2.parent;
                    continue;
                }
                if (node3.right.color == 1) {
                    node3.left.color = 1;
                    node3.color = -1;
                    this.rotateRight(node3);
                    node3 = node2.right;
                }
                node3.color = node2.color;
                node2.color = 1;
                node3.right.color = 1;
                this.rotateLeft(node2);
                node = this.root;
                continue;
            }
            node3 = node2.left;
            if (node3.color == -1) {
                node3.color = 1;
                node2.color = -1;
                this.rotateRight(node2);
                node3 = node2.left;
            }
            if (node3.right.color == 1 && node3.left.color == 1) {
                node3.color = -1;
                node = node2;
                node2 = node2.parent;
                continue;
            }
            if (node3.left.color == 1) {
                node3.right.color = 1;
                node3.color = -1;
                this.rotateLeft(node3);
                node3 = node2.left;
            }
            node3.color = node2.color;
            node2.color = 1;
            node3.left.color = 1;
            this.rotateRight(node2);
            node = this.root;
        }
        node.color = 1;
    }

    private void fabricateTree(int n) {
        Node node;
        Node node2;
        Node node3;
        int n2;
        Node node4;
        if (n == 0) {
            this.root = nil;
            this.size = 0;
            return;
        }
        this.root = new Node(null, null, 1);
        this.size = n;
        Node node5 = this.root;
        int n3 = 2;
        while (n3 + n3 <= n) {
            Node node6 = node5;
            node4 = null;
            for (n2 = 0; n2 < n3; n2 += 2) {
                node3 = new Node(null, null, 1);
                node2 = new Node(null, null, 1);
                node3.parent = node6;
                node3.right = node2;
                node2.parent = node6;
                node6.left = node3;
                node = node6.right;
                node6.right = node2;
                node6 = node;
                if (node4 != null) {
                    node4.right = node3;
                }
                node4 = node2;
            }
            node5 = node5.left;
            n3 <<= 1;
        }
        int n4 = n - n3;
        node4 = node5;
        for (n2 = 0; n2 < n4; n2 += 2) {
            node3 = new Node(null, null, -1);
            node2 = new Node(null, null, -1);
            node3.parent = node4;
            node2.parent = node4;
            node4.left = node3;
            node = node4.right;
            node4.right = node2;
            node4 = node;
        }
        if (n2 - n4 == 0) {
            node3 = new Node(null, null, -1);
            node3.parent = node4;
            node4.left = node3;
            node4 = node4.right;
            node3.parent.right = nil;
        }
        while (node4 != nil) {
            node3 = node4.right;
            node4.right = nil;
            node4 = node3;
        }
    }

    final Node firstNode() {
        Node node = this.root;
        while (node.left != nil) {
            node = node.left;
        }
        return node;
    }

    final Node getNode(Object object) {
        Node node = this.root;
        while (node != nil) {
            int n = this.compare(object, node.key);
            if (n > 0) {
                node = node.right;
                continue;
            }
            if (n < 0) {
                node = node.left;
                continue;
            }
            return node;
        }
        return node;
    }

    final Node highestLessThan(Object object) {
        if (object == nil) {
            return this.lastNode();
        }
        Node node = nil;
        Node node2 = this.root;
        int n = 0;
        while (node2 != nil) {
            node = node2;
            n = this.compare(object, node2.key);
            if (n > 0) {
                node2 = node2.right;
                continue;
            }
            if (n < 0) {
                node2 = node2.left;
                continue;
            }
            return this.predecessor(node);
        }
        return n <= 0 ? this.predecessor(node) : node;
    }

    private void insertFixup(Node node) {
        while (node.parent.color == -1 && node.parent.parent != nil) {
            Node node2;
            if (node.parent == node.parent.parent.left) {
                node2 = node.parent.parent.right;
                if (node2.color == -1) {
                    node.parent.color = 1;
                    node2.color = 1;
                    node2.parent.color = -1;
                    node = node2.parent;
                    continue;
                }
                if (node == node.parent.right) {
                    node = node.parent;
                    this.rotateLeft(node);
                }
                node.parent.color = 1;
                node.parent.parent.color = -1;
                this.rotateRight(node.parent.parent);
                continue;
            }
            node2 = node.parent.parent.left;
            if (node2.color == -1) {
                node.parent.color = 1;
                node2.color = 1;
                node2.parent.color = -1;
                node = node2.parent;
                continue;
            }
            if (node == node.parent.left) {
                node = node.parent;
                this.rotateRight(node);
            }
            node.parent.color = 1;
            node.parent.parent.color = -1;
            this.rotateLeft(node.parent.parent);
        }
        this.root.color = 1;
    }

    private Node lastNode() {
        Node node = this.root;
        while (node.right != nil) {
            node = node.right;
        }
        return node;
    }

    final Node lowestGreaterThan(Object object, boolean bl) {
        if (object == nil) {
            return bl ? this.firstNode() : nil;
        }
        Node node = nil;
        Node node2 = this.root;
        int n = 0;
        while (node2 != nil) {
            node = node2;
            n = this.compare(object, node2.key);
            if (n > 0) {
                node2 = node2.right;
                continue;
            }
            if (n < 0) {
                node2 = node2.left;
                continue;
            }
            return node2;
        }
        return n > 0 ? this.successor(node) : node;
    }

    private Node predecessor(Node node) {
        if (node.left != nil) {
            node = node.left;
            while (node.right != nil) {
                node = node.right;
            }
            return node;
        }
        Node node2 = node.parent;
        while (node == node2.left) {
            node = node2;
            node2 = node.parent;
        }
        return node2;
    }

    final void putKeysLinear(Iterator iterator, int n) {
        this.fabricateTree(n);
        Node node = this.firstNode();
        while (--n >= 0) {
            node.key = iterator.next();
            node.value = "";
            node = this.successor(node);
        }
    }

    final void removeNode(Node node) {
        Node node2;
        Node node3;
        ++this.modCount;
        --this.size;
        if (node.left == nil) {
            node3 = node;
            node2 = node.right;
        } else if (node.right == nil) {
            node3 = node;
            node2 = node.left;
        } else {
            node3 = node.left;
            while (node3.right != nil) {
                node3 = node3.right;
            }
            node2 = node3.left;
            node.key = node3.key;
            node.value = node3.value;
        }
        Node node4 = node3.parent;
        if (node2 != nil) {
            node2.parent = node4;
        }
        if (node4 == nil) {
            this.root = node2;
            return;
        }
        if (node3 == node4.left) {
            node4.left = node2;
        } else {
            node4.right = node2;
        }
        if (node3.color == 1) {
            this.deleteFixup(node2, node4);
        }
    }

    private void rotateLeft(Node node) {
        Node node2 = node.right;
        node.right = node2.left;
        if (node2.left != nil) {
            node2.left.parent = node;
        }
        node2.parent = node.parent;
        if (node.parent != nil) {
            if (node == node.parent.left) {
                node.parent.left = node2;
            } else {
                node.parent.right = node2;
            }
        } else {
            this.root = node2;
        }
        node2.left = node;
        node.parent = node2;
    }

    private void rotateRight(Node node) {
        Node node2 = node.left;
        node.left = node2.right;
        if (node2.right != nil) {
            node2.right.parent = node;
        }
        node2.parent = node.parent;
        if (node.parent != nil) {
            if (node == node.parent.right) {
                node.parent.right = node2;
            } else {
                node.parent.left = node2;
            }
        } else {
            this.root = node2;
        }
        node2.right = node;
        node.parent = node2;
    }

    final Node successor(Node node) {
        if (node.right != nil) {
            node = node.right;
            while (node.left != nil) {
                node = node.left;
            }
            return node;
        }
        Node node2 = node.parent;
        while (node == node2.right) {
            node = node2;
            node2 = node2.parent;
        }
        return node2;
    }

    static {
        TreeMap.nil.parent = nil = new Node(null, null, 1);
        TreeMap.nil.left = nil;
        TreeMap.nil.right = nil;
    }

    private final class SubMap
    extends AbstractMap
    implements SortedMap {
        final Object minKey;
        final Object maxKey;
        private Set entries;

        SubMap(Object object, Object object2) {
            if (object != nil && object2 != nil && TreeMap.this.compare(object, object2) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.minKey = object;
            this.maxKey = object2;
        }

        boolean keyInRange(Object object) {
            return !(this.minKey != nil && TreeMap.this.compare(object, this.minKey) < 0 || this.maxKey != nil && TreeMap.this.compare(object, this.maxKey) >= 0);
        }

        public void clear() {
            Node node = TreeMap.this.lowestGreaterThan(this.minKey, true);
            Node node2 = TreeMap.this.lowestGreaterThan(this.maxKey, false);
            while (node != node2) {
                Node node3 = node;
                node = TreeMap.this.successor(node3);
                TreeMap.this.removeNode(node3);
            }
        }

        public Comparator comparator() {
            return TreeMap.this.comparator;
        }

        public boolean containsKey(Object object) {
            return this.keyInRange(object) && TreeMap.this.containsKey(object);
        }

        public boolean containsValue(Object object) {
            Node node = TreeMap.this.lowestGreaterThan(this.minKey, true);
            Node node2 = TreeMap.this.lowestGreaterThan(this.maxKey, false);
            while (node != node2) {
                if (AbstractMap.equals(object, node.getValue())) {
                    return true;
                }
                node = TreeMap.this.successor(node);
            }
            return false;
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = new AbstractSet(){

                    public int size() {
                        return SubMap.this.size();
                    }

                    public Iterator iterator() {
                        Node node = TreeMap.this.lowestGreaterThan(SubMap.this.minKey, true);
                        Node node2 = TreeMap.this.lowestGreaterThan(SubMap.this.maxKey, false);
                        return new TreeIterator(2, node, node2);
                    }

                    public void clear() {
                        SubMap.this.clear();
                    }

                    public boolean contains(Object object) {
                        if (!(object instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry entry = (Map.Entry)object;
                        Object object2 = entry.getKey();
                        if (!SubMap.this.keyInRange(object2)) {
                            return false;
                        }
                        Node node = TreeMap.this.getNode(object2);
                        return node != nil && AbstractCollection.equals(entry.getValue(), node.value);
                    }

                    public boolean remove(Object object) {
                        if (!(object instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry entry = (Map.Entry)object;
                        Object object2 = entry.getKey();
                        if (!SubMap.this.keyInRange(object2)) {
                            return false;
                        }
                        Node node = TreeMap.this.getNode(object2);
                        if (node != nil && AbstractCollection.equals(entry.getValue(), node.value)) {
                            TreeMap.this.removeNode(node);
                            return true;
                        }
                        return false;
                    }
                };
            }
            return this.entries;
        }

        public Object firstKey() {
            Node node = TreeMap.this.lowestGreaterThan(this.minKey, true);
            if (node == nil || !this.keyInRange(node.key)) {
                throw new NoSuchElementException();
            }
            return node.key;
        }

        public Object get(Object object) {
            if (this.keyInRange(object)) {
                return TreeMap.this.get(object);
            }
            return null;
        }

        public SortedMap headMap(Object object) {
            if (!this.keyInRange(object)) {
                throw new IllegalArgumentException("key outside range");
            }
            return new SubMap(this.minKey, object);
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = new AbstractSet(){

                    public int size() {
                        return SubMap.this.size();
                    }

                    public Iterator iterator() {
                        Node node = TreeMap.this.lowestGreaterThan(SubMap.this.minKey, true);
                        Node node2 = TreeMap.this.lowestGreaterThan(SubMap.this.maxKey, false);
                        return new TreeIterator(0, node, node2);
                    }

                    public void clear() {
                        SubMap.this.clear();
                    }

                    public boolean contains(Object object) {
                        if (!SubMap.this.keyInRange(object)) {
                            return false;
                        }
                        return TreeMap.this.getNode(object) != nil;
                    }

                    public boolean remove(Object object) {
                        if (!SubMap.this.keyInRange(object)) {
                            return false;
                        }
                        Node node = TreeMap.this.getNode(object);
                        if (node != nil) {
                            TreeMap.this.removeNode(node);
                            return true;
                        }
                        return false;
                    }
                };
            }
            return this.keys;
        }

        public Object lastKey() {
            Node node = TreeMap.this.highestLessThan(this.maxKey);
            if (node == nil || !this.keyInRange(node.key)) {
                throw new NoSuchElementException();
            }
            return node.key;
        }

        public Object put(Object object, Object object2) {
            if (!this.keyInRange(object)) {
                throw new IllegalArgumentException("Key outside range");
            }
            return TreeMap.this.put(object, object2);
        }

        public Object remove(Object object) {
            if (this.keyInRange(object)) {
                return TreeMap.this.remove(object);
            }
            return null;
        }

        public int size() {
            Node node = TreeMap.this.lowestGreaterThan(this.minKey, true);
            Node node2 = TreeMap.this.lowestGreaterThan(this.maxKey, false);
            int n = 0;
            while (node != node2) {
                ++n;
                node = TreeMap.this.successor(node);
            }
            return n;
        }

        public SortedMap subMap(Object object, Object object2) {
            if (!this.keyInRange(object) || !this.keyInRange(object2)) {
                throw new IllegalArgumentException("key outside range");
            }
            return new SubMap(object, object2);
        }

        public SortedMap tailMap(Object object) {
            if (!this.keyInRange(object)) {
                throw new IllegalArgumentException("key outside range");
            }
            return new SubMap(object, this.maxKey);
        }

        public Collection values() {
            if (this.values == null) {
                this.values = new AbstractCollection(){

                    public int size() {
                        return SubMap.this.size();
                    }

                    public Iterator iterator() {
                        Node node = TreeMap.this.lowestGreaterThan(SubMap.this.minKey, true);
                        Node node2 = TreeMap.this.lowestGreaterThan(SubMap.this.maxKey, false);
                        return new TreeIterator(1, node, node2);
                    }

                    public void clear() {
                        SubMap.this.clear();
                    }
                };
            }
            return this.values;
        }
    }

    private final class TreeIterator
    implements Iterator {
        private final int type;
        private int knownMod;
        private Node last;
        private Node next;
        private final Node max;

        TreeIterator(int n) {
            this.knownMod = TreeMap.this.modCount;
            this.type = n;
            this.next = TreeMap.this.firstNode();
            this.max = nil;
        }

        TreeIterator(int n, Node node, Node node2) {
            this.knownMod = TreeMap.this.modCount;
            this.type = n;
            this.next = node;
            this.max = node2;
        }

        public boolean hasNext() {
            return this.next != this.max;
        }

        public Object next() {
            if (this.next == this.max) {
                throw new NoSuchElementException();
            }
            this.last = this.next;
            this.next = TreeMap.this.successor(this.last);
            if (this.type == 1) {
                return this.last.value;
            }
            if (this.type == 0) {
                return this.last.key;
            }
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            TreeMap.this.removeNode(this.last);
            this.last = null;
            ++this.knownMod;
        }
    }

    private static final class Node
    extends AbstractMap.BasicMapEntry {
        int color;
        Node left = nil;
        Node right = nil;
        Node parent = nil;

        Node(Object object, Object object2, int n) {
            super(object, object2);
            this.color = n;
        }
    }
}

