/*
 * Decompiled with CFR 0.152.
 */
package moio.util;

import moio.util.Comparable;
import moio.util.Number;
import moio.util.NumberFormatException;
import moio.util.System;
import waba.sys.Convert;

public final class Integer
extends Number
implements Comparable {
    private static final long serialVersionUID = 1360826667806852920L;
    public static final int MIN_VALUE = java.lang.Integer.MIN_VALUE;
    public static final int MAX_VALUE = java.lang.Integer.MAX_VALUE;
    public static final int SIZE = 32;
    private static final int MIN_CACHE = -128;
    private static final int MAX_CACHE = 127;
    private static Integer[] intCache = new Integer[256];
    private final int value;

    public Integer(int n) {
        this.value = n;
    }

    public Integer(String string) {
        this.value = Integer.parseInt(string, 10, false);
    }

    public static String toString(int n, int n2) {
        return n + "";
    }

    public static String toString(int n) {
        return String.valueOf(n);
    }

    public static int parseInt(String string, int n) {
        return Integer.parseInt(string, n, false);
    }

    public static int parseInt(String string) {
        return Integer.parseInt(string, 10, false);
    }

    public static Integer valueOf(String string, int n) {
        return new Integer(Integer.parseInt(string, n, false));
    }

    public static Integer valueOf(String string) {
        return new Integer(Integer.parseInt(string, 10, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer valueOf(int n) {
        if (n < -128 || n > 127) {
            return new Integer(n);
        }
        Integer[] integerArray = intCache;
        synchronized (intCache) {
            if (intCache[n - -128] == null) {
                Integer.intCache[n - -128] = new Integer(n);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return intCache[n - -128];
        }
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Integer && this.value == ((Integer)object).value;
    }

    public static Integer getInteger(String string) {
        return Integer.getInteger(string, null);
    }

    public static Integer getInteger(String string, int n) {
        Integer integer = Integer.getInteger(string, null);
        return integer == null ? new Integer(n) : integer;
    }

    public static Integer getInteger(String string, Integer integer) {
        if (string == null || "".equals(string)) {
            return integer;
        }
        if ((string = System.getProperty(string)) == null) {
            return integer;
        }
        try {
            return Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            return integer;
        }
    }

    public static Integer decode(String string) {
        return new Integer(Integer.parseInt(string, 10, true));
    }

    public int compareTo(Integer integer) {
        if (this.value == integer.value) {
            return 0;
        }
        return this.value > integer.value ? 1 : -1;
    }

    public int compareTo(Object object) {
        return this.compareTo((Integer)object);
    }

    public static int bitCount(int n) {
        n = (n >> 1 & 0x55555555) + (n & 0x55555555);
        n = (n >> 2 & 0x33333333) + (n & 0x33333333);
        n = (n >> 4 & 0xF0F0F0F) + (n & 0xF0F0F0F);
        n = (n >> 8 & 0xFF00FF) + (n & 0xFF00FF);
        return (n >> 16 & 0xFFFF) + (n & 0xFFFF);
    }

    public static int rotateLeft(int n, int n2) {
        return n << n2 | n >>> -n2;
    }

    public static int rotateRight(int n, int n2) {
        return n << -n2 | n >>> n2;
    }

    public static int highestOneBit(int n) {
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        return n ^ n >>> 1;
    }

    public static int numberOfLeadingZeros(int n) {
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        return Integer.bitCount(~n);
    }

    public static int lowestOneBit(int n) {
        return n & -n;
    }

    public static int numberOfTrailingZeros(int n) {
        return Integer.bitCount((n & -n) - 1);
    }

    public static int signum(int n) {
        return n < 0 ? -1 : (n > 0 ? 1 : 0);
    }

    public static int reverseBytes(int n) {
        return n >> 24 & 0xFF | n >> 8 & 0xFF00 | n << 8 & 0xFF0000 | n << 24 & 0xFF000000;
    }

    public static int reverse(int n) {
        n = (n >> 1 & 0x55555555) + (n << 1 & 0xAAAAAAAA);
        n = (n >> 2 & 0x33333333) + (n << 2 & 0xCCCCCCCC);
        n = (n >> 4 & 0xF0F0F0F) + (n << 4 & 0xF0F0F0F0);
        n = (n >> 8 & 0xFF00FF) + (n << 8 & 0xFF00FF00);
        return (n >> 16 & 0xFFFF) + (n << 16 & 0xFFFF0000);
    }

    static int parseInt(String string, int n, boolean bl) {
        return Convert.toInt((String)string);
    }
}

