/*
 * Decompiled with CFR 0.152.
 */
package moio.util;

import moio.util.AbstractCollection;
import moio.util.AbstractMap;
import moio.util.AbstractSet;
import moio.util.Arrays;
import moio.util.Cloneable;
import moio.util.Collection;
import moio.util.IllegalArgumentException;
import moio.util.IllegalStateException;
import moio.util.Iterator;
import moio.util.Map;
import moio.util.NoSuchElementException;
import moio.util.Serializable;
import moio.util.Set;

public class IdentityHashMap
extends AbstractMap
implements Map,
Serializable,
Cloneable {
    private static final int DEFAULT_CAPACITY = 21;
    static final Object tombstone = new Object();
    static final Object emptyslot = new Object();
    private static final long serialVersionUID = 8188218128353913216L;
    int size;
    transient Object[] table;
    transient int modCount;
    private transient Set entries;
    private transient int threshold;

    public IdentityHashMap() {
        this(21);
    }

    public IdentityHashMap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n < 2) {
            n = 2;
        }
        this.table = new Object[n << 1];
        Arrays.fill(this.table, emptyslot);
        this.threshold = (n >> 2) * 3;
    }

    public IdentityHashMap(Map map) {
        this(Math.max(map.size() << 1, 21));
        this.putAll(map);
    }

    public void clear() {
        if (this.size != 0) {
            ++this.modCount;
            Arrays.fill(this.table, emptyslot);
            this.size = 0;
        }
    }

    public boolean containsKey(Object object) {
        return object == this.table[this.hash(object)];
    }

    public boolean containsValue(Object object) {
        for (int i = this.table.length - 1; i > 0; i -= 2) {
            if (this.table[i] != object) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet(){

                public int size() {
                    return IdentityHashMap.this.size;
                }

                public Iterator iterator() {
                    return new IdentityIterator(2);
                }

                public void clear() {
                    IdentityHashMap.this.clear();
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    return entry.getValue() == IdentityHashMap.this.table[IdentityHashMap.this.hash(entry.getKey()) + 1];
                }

                public int hashCode() {
                    return IdentityHashMap.this.hashCode();
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Object object2 = ((Map.Entry)object).getKey();
                    int n = IdentityHashMap.this.hash(object2);
                    if (IdentityHashMap.this.table[n] == object2) {
                        --IdentityHashMap.this.size;
                        ++IdentityHashMap.this.modCount;
                        IdentityHashMap.this.table[n] = tombstone;
                        IdentityHashMap.this.table[n + 1] = tombstone;
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.entries;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public Object get(Object object) {
        int n = this.hash(object);
        return this.table[n] == object ? this.table[n + 1] : null;
    }

    public int hashCode() {
        int n = 0;
        for (int i = this.table.length - 2; i >= 0; i -= 2) {
            Object object = this.table[i];
            if (object == emptyslot || object == tombstone) continue;
            n += object.hashCode() ^ this.table[i + 1].hashCode();
        }
        return n;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet(){

                public int size() {
                    return IdentityHashMap.this.size;
                }

                public Iterator iterator() {
                    return new IdentityIterator(0);
                }

                public void clear() {
                    IdentityHashMap.this.clear();
                }

                public boolean contains(Object object) {
                    return IdentityHashMap.this.containsKey(object);
                }

                public int hashCode() {
                    int n = 0;
                    for (int i = IdentityHashMap.this.table.length - 2; i >= 0; i -= 2) {
                        Object object = IdentityHashMap.this.table[i];
                        if (object == emptyslot || object == tombstone) continue;
                        n += object.hashCode();
                    }
                    return n;
                }

                public boolean remove(Object object) {
                    int n = IdentityHashMap.this.hash(object);
                    if (IdentityHashMap.this.table[n] == object) {
                        --IdentityHashMap.this.size;
                        ++IdentityHashMap.this.modCount;
                        IdentityHashMap.this.table[n] = tombstone;
                        IdentityHashMap.this.table[n + 1] = tombstone;
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.keys;
    }

    public Object put(Object object, Object object2) {
        int n;
        if (this.size > this.threshold) {
            Object[] objectArray = this.table;
            this.table = new Object[objectArray.length * 2 + 2];
            Arrays.fill(this.table, emptyslot);
            this.size = 0;
            this.threshold = (this.table.length >>> 3) * 3;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                Object object3 = objectArray[i];
                if (object3 == tombstone || object3 == emptyslot) continue;
                this.put(object3, objectArray[i + 1]);
            }
        }
        if (this.table[n = this.hash(object)] == object) {
            Object object4 = this.table[n + 1];
            this.table[n + 1] = object2;
            return object4;
        }
        ++this.modCount;
        ++this.size;
        this.table[n] = object;
        this.table[n + 1] = object2;
        return null;
    }

    public void putAll(Map map) {
        super.putAll(map);
    }

    public Object remove(Object object) {
        int n = this.hash(object);
        if (this.table[n] == object) {
            ++this.modCount;
            --this.size;
            Object object2 = this.table[n + 1];
            this.table[n] = tombstone;
            this.table[n + 1] = tombstone;
            return object2;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public int size() {
                    return IdentityHashMap.this.size;
                }

                public Iterator iterator() {
                    return new IdentityIterator(1);
                }

                public void clear() {
                    IdentityHashMap.this.clear();
                }

                public boolean remove(Object object) {
                    for (int i = IdentityHashMap.this.table.length - 1; i > 0; i -= 2) {
                        if (IdentityHashMap.this.table[i] != object) continue;
                        ++IdentityHashMap.this.modCount;
                        IdentityHashMap.this.table[i - 1] = tombstone;
                        IdentityHashMap.this.table[i] = tombstone;
                        --IdentityHashMap.this.size;
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.values;
    }

    int hash(Object object) {
        int n = Math.abs(object.hashCode() % (this.table.length >> 1)) << 1;
        int n2 = -1;
        int n3 = n;
        do {
            if (this.table[n] == object) {
                return n;
            }
            if (this.table[n] == emptyslot) break;
            if (this.table[n] == tombstone && n2 < 0) {
                n2 = n;
            }
            if ((n -= 2) >= 0) continue;
            n = this.table.length - 2;
        } while (n != n3);
        return n2 < 0 ? n : n2;
    }

    private final class IdentityEntry
    implements Map.Entry {
        final int loc;
        final int knownMod;

        IdentityEntry(int n) {
            this.knownMod = IdentityHashMap.this.modCount;
            this.loc = n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return IdentityHashMap.this.table[this.loc] == entry.getKey() && IdentityHashMap.this.table[this.loc + 1] == entry.getValue();
        }

        public Object getKey() {
            return IdentityHashMap.this.table[this.loc];
        }

        public Object getValue() {
            return IdentityHashMap.this.table[this.loc + 1];
        }

        public int hashCode() {
            return IdentityHashMap.this.table[this.loc].hashCode() ^ IdentityHashMap.this.table[this.loc + 1].hashCode();
        }

        public Object setValue(Object object) {
            Object object2 = IdentityHashMap.this.table[this.loc + 1];
            IdentityHashMap.this.table[this.loc + 1] = object;
            return object2;
        }

        public String toString() {
            return IdentityHashMap.this.table[this.loc] + "=" + IdentityHashMap.this.table[this.loc + 1];
        }
    }

    private class IdentityIterator
    implements Iterator {
        final int type;
        int knownMod;
        int count;
        int loc;

        IdentityIterator(int n) {
            this.knownMod = IdentityHashMap.this.modCount;
            this.count = IdentityHashMap.this.size;
            this.loc = IdentityHashMap.this.table.length;
            this.type = n;
        }

        public boolean hasNext() {
            return this.count > 0;
        }

        public Object next() {
            Object object;
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            do {
                this.loc -= 2;
            } while ((object = IdentityHashMap.this.table[this.loc]) == emptyslot || object == tombstone);
            return this.type == 0 ? object : (this.type == 1 ? IdentityHashMap.this.table[this.loc + 1] : new IdentityEntry(this.loc));
        }

        public void remove() {
            if (this.loc == IdentityHashMap.this.table.length || IdentityHashMap.this.table[this.loc] == tombstone) {
                throw new IllegalStateException();
            }
            ++IdentityHashMap.this.modCount;
            --IdentityHashMap.this.size;
            IdentityHashMap.this.table[this.loc] = tombstone;
            IdentityHashMap.this.table[this.loc + 1] = tombstone;
            ++this.knownMod;
        }
    }
}

