/*
 * Decompiled with CFR 0.152.
 */
package moio.util;

import moio.util.AbstractCollection;
import moio.util.AbstractList;
import moio.util.AbstractMap;
import moio.util.AbstractSet;
import moio.util.ArrayList;
import moio.util.Arrays;
import moio.util.Collection;
import moio.util.Collections;
import moio.util.Comparable;
import moio.util.Comparator;
import moio.util.Enumeration;
import moio.util.IllegalArgumentException;
import moio.util.Iterator;
import moio.util.List;
import moio.util.ListIterator;
import moio.util.Map;
import moio.util.NoSuchElementException;
import moio.util.RandomAccess;
import moio.util.Serializable;
import moio.util.Set;
import moio.util.SortedMap;
import moio.util.SortedSet;
import moio.util.UnsupportedOperationException;
import waba.util.Random;

public class Collections {
    private static final int LARGE_LIST_SIZE = 16;
    public static final Set EMPTY_SET = new EmptySet();
    public static final List EMPTY_LIST = new EmptyList();
    public static final Map EMPTY_MAP = new EmptyMap();
    private static final ReverseComparator rcInstance = new ReverseComparator();
    private static Random defaultRandom = null;
    static /* synthetic */ Class class$moio$util$Collections;

    private static boolean isSequential(List list) {
        return !(list instanceof RandomAccess) && list.size() > 16;
    }

    private Collections() {
    }

    static final int compare(Object object, Object object2, Comparator comparator) {
        return comparator == null ? ((Comparable)object).compareTo(object2) : comparator.compare(object, object2);
    }

    public static int binarySearch(List list, Object object) {
        return Collections.binarySearch(list, object, null);
    }

    public static int binarySearch(List list, Object object, Comparator comparator) {
        int n = 0;
        int n2 = 0;
        int n3 = list.size() - 1;
        if (Collections.isSequential(list)) {
            ListIterator listIterator = list.listIterator();
            int n4 = 0;
            Object object2 = listIterator.next();
            boolean bl = true;
            while (n2 <= n3) {
                n = n2 + n3 >> 1;
                if (n4 < n) {
                    if (!bl) {
                        listIterator.next();
                    }
                    while (n4 != n) {
                        ++n4;
                        object2 = listIterator.next();
                    }
                    bl = true;
                } else {
                    if (bl) {
                        listIterator.previous();
                    }
                    while (n4 != n) {
                        --n4;
                        object2 = listIterator.previous();
                    }
                    bl = false;
                }
                int n5 = Collections.compare(object, object2, comparator);
                if (n5 == 0) {
                    return n;
                }
                if (n5 < 0) {
                    n3 = n - 1;
                    continue;
                }
                n2 = ++n;
            }
        } else {
            while (n2 <= n3) {
                n = n2 + n3 >> 1;
                int n6 = Collections.compare(object, list.get(n), comparator);
                if (n6 == 0) {
                    return n;
                }
                if (n6 < 0) {
                    n3 = n - 1;
                    continue;
                }
                n2 = ++n;
            }
        }
        return -n - 1;
    }

    public static void copy(List list, List list2) {
        int n = list2.size();
        if (list.size() < n) {
            throw new IndexOutOfBoundsException("Source does not fit in dest");
        }
        Iterator iterator = list2.iterator();
        ListIterator listIterator = list.listIterator();
        while (--n >= 0) {
            listIterator.next();
            listIterator.set(iterator.next());
        }
    }

    public static Enumeration enumeration(Collection collection) {
        final Iterator iterator = collection.iterator();
        return new Enumeration(){

            public final boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public final Object nextElement() {
                return iterator.next();
            }
        };
    }

    public static void fill(List list, Object object) {
        ListIterator listIterator = list.listIterator();
        for (int i = list.size() - 1; i >= 0; --i) {
            listIterator.next();
            listIterator.set(object);
        }
    }

    public static int indexOfSubList(List list, List list2) {
        int n = list.size();
        int n2 = 0;
        for (int i = list2.size(); i <= n; ++i) {
            if (((Object)list.subList(n2, i)).equals(list2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static int lastIndexOfSubList(List list, List list2) {
        int n = list.size();
        int n2 = n - list2.size();
        int n3 = n;
        while (n2 >= 0) {
            if (((Object)list.subList(n2, n3)).equals(list2)) {
                return n2;
            }
            --n2;
            --n3;
        }
        return -1;
    }

    public static ArrayList list(Enumeration enumeration) {
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    public static Object max(Collection collection) {
        return Collections.max(collection, null);
    }

    public static Object max(Collection collection, Comparator comparator) {
        Iterator iterator = collection.iterator();
        Object object = iterator.next();
        int n = collection.size();
        for (int i = 1; i < n; ++i) {
            Object object2 = iterator.next();
            if (Collections.compare(object, object2, comparator) >= 0) continue;
            object = object2;
        }
        return object;
    }

    public static Object min(Collection collection) {
        return Collections.min(collection, null);
    }

    public static Object min(Collection collection, Comparator comparator) {
        Iterator iterator = collection.iterator();
        Object object = iterator.next();
        int n = collection.size();
        for (int i = 1; i < n; ++i) {
            Object object2 = iterator.next();
            if (Collections.compare(object, object2, comparator) <= 0) continue;
            object = object2;
        }
        return object;
    }

    public static List nCopies(int n, Object object) {
        return new CopiesList(n, object);
    }

    public static boolean replaceAll(List list, Object object, Object object2) {
        ListIterator listIterator = list.listIterator();
        boolean bl = false;
        int n = list.size();
        while (--n >= 0) {
            if (!AbstractCollection.equals(object, listIterator.next())) continue;
            listIterator.set(object2);
            bl = true;
        }
        return bl;
    }

    public static void reverse(List list) {
        int n;
        ListIterator listIterator = list.listIterator();
        int n2 = 1;
        ListIterator listIterator2 = list.listIterator(n);
        for (n = list.size(); n2 < n; ++n2, --n) {
            Object object = listIterator.next();
            listIterator.set(listIterator2.previous());
            listIterator2.set(object);
        }
    }

    public static Comparator reverseOrder() {
        return rcInstance;
    }

    public static void rotate(List list, int n) {
        int n2 = list.size();
        if (n2 == 0) {
            return;
        }
        if ((n %= n2) == 0) {
            return;
        }
        if (n < 0) {
            n += n2;
        }
        if (Collections.isSequential(list)) {
            Collections.reverse(list);
            Collections.reverse(list.subList(0, n));
            Collections.reverse(list.subList(n, n2));
        } else {
            int n3 = n2;
            int n4 = n;
            int n5 = n3 % n4;
            while (n5 != 0) {
                n3 = n4;
                n4 = n5;
                n5 = n3 % n4;
            }
            while (--n4 >= 0) {
                Object object = list.get(n4);
                int n6 = n4 + n;
                while (n6 != n4) {
                    object = list.set(n6, object);
                    n6 = (n6 + n) % n2;
                }
                list.set(n4, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shuffle(List list) {
        if (defaultRandom == null) {
            Class clazz = class$moio$util$Collections == null ? (class$moio$util$Collections = Collections.class$("moio.util.Collections")) : class$moio$util$Collections;
            synchronized (clazz) {
                if (defaultRandom == null) {
                    defaultRandom = new Random();
                }
            }
        }
        Collections.shuffle(list, defaultRandom);
    }

    public static void shuffle(List list, Random random) {
        int n = list.size();
        ListIterator listIterator = list.listIterator(n);
        boolean bl = Collections.isSequential(list);
        Object[] objectArray = null;
        if (bl) {
            objectArray = list.toArray();
        }
        for (int i = n - 1; i > 0; --i) {
            Object object;
            int n2 = random.nextInt(i + 1);
            if (bl) {
                object = objectArray[n2];
                objectArray[n2] = listIterator.previous();
            } else {
                object = list.set(n2, listIterator.previous());
            }
            listIterator.set(object);
        }
    }

    public static Set singleton(Object object) {
        return new SingletonSet(object);
    }

    public static List singletonList(Object object) {
        return new SingletonList(object);
    }

    public static Map singletonMap(Object object, Object object2) {
        return new SingletonMap(object, object2);
    }

    public static void sort(List list) {
        Collections.sort(list, null);
    }

    public static void sort(List list, Comparator comparator) {
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray, comparator);
        ListIterator listIterator = list.listIterator();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            listIterator.next();
            listIterator.set(objectArray[i]);
        }
    }

    public static void swap(List list, int n, int n2) {
        list.set(n, list.set(n2, list.get(n)));
    }

    public static Collection synchronizedCollection(Collection collection) {
        return new SynchronizedCollection(collection);
    }

    public static List synchronizedList(List list) {
        if (list instanceof RandomAccess) {
            return new SynchronizedRandomAccessList(list);
        }
        return new SynchronizedList(list);
    }

    public static Map synchronizedMap(Map map) {
        return new SynchronizedMap(map);
    }

    public static Set synchronizedSet(Set set) {
        return new SynchronizedSet(set);
    }

    public static SortedMap synchronizedSortedMap(SortedMap sortedMap) {
        return new SynchronizedSortedMap(sortedMap);
    }

    public static SortedSet synchronizedSortedSet(SortedSet sortedSet) {
        return new SynchronizedSortedSet(sortedSet);
    }

    public static Collection unmodifiableCollection(Collection collection) {
        return new UnmodifiableCollection(collection);
    }

    public static List unmodifiableList(List list) {
        if (list instanceof RandomAccess) {
            return new UnmodifiableRandomAccessList(list);
        }
        return new UnmodifiableList(list);
    }

    public static Map unmodifiableMap(Map map) {
        return new UnmodifiableMap(map);
    }

    public static Set unmodifiableSet(Set set) {
        return new UnmodifiableSet(set);
    }

    public static SortedMap unmodifiableSortedMap(SortedMap sortedMap) {
        return new UnmodifiableSortedMap(sortedMap);
    }

    public static SortedSet unmodifiableSortedSet(SortedSet sortedSet) {
        return new UnmodifiableSortedSet(sortedSet);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class UnmodifiableSortedSet
    extends UnmodifiableSet
    implements SortedSet {
        private static final long serialVersionUID = -4929149591599911165L;
        private SortedSet ss;

        UnmodifiableSortedSet(SortedSet sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        public Comparator comparator() {
            return this.ss.comparator();
        }

        public Object first() {
            return this.ss.first();
        }

        public SortedSet headSet(Object object) {
            return new UnmodifiableSortedSet(this.ss.headSet(object));
        }

        public Object last() {
            return this.ss.last();
        }

        public SortedSet subSet(Object object, Object object2) {
            return new UnmodifiableSortedSet(this.ss.subSet(object, object2));
        }

        public SortedSet tailSet(Object object) {
            return new UnmodifiableSortedSet(this.ss.tailSet(object));
        }
    }

    private static class UnmodifiableSortedMap
    extends UnmodifiableMap
    implements SortedMap {
        private static final long serialVersionUID = -8806743815996713206L;
        private final SortedMap sm;

        UnmodifiableSortedMap(SortedMap sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        public Comparator comparator() {
            return this.sm.comparator();
        }

        public Object firstKey() {
            return this.sm.firstKey();
        }

        public SortedMap headMap(Object object) {
            return new UnmodifiableSortedMap(this.sm.headMap(object));
        }

        public Object lastKey() {
            return this.sm.lastKey();
        }

        public SortedMap subMap(Object object, Object object2) {
            return new UnmodifiableSortedMap(this.sm.subMap(object, object2));
        }

        public SortedMap tailMap(Object object) {
            return new UnmodifiableSortedMap(this.sm.tailMap(object));
        }
    }

    private static class UnmodifiableSet
    extends UnmodifiableCollection
    implements Set {
        private static final long serialVersionUID = -9215047833775013803L;

        UnmodifiableSet(Set set) {
            super(set);
        }

        public boolean equals(Object object) {
            return ((Object)this.c).equals(object);
        }

        public int hashCode() {
            return ((Object)this.c).hashCode();
        }
    }

    private static class UnmodifiableMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        private final Map m;
        private transient Set entries;
        private transient Set keys;
        private transient Collection values;

        UnmodifiableMap(Map map) {
            this.m = map;
            if (map == null) {
                throw new NullPointerException();
            }
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object object) {
            return this.m.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = new UnmodifiableEntrySet(this.m.entrySet());
            }
            return this.entries;
        }

        public boolean equals(Object object) {
            return ((Object)this.m).equals(object);
        }

        public Object get(Object object) {
            return this.m.get(object);
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return ((Object)this.m).hashCode();
        }

        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = new UnmodifiableSet(this.m.keySet());
            }
            return this.keys;
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.m.size();
        }

        public String toString() {
            return this.m.toString();
        }

        public Collection values() {
            if (this.values == null) {
                this.values = new UnmodifiableCollection(this.m.values());
            }
            return this.values;
        }

        private static final class UnmodifiableEntrySet
        extends UnmodifiableSet
        implements Serializable {
            private static final long serialVersionUID = 7854390611657943733L;

            UnmodifiableEntrySet(Set set) {
                super(set);
            }

            public Iterator iterator() {
                return new UnmodifiableIterator(this.c.iterator()){

                    public Object next() {
                        final Map.Entry entry = (Map.Entry)super.next();
                        return new Map.Entry(){

                            public boolean equals(Object object) {
                                return ((Object)entry).equals(object);
                            }

                            public Object getKey() {
                                return entry.getKey();
                            }

                            public Object getValue() {
                                return entry.getValue();
                            }

                            public int hashCode() {
                                return ((Object)entry).hashCode();
                            }

                            public Object setValue(Object object) {
                                throw new UnsupportedOperationException();
                            }

                            public String toString() {
                                return entry.toString();
                            }
                        };
                    }
                };
            }
        }
    }

    private static final class UnmodifiableListIterator
    extends UnmodifiableIterator
    implements ListIterator {
        private final ListIterator li;

        UnmodifiableListIterator(ListIterator listIterator) {
            super(listIterator);
            this.li = listIterator;
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean hasPrevious() {
            return this.li.hasPrevious();
        }

        public int nextIndex() {
            return this.li.nextIndex();
        }

        public Object previous() {
            return this.li.previous();
        }

        public int previousIndex() {
            return this.li.previousIndex();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class UnmodifiableRandomAccessList
    extends UnmodifiableList
    implements RandomAccess {
        private static final long serialVersionUID = -2542308836966382001L;

        UnmodifiableRandomAccessList(List list) {
            super(list);
        }
    }

    private static class UnmodifiableList
    extends UnmodifiableCollection
    implements List {
        private static final long serialVersionUID = -283967356065247728L;
        final List list;

        UnmodifiableList(List list) {
            super(list);
            this.list = list;
        }

        public void add(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int n, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object object) {
            return ((Object)this.list).equals(object);
        }

        public Object get(int n) {
            return this.list.get(n);
        }

        public int hashCode() {
            return ((Object)this.list).hashCode();
        }

        public int indexOf(Object object) {
            return this.list.indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return this.list.lastIndexOf(object);
        }

        public ListIterator listIterator() {
            return new UnmodifiableListIterator(this.list.listIterator());
        }

        public ListIterator listIterator(int n) {
            return new UnmodifiableListIterator(this.list.listIterator(n));
        }

        public Object remove(int n) {
            throw new UnsupportedOperationException();
        }

        public Object set(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public List subList(int n, int n2) {
            return Collections.unmodifiableList(this.list.subList(n, n2));
        }
    }

    private static class UnmodifiableIterator
    implements Iterator {
        private final Iterator i;

        UnmodifiableIterator(Iterator iterator) {
            this.i = iterator;
        }

        public Object next() {
            return this.i.next();
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnmodifiableCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        final Collection c;

        UnmodifiableCollection(Collection collection) {
            this.c = collection;
            if (collection == null) {
                throw new NullPointerException();
            }
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object object) {
            return this.c.contains(object);
        }

        public boolean containsAll(Collection collection) {
            return this.c.containsAll(collection);
        }

        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        public Iterator iterator() {
            return new UnmodifiableIterator(this.c.iterator());
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.c.size();
        }

        public Object[] toArray() {
            return this.c.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.c.toArray(objectArray);
        }

        public String toString() {
            return this.c.toString();
        }
    }

    private static final class SynchronizedSortedSet
    extends SynchronizedSet
    implements SortedSet {
        private static final long serialVersionUID = 8695801310862127406L;
        private final SortedSet ss;

        SynchronizedSortedSet(SortedSet sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        SynchronizedSortedSet(Object object, SortedSet sortedSet) {
            super(object, sortedSet);
            this.ss = sortedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object first() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedSet headSet(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return new SynchronizedSortedSet(this.mutex, this.ss.headSet(object));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object last() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.last();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedSet subSet(Object object, Object object2) {
            Object object3 = this.mutex;
            synchronized (object3) {
                return new SynchronizedSortedSet(this.mutex, this.ss.subSet(object, object2));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedSet tailSet(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return new SynchronizedSortedSet(this.mutex, this.ss.tailSet(object));
            }
        }
    }

    private static final class SynchronizedSortedMap
    extends SynchronizedMap
    implements SortedMap {
        private static final long serialVersionUID = -8798146769416483793L;
        private final SortedMap sm;

        SynchronizedSortedMap(SortedMap sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        SynchronizedSortedMap(Object object, SortedMap sortedMap) {
            super(object, sortedMap);
            this.sm = sortedMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedMap headMap(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return new SynchronizedSortedMap(this.mutex, this.sm.headMap(object));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.lastKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedMap subMap(Object object, Object object2) {
            Object object3 = this.mutex;
            synchronized (object3) {
                return new SynchronizedSortedMap(this.mutex, this.sm.subMap(object, object2));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedMap tailMap(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return new SynchronizedSortedMap(this.mutex, this.sm.tailMap(object));
            }
        }
    }

    static class SynchronizedSet
    extends SynchronizedCollection
    implements Set {
        private static final long serialVersionUID = 487447009682186044L;

        SynchronizedSet(Set set) {
            super(set);
        }

        SynchronizedSet(Object object, Set set) {
            super(object, set);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return ((Object)this.c).equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.c).hashCode();
            }
        }
    }

    private static class SynchronizedMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private final Map m;
        final Object mutex;
        private transient Set entries;
        private transient Set keys;
        private transient Collection values;

        SynchronizedMap(Map map) {
            this.m = map;
            this.mutex = this;
            if (map == null) {
                throw new NullPointerException();
            }
        }

        SynchronizedMap(Object object, Map map) {
            this.m = map;
            this.mutex = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.m.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.containsKey(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsValue(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.containsValue(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set entrySet() {
            if (this.entries == null) {
                Object object = this.mutex;
                synchronized (object) {
                    this.entries = new SynchronizedSet(this.mutex, this.m.entrySet()){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Iterator iterator() {
                            Object object = this.mutex;
                            synchronized (object) {
                                return new SynchronizedIterator(this.mutex, this.c.iterator()){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public Object next() {
                                        Object object = this.mutex;
                                        synchronized (object) {
                                            class SynchronizedMapEntry
                                            implements Map.Entry {
                                                final Map.Entry e;
                                                private final /* synthetic */ SynchronizedMap this$0;

                                                SynchronizedMapEntry(SynchronizedMap synchronizedMap, Object object) {
                                                    this.this$0 = synchronizedMap;
                                                    this.e = (Map.Entry)object;
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                public boolean equals(Object object) {
                                                    Object object2 = this.this$0.mutex;
                                                    synchronized (object2) {
                                                        return ((Object)this.e).equals(object);
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                public Object getKey() {
                                                    Object object = this.this$0.mutex;
                                                    synchronized (object) {
                                                        return this.e.getKey();
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                public Object getValue() {
                                                    Object object = this.this$0.mutex;
                                                    synchronized (object) {
                                                        return this.e.getValue();
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                public int hashCode() {
                                                    Object object = this.this$0.mutex;
                                                    synchronized (object) {
                                                        return ((Object)this.e).hashCode();
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                public Object setValue(Object object) {
                                                    Object object2 = this.this$0.mutex;
                                                    synchronized (object2) {
                                                        return this.e.setValue(object);
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                public String toString() {
                                                    Object object = this.this$0.mutex;
                                                    synchronized (object) {
                                                        return this.e.toString();
                                                    }
                                                }
                                            }
                                            return new SynchronizedMapEntry(SynchronizedMap.this, super.next());
                                        }
                                    }
                                };
                            }
                        }
                    };
                }
            }
            return this.entries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return ((Object)this.m).equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.get(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.m).hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set keySet() {
            if (this.keys == null) {
                Object object = this.mutex;
                synchronized (object) {
                    this.keys = new SynchronizedSet(this.mutex, this.m.keySet());
                }
            }
            return this.keys;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object put(Object object, Object object2) {
            Object object3 = this.mutex;
            synchronized (object3) {
                return this.m.put(object, object2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(Map map) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection values() {
            if (this.values == null) {
                Object object = this.mutex;
                synchronized (object) {
                    this.values = new SynchronizedCollection(this.mutex, this.m.values());
                }
            }
            return this.values;
        }
    }

    private static final class SynchronizedListIterator
    extends SynchronizedIterator
    implements ListIterator {
        private final ListIterator li;

        SynchronizedListIterator(Object object, ListIterator listIterator) {
            super(object, listIterator);
            this.li = listIterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                this.li.add(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasPrevious() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.hasPrevious();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int nextIndex() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.nextIndex();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object previous() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.previous();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int previousIndex() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.previousIndex();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                this.li.set(object);
            }
        }
    }

    private static final class SynchronizedRandomAccessList
    extends SynchronizedList
    implements RandomAccess {
        private static final long serialVersionUID = 1530674583602358482L;

        SynchronizedRandomAccessList(List list) {
            super(list);
        }

        SynchronizedRandomAccessList(Object object, List list) {
            super(object, list);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int n, int n2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedRandomAccessList(this.mutex, this.list.subList(n, n2));
            }
        }
    }

    static class SynchronizedList
    extends SynchronizedCollection
    implements List {
        private static final long serialVersionUID = -7754090372962971524L;
        final List list;

        SynchronizedList(List list) {
            super(list);
            this.list = list;
        }

        SynchronizedList(Object object, List list) {
            super(object, list);
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int n, Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                this.list.add(n, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int n, Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.addAll(n, collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return ((Object)this.list).equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int n) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.get(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.list).hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.indexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.lastIndexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListIterator listIterator() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedListIterator(this.mutex, this.list.listIterator());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListIterator listIterator(int n) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedListIterator(this.mutex, this.list.listIterator(n));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int n) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.remove(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int n, Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.set(n, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int n, int n2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedList(this.mutex, this.list.subList(n, n2));
            }
        }
    }

    private static class SynchronizedIterator
    implements Iterator {
        final Object mutex;
        private final Iterator i;

        SynchronizedIterator(Object object, Iterator iterator) {
            this.i = iterator;
            this.mutex = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            Object object = this.mutex;
            synchronized (object) {
                return this.i.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            Object object = this.mutex;
            synchronized (object) {
                return this.i.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            Object object = this.mutex;
            synchronized (object) {
                this.i.remove();
            }
        }
    }

    static class SynchronizedCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        final Collection c;
        final Object mutex;

        SynchronizedCollection(Collection collection) {
            this.c = collection;
            this.mutex = this;
            if (collection == null) {
                throw new NullPointerException();
            }
        }

        SynchronizedCollection(Object object, Collection collection) {
            this.c = collection;
            this.mutex = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.add(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.contains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator iterator() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedIterator(this.mutex, this.c.iterator());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] objectArray) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray(objectArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toString();
            }
        }
    }

    private static final class SingletonMap
    extends AbstractMap
    implements Serializable {
        private static final long serialVersionUID = -6979724477215052911L;
        private final Object k;
        private final Object v;
        private transient Set entries;

        SingletonMap(Object object, Object object2) {
            this.k = object;
            this.v = object2;
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = Collections.singleton(new AbstractMap.BasicMapEntry(this.k, this.v){

                    public Object setValue(Object object) {
                        throw new UnsupportedOperationException();
                    }
                });
            }
            return this.entries;
        }

        public boolean containsKey(Object object) {
            return AbstractMap.equals(object, this.k);
        }

        public boolean containsValue(Object object) {
            return AbstractMap.equals(object, this.v);
        }

        public Object get(Object object) {
            return AbstractMap.equals(object, this.k) ? this.v : null;
        }

        public int hashCode() {
            return AbstractMap.hashCode(this.k) ^ AbstractMap.hashCode(this.v);
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = Collections.singleton(this.k);
            }
            return this.keys;
        }

        public int size() {
            return 1;
        }

        public Collection values() {
            if (this.values == null) {
                this.values = Collections.singleton(this.v);
            }
            return this.values;
        }

        public String toString() {
            return "{" + this.k + "=" + this.v + "}";
        }
    }

    private static final class SingletonList
    extends AbstractList
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 3093736618740652951L;
        private final Object element;

        SingletonList(Object object) {
            this.element = object;
        }

        public int size() {
            return 1;
        }

        public Object get(int n) {
            if (n == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        public boolean contains(Object object) {
            return AbstractCollection.equals(object, this.element);
        }

        public boolean containsAll(Collection collection) {
            Iterator iterator = collection.iterator();
            int n = collection.size();
            while (--n >= 0) {
                if (AbstractCollection.equals(iterator.next(), this.element)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return 31 + AbstractCollection.hashCode(this.element);
        }

        public int indexOf(Object object) {
            return AbstractCollection.equals(object, this.element) ? 0 : -1;
        }

        public int lastIndexOf(Object object) {
            return AbstractCollection.equals(object, this.element) ? 0 : -1;
        }

        public List subList(int n, int n2) {
            if (n == n2 && (n2 == 0 || n2 == 1)) {
                return EMPTY_LIST;
            }
            if (n == 0 && n2 == 1) {
                return this;
            }
            if (n > n2) {
                throw new IllegalArgumentException();
            }
            throw new IndexOutOfBoundsException();
        }

        public Object[] toArray() {
            return new Object[]{this.element};
        }

        public String toString() {
            return "[" + this.element + "]";
        }
    }

    private static final class SingletonSet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 3193687207550431679L;
        final Object element;

        SingletonSet(Object object) {
            this.element = object;
        }

        public int size() {
            return 1;
        }

        public Iterator iterator() {
            return new Iterator(){
                private boolean hasNext = true;

                public boolean hasNext() {
                    return this.hasNext;
                }

                public Object next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return SingletonSet.this.element;
                    }
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean contains(Object object) {
            return AbstractCollection.equals(object, this.element);
        }

        public boolean containsAll(Collection collection) {
            Iterator iterator = collection.iterator();
            int n = collection.size();
            while (--n >= 0) {
                if (AbstractCollection.equals(iterator.next(), this.element)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return AbstractCollection.hashCode(this.element);
        }

        public Object[] toArray() {
            return new Object[]{this.element};
        }

        public String toString() {
            return "[" + this.element + "]";
        }
    }

    private static final class ReverseComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;

        ReverseComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Comparable)object2).compareTo(object);
        }
    }

    private static final class CopiesList
    extends AbstractList
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 2739099268398711800L;
        private final int n;
        private final Object element;

        CopiesList(int n, Object object) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            this.n = n;
            this.element = object;
        }

        public int size() {
            return this.n;
        }

        public Object get(int n) {
            if (n < 0 || n >= this.n) {
                throw new IndexOutOfBoundsException();
            }
            return this.element;
        }

        public boolean contains(Object object) {
            return this.n > 0 && AbstractCollection.equals(object, this.element);
        }

        public int indexOf(Object object) {
            return this.n > 0 && AbstractCollection.equals(object, this.element) ? 0 : -1;
        }

        public int lastIndexOf(Object object) {
            return AbstractCollection.equals(object, this.element) ? this.n - 1 : -1;
        }

        public List subList(int n, int n2) {
            if (n < 0 || n2 > this.n) {
                throw new IndexOutOfBoundsException();
            }
            return new CopiesList(n2 - n, this.element);
        }

        public Object[] toArray() {
            Object[] objectArray = new Object[this.n];
            Arrays.fill(objectArray, this.element);
            return objectArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("{");
            int n = this.n - 1;
            while (--n > 0) {
                stringBuffer.append(this.element).append(", ");
            }
            stringBuffer.append(this.element).append("}");
            return stringBuffer.toString();
        }
    }

    private static final class EmptyMap
    extends AbstractMap
    implements Serializable {
        private static final long serialVersionUID = 6428348081105594320L;

        EmptyMap() {
        }

        public Set entrySet() {
            return EMPTY_SET;
        }

        public boolean containsKey(Object object) {
            return false;
        }

        public boolean containsValue(Object object) {
            return false;
        }

        public boolean equals(Object object) {
            return object instanceof Map && ((Map)object).isEmpty();
        }

        public Object get(Object object) {
            return null;
        }

        public int hashCode() {
            return 0;
        }

        public Set keySet() {
            return EMPTY_SET;
        }

        public Object remove(Object object) {
            return null;
        }

        public int size() {
            return 0;
        }

        public Collection values() {
            return EMPTY_SET;
        }

        public String toString() {
            return "[]";
        }
    }

    private static final class EmptyList
    extends AbstractList
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 8842843931221139166L;

        EmptyList() {
        }

        public int size() {
            return 0;
        }

        public Object get(int n) {
            throw new IndexOutOfBoundsException();
        }

        public boolean contains(Object object) {
            return false;
        }

        public boolean containsAll(Collection collection) {
            return collection.isEmpty();
        }

        public boolean equals(Object object) {
            return object instanceof List && ((List)object).isEmpty();
        }

        public int hashCode() {
            return 1;
        }

        public int indexOf(Object object) {
            return -1;
        }

        public int lastIndexOf(Object object) {
            return -1;
        }

        public boolean remove(Object object) {
            return false;
        }

        public boolean removeAll(Collection collection) {
            return false;
        }

        public boolean retainAll(Collection collection) {
            return false;
        }

        public Object[] toArray() {
            return new Object[0];
        }

        public Object[] toArray(Object[] objectArray) {
            if (objectArray.length > 0) {
                objectArray[0] = null;
            }
            return objectArray;
        }

        public String toString() {
            return "[]";
        }
    }

    private static final class EmptySet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 1582296315990362920L;

        EmptySet() {
        }

        public int size() {
            return 0;
        }

        public Iterator iterator() {
            return EMPTY_LIST.iterator();
        }

        public boolean contains(Object object) {
            return false;
        }

        public boolean containsAll(Collection collection) {
            return collection.isEmpty();
        }

        public boolean equals(Object object) {
            return object instanceof Set && ((Set)object).isEmpty();
        }

        public int hashCode() {
            return 0;
        }

        public boolean remove(Object object) {
            return false;
        }

        public boolean removeAll(Collection collection) {
            return false;
        }

        public boolean retainAll(Collection collection) {
            return false;
        }

        public Object[] toArray() {
            return new Object[0];
        }

        public Object[] toArray(Object[] objectArray) {
            if (objectArray.length > 0) {
                objectArray[0] = null;
            }
            return objectArray;
        }

        public String toString() {
            return "[]";
        }
    }
}

