/*
 * Decompiled with CFR 0.152.
 */
package moio.util;

import moio.util.AbstractCollection;
import moio.util.AbstractSet;
import moio.util.Collection;
import moio.util.Iterator;
import moio.util.Map;
import moio.util.Set;
import moio.util.UnsupportedOperationException;

public abstract class AbstractMap
implements Map {
    static final int KEYS = 0;
    static final int VALUES = 1;
    static final int ENTRIES = 2;
    Set keys;
    Collection values;

    protected AbstractMap() {
    }

    public abstract Set entrySet();

    public void clear() {
        this.entrySet().clear();
    }

    public boolean containsKey(Object object) {
        Iterator iterator = this.entrySet().iterator();
        int n = this.size();
        while (--n >= 0) {
            if (!AbstractMap.equals(object, ((Map.Entry)iterator.next()).getKey())) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object object) {
        Iterator iterator = this.entrySet().iterator();
        int n = this.size();
        while (--n >= 0) {
            if (!AbstractMap.equals(object, ((Map.Entry)iterator.next()).getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Map && ((Object)this.entrySet()).equals(((Map)object).entrySet());
    }

    public Object get(Object object) {
        Iterator iterator = this.entrySet().iterator();
        int n = this.size();
        while (--n >= 0) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!AbstractMap.equals(object, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public int hashCode() {
        return ((Object)this.entrySet()).hashCode();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet(){

                public int size() {
                    return AbstractMap.this.size();
                }

                public boolean contains(Object object) {
                    return AbstractMap.this.containsKey(object);
                }

                public Iterator iterator() {
                    return new Iterator(){
                        private final Iterator map_iterator;
                        {
                            this.map_iterator = AbstractMap.this.entrySet().iterator();
                        }

                        public boolean hasNext() {
                            return this.map_iterator.hasNext();
                        }

                        public Object next() {
                            return ((Map.Entry)this.map_iterator.next()).getKey();
                        }

                        public void remove() {
                            this.map_iterator.remove();
                        }
                    };
                }
            };
        }
        return this.keys;
    }

    public Object put(Object object, Object object2) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        int n = map.size();
        while (--n >= 0) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        Iterator iterator = this.entrySet().iterator();
        int n = this.size();
        while (--n >= 0) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!AbstractMap.equals(object, entry.getKey())) continue;
            Object object2 = entry.getValue();
            iterator.remove();
            return object2;
        }
        return null;
    }

    public int size() {
        return this.entrySet().size();
    }

    public String toString() {
        Iterator iterator = this.entrySet().iterator();
        StringBuffer stringBuffer = new StringBuffer("{");
        for (int i = this.size(); i > 0; --i) {
            Map.Entry entry = (Map.Entry)iterator.next();
            stringBuffer.append(entry.getKey());
            stringBuffer.append('=');
            stringBuffer.append(entry.getValue());
            if (i <= 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public int size() {
                    return AbstractMap.this.size();
                }

                public boolean contains(Object object) {
                    return AbstractMap.this.containsValue(object);
                }

                public Iterator iterator() {
                    return new Iterator(){
                        private final Iterator map_iterator;
                        {
                            this.map_iterator = AbstractMap.this.entrySet().iterator();
                        }

                        public boolean hasNext() {
                            return this.map_iterator.hasNext();
                        }

                        public Object next() {
                            return ((Map.Entry)this.map_iterator.next()).getValue();
                        }

                        public void remove() {
                            this.map_iterator.remove();
                        }
                    };
                }
            };
        }
        return this.values;
    }

    static final boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    static final int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    static class BasicMapEntry
    implements Map.Entry {
        Object key;
        Object value;

        BasicMapEntry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public final boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            if (object instanceof BasicMapEntry) {
                BasicMapEntry basicMapEntry = (BasicMapEntry)object;
                return AbstractMap.equals(this.key, basicMapEntry.key) && AbstractMap.equals(this.value, basicMapEntry.value);
            }
            Map.Entry entry = (Map.Entry)object;
            return AbstractMap.equals(this.key, entry.getKey()) && AbstractMap.equals(this.value, entry.getValue());
        }

        public final Object getKey() {
            return this.key;
        }

        public final Object getValue() {
            return this.value;
        }

        public final int hashCode() {
            return AbstractMap.hashCode(this.key) ^ AbstractMap.hashCode(this.value);
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }
    }
}

