/*
 * Decompiled with CFR 0.152.
 */
package moio.util;

import moio.util.Collection;
import moio.util.Iterator;
import moio.util.UnsupportedOperationException;

public abstract class AbstractCollection
implements Collection {
    protected AbstractCollection() {
    }

    public abstract Iterator iterator();

    public abstract int size();

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        boolean bl = false;
        int n = collection.size();
        while (--n >= 0) {
            bl |= this.add(iterator.next());
        }
        return bl;
    }

    public void clear() {
        Iterator iterator = this.iterator();
        int n = this.size();
        while (--n >= 0) {
            iterator.next();
            iterator.remove();
        }
    }

    public boolean contains(Object object) {
        Iterator iterator = this.iterator();
        int n = this.size();
        while (--n >= 0) {
            if (!AbstractCollection.equals(object, iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        int n = collection.size();
        while (--n >= 0) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean remove(Object object) {
        Iterator iterator = this.iterator();
        int n = this.size();
        while (--n >= 0) {
            if (!AbstractCollection.equals(object, iterator.next())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        return this.removeAllInternal(collection);
    }

    boolean removeAllInternal(Collection collection) {
        Iterator iterator = this.iterator();
        boolean bl = false;
        int n = this.size();
        while (--n >= 0) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        return this.retainAllInternal(collection);
    }

    boolean retainAllInternal(Collection collection) {
        Iterator iterator = this.iterator();
        boolean bl = false;
        int n = this.size();
        while (--n >= 0) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public Object[] toArray() {
        Iterator iterator = this.iterator();
        int n = this.size();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = iterator.next();
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = new Object[n];
        } else if (objectArray.length > n) {
            objectArray[n] = null;
        }
        Iterator iterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = iterator.next();
        }
        return objectArray;
    }

    public String toString() {
        Iterator iterator = this.iterator();
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = this.size(); i > 0; --i) {
            stringBuffer.append(iterator.next());
            if (i <= 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static final boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    static final int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }
}

