/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bt747.gps.mtk.agps;

import bt747.model.EventPoster;
import bt747.model.ModelEvent;
import bt747.sys.Generic;
import bt747.sys.I18N;
import bt747.sys.interfaces.BT747Exception;
import bt747.sys.interfaces.BT747InputStream;
import bt747.sys.interfaces.BT747Int;
import gps.connection.MtkBinWriter;
import gps.mvc.DeviceOperationHandlerIF;
import gps.mvc.GpsLinkHandler;
import net.sf.bt747.gps.mtk.MtkBinTransportMessageModel;

public class AgpsUploadHandler
implements DeviceOperationHandlerIF {
    private BT747InputStream agpsDataStream;
    private int nxtPacketIdx;
    private int nextPacketPercentOffset;
    private int percentBytes = 1075;
    private final EventPoster poster;
    private boolean sendNextOK;
    private int timesOutAt;
    private MtkBinTransportMessageModel cmd;
    private int errorCnt;
    private int percent;

    public AgpsUploadHandler(EventPoster eventPoster) {
        this.poster = eventPoster;
    }

    public AgpsUploadHandler() {
        this(null);
    }

    public boolean analyseResponse(Object object) {
        if (object instanceof MtkBinTransportMessageModel) {
            MtkBinTransportMessageModel mtkBinTransportMessageModel = (MtkBinTransportMessageModel)object;
            Generic.debug("<<" + mtkBinTransportMessageModel.toString());
            if (this.nxtPacketIdx == 0) {
                this.sendNextOK = true;
            } else {
                switch (mtkBinTransportMessageModel.getType()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.errorCnt = 0;
                        byte[] byArray = mtkBinTransportMessageModel.getPayLoad();
                        int n = (byArray[0] & 0xFF) + ((byArray[1] & 0xFF) << 8);
                        byte by = byArray[2];
                        if (by != 1) {
                            this.errorCnt = 3;
                            Generic.debug("Error packet from device during AGPS upload.");
                        }
                        if (n < this.nxtPacketIdx - 1) break;
                        this.sendNextOK = true;
                        break;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean notifyRun(GpsLinkHandler gpsLinkHandler) throws BT747Exception {
        if (this.nxtPacketIdx < 0) {
            this.stopUploadMode(gpsLinkHandler);
            return false;
        }
        if (this.timesOutAt == 0) {
            this.resetTimeOut();
        } else if (this.cmd != null && Generic.getTimeStamp() > this.timesOutAt) {
            ++this.errorCnt;
            if (this.cmd != null && this.errorCnt < 3) {
                MtkBinWriter.sendCmd(gpsLinkHandler, this.cmd);
                this.resetTimeOut();
                return true;
            }
        }
        if (this.errorCnt >= 3) {
            this.stopUploadMode(gpsLinkHandler);
            throw new BT747Exception(I18N.i18n("Too many errors during AGPS upload"));
        }
        if (this.sendNextOK) {
            this.sendNextOK = false;
            this.cmd = this.getNextPacketCmd();
            MtkBinWriter.sendCmd(gpsLinkHandler, this.cmd);
            if (this.nxtPacketIdx * 180 > this.nextPacketPercentOffset) {
                ++this.percent;
                this.nextPacketPercentOffset += this.percentBytes;
                this.notifyPercent(this.percent);
            }
            if (Generic.isDebug()) {
                Generic.debug("Sent AGPS data:" + this.cmd.toString());
            }
            this.resetTimeOut();
        }
        return true;
    }

    private final MtkBinTransportMessageModel getNextPacketCmd() {
        byte[] byArray = new byte[182];
        int n = this.agpsDataStream.readBytes(byArray, 2, 180);
        if (n > 0) {
            byArray[0] = (byte)(this.nxtPacketIdx & 0xFF);
            byArray[1] = (byte)(this.nxtPacketIdx >> 8 & 0xFF);
            ++this.nxtPacketIdx;
        } else {
            byArray[0] = -1;
            byArray[1] = -1;
            this.nxtPacketIdx = -1;
        }
        return new MtkBinTransportMessageModel(722, byArray);
    }

    private final void resetTimeOut() {
        this.timesOutAt = Generic.getTimeStamp() + 6000;
    }

    private final void stopUploadMode(GpsLinkHandler gpsLinkHandler) {
        MtkBinWriter.doSetNmeaMode(gpsLinkHandler.getGPSRxtx());
        Generic.debug("AGPS upload stopped/finished");
        this.notifyDone();
    }

    private final void notifyDone() {
        if (this.poster != null) {
            ModelEvent modelEvent = new ModelEvent(272, null);
            this.poster.postEvent(modelEvent);
        }
    }

    private final void notifyPercent(int n) {
        if (this.poster != null) {
            ModelEvent modelEvent = new ModelEvent(273, BT747Int.get(n));
            this.poster.postEvent(modelEvent);
        }
    }
}

