/*
 * Decompiled with CFR 0.152.
 */
package moio.util;

import moio.util.AbstractMap;
import moio.util.AbstractSet;
import moio.util.IllegalArgumentException;
import moio.util.IllegalStateException;
import moio.util.Iterator;
import moio.util.Map;
import moio.util.NoSuchElementException;
import moio.util.Set;
import moio.util.ref.Reference;
import moio.util.ref.ReferenceQueue;
import moio.util.ref.WeakReference;

public class WeakHashMap
extends AbstractMap
implements Map {
    static final Object NULL_KEY = new Object(){

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return null == object || this == object;
        }
    };
    private final ReferenceQueue queue;
    int size;
    private float loadFactor;
    private int threshold;
    int modCount;
    private final WeakEntrySet theEntrySet;
    WeakBucket[] buckets;

    public WeakHashMap() {
        this(11, 0.75f);
    }

    public WeakHashMap(int n, float f) {
        if (n < 0 || !(f > 0.0f)) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n * f);
        this.theEntrySet = new WeakEntrySet();
        this.queue = new ReferenceQueue();
        this.buckets = new WeakBucket[n];
    }

    private int hash(Object object) {
        return Math.abs(object.hashCode() % this.buckets.length);
    }

    void cleanQueue() {
        Reference reference = this.queue.poll();
        while (reference != null) {
            this.internalRemove((WeakBucket)reference);
            reference = this.queue.poll();
        }
    }

    private void rehash() {
        WeakBucket[] weakBucketArray = this.buckets;
        int n = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)n * this.loadFactor);
        this.buckets = new WeakBucket[n];
        for (int i = 0; i < weakBucketArray.length; ++i) {
            WeakBucket weakBucket = weakBucketArray[i];
            while (weakBucket != null) {
                WeakBucket weakBucket2 = weakBucket.next;
                Object object = weakBucket.get();
                if (object == null) {
                    weakBucket.slot = -1;
                    --this.size;
                } else {
                    int n2;
                    weakBucket.slot = n2 = this.hash(object);
                    weakBucket.next = this.buckets[n2];
                    this.buckets[n2] = weakBucket;
                }
                weakBucket = weakBucket2;
            }
        }
    }

    private WeakBucket.WeakEntry internalGet(Object object) {
        if (object == null) {
            object = NULL_KEY;
        }
        int n = this.hash(object);
        WeakBucket weakBucket = this.buckets[n];
        while (weakBucket != null) {
            WeakBucket.WeakEntry weakEntry = weakBucket.getEntry();
            if (weakEntry != null && object.equals(weakEntry.key)) {
                return weakEntry;
            }
            weakBucket = weakBucket.next;
        }
        return null;
    }

    private void internalAdd(Object object, Object object2) {
        if (object == null) {
            object = NULL_KEY;
        }
        int n = this.hash(object);
        WeakBucket weakBucket = new WeakBucket(object, this.queue, object2, n);
        weakBucket.next = this.buckets[n];
        this.buckets[n] = weakBucket;
        ++this.size;
    }

    void internalRemove(WeakBucket weakBucket) {
        int n = weakBucket.slot;
        if (n == -1) {
            return;
        }
        weakBucket.slot = -1;
        if (this.buckets[n] == weakBucket) {
            this.buckets[n] = weakBucket.next;
        } else {
            WeakBucket weakBucket2 = this.buckets[n];
            while (weakBucket2.next != weakBucket) {
                weakBucket2 = weakBucket2.next;
            }
            weakBucket2.next = weakBucket.next;
        }
        --this.size;
    }

    public int size() {
        this.cleanQueue();
        return this.size;
    }

    public boolean isEmpty() {
        this.cleanQueue();
        return this.size == 0;
    }

    public boolean containsKey(Object object) {
        this.cleanQueue();
        return this.internalGet(object) != null;
    }

    public Object put(Object object, Object object2) {
        this.cleanQueue();
        WeakBucket.WeakEntry weakEntry = this.internalGet(object);
        if (weakEntry != null) {
            return weakEntry.setValue(object2);
        }
        ++this.modCount;
        if (this.size >= this.threshold) {
            this.rehash();
        }
        this.internalAdd(object, object2);
        return null;
    }

    public Object remove(Object object) {
        this.cleanQueue();
        WeakBucket.WeakEntry weakEntry = this.internalGet(object);
        if (weakEntry == null) {
            return null;
        }
        ++this.modCount;
        this.internalRemove(weakEntry.getBucket());
        return weakEntry.getValue();
    }

    public Set entrySet() {
        this.cleanQueue();
        return this.theEntrySet;
    }

    public Set keySet() {
        this.cleanQueue();
        return super.keySet();
    }

    private static class WeakBucket
    extends WeakReference {
        Object value;
        WeakBucket next;
        int slot;

        public WeakBucket(Object object, ReferenceQueue referenceQueue, Object object2, int n) {
            super(object, referenceQueue);
            this.value = object2;
            this.slot = n;
        }

        WeakEntry getEntry() {
            Object object = this.get();
            if (object == null) {
                return null;
            }
            return new WeakEntry(object);
        }

        class WeakEntry
        implements Map.Entry {
            Object key;

            public WeakEntry(Object object) {
                this.key = object;
            }

            public WeakBucket getBucket() {
                return WeakBucket.this;
            }

            public Object getKey() {
                return this.key == NULL_KEY ? null : this.key;
            }

            public Object getValue() {
                return WeakBucket.this.value;
            }

            public Object setValue(Object object) {
                Object object2 = WeakBucket.this.value;
                WeakBucket.this.value = object;
                return object2;
            }

            public int hashCode() {
                return this.key.hashCode() ^ AbstractMap.hashCode(WeakBucket.this.value);
            }

            public boolean equals(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    return this.key.equals(entry.getKey()) && AbstractMap.equals(WeakBucket.this.value, entry.getValue());
                }
                return false;
            }

            public String toString() {
                return this.key + "=" + WeakBucket.this.value;
            }
        }
    }

    private final class WeakEntrySet
    extends AbstractSet {
        WeakEntrySet() {
        }

        public int size() {
            return WeakHashMap.this.size;
        }

        public Iterator iterator() {
            return new Iterator(){
                WeakBucket.WeakEntry lastEntry;
                WeakBucket.WeakEntry nextEntry = this.findNext(null);
                int knownMod;
                {
                    this.knownMod = ((WeakEntrySet)WeakEntrySet.this).WeakHashMap.this.modCount;
                }

                private void checkMod() {
                    WeakHashMap.this.cleanQueue();
                }

                private WeakBucket.WeakEntry findNext(WeakBucket.WeakEntry weakEntry) {
                    int n;
                    WeakBucket weakBucket;
                    if (weakEntry != null) {
                        weakBucket = weakEntry.getBucket().next;
                        n = weakEntry.getBucket().slot;
                    } else {
                        weakBucket = ((WeakEntrySet)WeakEntrySet.this).WeakHashMap.this.buckets[0];
                        n = 0;
                    }
                    while (true) {
                        if (weakBucket != null) {
                            WeakBucket.WeakEntry weakEntry2 = weakBucket.getEntry();
                            if (weakEntry2 != null) {
                                return weakEntry2;
                            }
                            weakBucket = weakBucket.next;
                            continue;
                        }
                        if (++n == ((WeakEntrySet)WeakEntrySet.this).WeakHashMap.this.buckets.length) {
                            return null;
                        }
                        weakBucket = ((WeakEntrySet)WeakEntrySet.this).WeakHashMap.this.buckets[n];
                    }
                }

                public boolean hasNext() {
                    this.checkMod();
                    return this.nextEntry != null;
                }

                public Object next() {
                    this.checkMod();
                    if (this.nextEntry == null) {
                        throw new NoSuchElementException();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.findNext(this.lastEntry);
                    return this.lastEntry;
                }

                public void remove() {
                    this.checkMod();
                    if (this.lastEntry == null) {
                        throw new IllegalStateException();
                    }
                    ++((WeakEntrySet)WeakEntrySet.this).WeakHashMap.this.modCount;
                    WeakHashMap.this.internalRemove(this.lastEntry.getBucket());
                    this.lastEntry = null;
                    ++this.knownMod;
                }
            };
        }
    }
}

