/*
 * Decompiled with CFR 0.152.
 */
package moio.util;

import moio.util.AbstractCollection;
import moio.util.AbstractList;
import moio.util.Cloneable;
import moio.util.Collection;
import moio.util.IllegalArgumentException;
import moio.util.List;
import moio.util.RandomAccess;
import moio.util.Serializable;
import moio.util.System;

public class Vector
extends AbstractList
implements Cloneable,
List,
RandomAccess,
Serializable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;

    public Vector() {
        this(10, 0);
    }

    public Vector(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.elementData = new Object[n];
        this.capacityIncrement = n2;
    }

    public synchronized void ensureCapacity(int n) {
        if (this.elementData.length >= n) {
            return;
        }
        int n2 = this.capacityIncrement <= 0 ? this.elementData.length * 2 : this.elementData.length + this.capacityIncrement;
        Object[] objectArray = new Object[Math.max(n2, n)];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        this.elementData = objectArray;
    }

    public synchronized int size() {
        return this.elementCount;
    }

    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    public boolean contains(Object object) {
        return this.indexOf(object, 0) >= 0;
    }

    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public synchronized int indexOf(Object object, int n) {
        for (int i = n; i < this.elementCount; ++i) {
            if (!AbstractCollection.equals(object, this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public synchronized Object elementAt(int n) {
        this.checkBoundExclusive(n);
        return this.elementData[n];
    }

    public synchronized void insertElementAt(Object object, int n) {
        this.checkBoundInclusive(n);
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        ++this.modCount;
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        ++this.elementCount;
        this.elementData[n] = object;
    }

    public synchronized void addElement(Object object) {
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        ++this.modCount;
        this.elementData[this.elementCount++] = object;
    }

    public synchronized boolean removeElement(Object object) {
        int n = this.indexOf(object, 0);
        if (n >= 0) {
            this.remove(n);
            return true;
        }
        return false;
    }

    public Object get(int n) {
        return this.elementAt(n);
    }

    public boolean add(Object object) {
        this.addElement(object);
        return true;
    }

    public boolean remove(Object object) {
        return this.removeElement(object);
    }

    public void add(int n, Object object) {
        this.insertElementAt(object, n);
    }

    public synchronized Object remove(int n) {
        this.checkBoundExclusive(n);
        Object object = this.elementData[n];
        ++this.modCount;
        --this.elementCount;
        if (n < this.elementCount) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, this.elementCount - n);
        }
        this.elementData[this.elementCount] = null;
        return object;
    }

    public synchronized boolean containsAll(Collection collection) {
        return super.containsAll(collection);
    }

    public synchronized boolean equals(Object object) {
        return super.equals(object);
    }

    public synchronized int hashCode() {
        return super.hashCode();
    }

    public synchronized String toString() {
        return super.toString();
    }

    private void checkBoundInclusive(int n) {
        if (n > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
    }

    private void checkBoundExclusive(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
    }
}

