/*
 * Decompiled with CFR 0.152.
 */
package moio.util;

import moio.util.AbstractCollection;
import moio.util.AbstractSequentialList;
import moio.util.Cloneable;
import moio.util.IllegalStateException;
import moio.util.List;
import moio.util.ListIterator;
import moio.util.NoSuchElementException;
import moio.util.Serializable;

public class LinkedList
extends AbstractSequentialList
implements Cloneable,
List,
Serializable {
    transient Entry first;
    transient Entry last;
    transient int size = 0;

    Entry getEntry(int n) {
        Entry entry;
        if (n < this.size / 2) {
            entry = this.first;
            while (n-- > 0) {
                entry = entry.next;
            }
        } else {
            entry = this.last;
            while (++n < this.size) {
                entry = entry.previous;
            }
        }
        return entry;
    }

    void removeEntry(Entry entry) {
        ++this.modCount;
        --this.size;
        if (this.size == 0) {
            this.last = null;
            this.first = null;
        } else if (entry == this.first) {
            this.first = entry.next;
            entry.next.previous = null;
        } else if (entry == this.last) {
            this.last = entry.previous;
            entry.previous.next = null;
        } else {
            entry.next.previous = entry.previous;
            entry.previous.next = entry.next;
        }
    }

    private void checkBoundsInclusive(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
        }
    }

    private void checkBoundsExclusive(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
        }
    }

    private void addLastEntry(Entry entry) {
        ++this.modCount;
        if (this.size == 0) {
            this.first = this.last = entry;
        } else {
            entry.previous = this.last;
            this.last.next = entry;
            this.last = entry;
        }
        ++this.size;
    }

    public boolean contains(Object object) {
        Entry entry = this.first;
        while (entry != null) {
            if (AbstractCollection.equals(object, entry.data)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public boolean add(Object object) {
        this.addLastEntry(new Entry(object));
        return true;
    }

    public boolean remove(Object object) {
        Entry entry = this.first;
        while (entry != null) {
            if (AbstractCollection.equals(object, entry.data)) {
                this.removeEntry(entry);
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Object get(int n) {
        this.checkBoundsExclusive(n);
        return this.getEntry((int)n).data;
    }

    public void add(int n, Object object) {
        this.checkBoundsInclusive(n);
        Entry entry = new Entry(object);
        if (n < this.size) {
            Entry entry2;
            ++this.modCount;
            entry.next = entry2 = this.getEntry(n);
            entry.previous = entry2.previous;
            if (entry2.previous == null) {
                this.first = entry;
            } else {
                entry2.previous.next = entry;
            }
            entry2.previous = entry;
            ++this.size;
        } else {
            this.addLastEntry(entry);
        }
    }

    public Object remove(int n) {
        this.checkBoundsExclusive(n);
        Entry entry = this.getEntry(n);
        this.removeEntry(entry);
        return entry.data;
    }

    public int indexOf(Object object) {
        int n = 0;
        Entry entry = this.first;
        while (entry != null) {
            if (AbstractCollection.equals(object, entry.data)) {
                return n;
            }
            ++n;
            entry = entry.next;
        }
        return -1;
    }

    public ListIterator listIterator(int n) {
        this.checkBoundsInclusive(n);
        return new LinkedListItr(n);
    }

    private final class LinkedListItr
    implements ListIterator {
        private int knownMod;
        private Entry next;
        private Entry previous;
        private Entry lastReturned;
        private int position;

        LinkedListItr(int n) {
            this.knownMod = LinkedList.this.modCount;
            if (n == LinkedList.this.size) {
                this.next = null;
                this.previous = LinkedList.this.last;
            } else {
                this.next = LinkedList.this.getEntry(n);
                this.previous = this.next.previous;
            }
            this.position = n;
        }

        private void checkMod() {
        }

        public boolean hasNext() {
            this.checkMod();
            return this.next != null;
        }

        public Object next() {
            this.checkMod();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            ++this.position;
            this.lastReturned = this.previous = this.next;
            this.next = this.lastReturned.next;
            return this.lastReturned.data;
        }

        public void remove() {
            this.checkMod();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (this.lastReturned == this.previous) {
                --this.position;
            }
            this.next = this.lastReturned.next;
            this.previous = this.lastReturned.previous;
            LinkedList.this.removeEntry(this.lastReturned);
            ++this.knownMod;
            this.lastReturned = null;
        }

        public void add(Object object) {
            this.checkMod();
            ++LinkedList.this.modCount;
            ++this.knownMod;
            ++LinkedList.this.size;
            ++this.position;
            Entry entry = new Entry(object);
            entry.previous = this.previous;
            entry.next = this.next;
            if (this.previous != null) {
                this.previous.next = entry;
            } else {
                LinkedList.this.first = entry;
            }
            if (this.next != null) {
                this.next.previous = entry;
            } else {
                LinkedList.this.last = entry;
            }
            this.previous = entry;
            this.lastReturned = null;
        }
    }

    private static final class Entry {
        Object data;
        Entry next;
        Entry previous;

        Entry(Object object) {
            this.data = object;
        }
    }
}

