/*
 * Decompiled with CFR 0.152.
 */
package moio.util;

import moio.util.AbstractCollection;
import moio.util.IllegalStateException;
import moio.util.Iterator;
import moio.util.List;
import moio.util.ListIterator;
import moio.util.NoSuchElementException;
import moio.util.UnsupportedOperationException;

public abstract class AbstractList
extends AbstractCollection
implements List {
    protected transient int modCount;

    protected AbstractList() {
    }

    public abstract Object get(int var1);

    public void add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object object) {
        this.add(this.size(), object);
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        int n = this.size();
        if (n != ((List)object).size()) {
            return false;
        }
        Iterator iterator = this.iterator();
        Iterator iterator2 = ((List)object).iterator();
        while (--n >= 0) {
            if (AbstractCollection.equals(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        Iterator iterator = this.iterator();
        int n2 = this.size();
        while (--n2 >= 0) {
            n = 31 * n + AbstractCollection.hashCode(iterator.next());
        }
        return n;
    }

    public int indexOf(Object object) {
        ListIterator listIterator = this.listIterator();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!AbstractCollection.equals(object, listIterator.next())) continue;
            return i;
        }
        return -1;
    }

    public Iterator iterator() {
        return new Iterator(){
            private int pos = 0;
            private int size = AbstractList.this.size();
            private int last = -1;
            private int knownMod;
            {
                this.knownMod = AbstractList.this.modCount;
            }

            private void checkMod() {
            }

            public boolean hasNext() {
                this.checkMod();
                return this.pos < this.size;
            }

            public Object next() {
                this.checkMod();
                if (this.pos == this.size) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos;
                return AbstractList.this.get(this.pos++);
            }

            public void remove() {
                this.checkMod();
                if (this.last < 0) {
                    throw new IllegalStateException();
                }
                AbstractList.this.remove(this.last);
                --this.pos;
                --this.size;
                this.last = -1;
                this.knownMod = AbstractList.this.modCount;
            }
        };
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int n) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size());
        }
        return new ListIterator(){
            private int knownMod;
            private int position;
            private int lastReturned;
            private int size;
            {
                this.knownMod = AbstractList.this.modCount;
                this.position = n;
                this.lastReturned = -1;
                this.size = AbstractList.this.size();
            }

            private void checkMod() {
            }

            public boolean hasNext() {
                this.checkMod();
                return this.position < this.size;
            }

            public Object next() {
                this.checkMod();
                if (this.position == this.size) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.position;
                return AbstractList.this.get(this.position++);
            }

            public void remove() {
                this.checkMod();
                if (this.lastReturned < 0) {
                    throw new IllegalStateException();
                }
                AbstractList.this.remove(this.lastReturned);
                --this.size;
                this.position = this.lastReturned;
                this.lastReturned = -1;
                this.knownMod = AbstractList.this.modCount;
            }

            public void add(Object object) {
                this.checkMod();
                AbstractList.this.add(this.position++, object);
                ++this.size;
                this.lastReturned = -1;
                this.knownMod = AbstractList.this.modCount;
            }
        };
    }

    public Object remove(int n) {
        throw new UnsupportedOperationException();
    }
}

