/*
 * Decompiled with CFR 0.152.
 */
package gps.mvc;

import bt747.sys.Generic;
import bt747.sys.interfaces.BT747Exception;
import bt747.sys.interfaces.BT747Path;
import gps.WondeproudConstants;
import gps.connection.WPResponseModel;
import gps.mvc.DeviceOperationHandlerIF;
import gps.mvc.GpsLinkHandler;
import gps.mvc.LogFile;
import gps.mvc.WPController;
import gps.mvc.commands.wp.WPIntCommand;
import gps.mvc.commands.wp.WPStrCommand;

public class WPLogDownloadHandler
implements WondeproudConstants,
DeviceOperationHandlerIF {
    private final WPController wpC;
    private BT747Path wpLogPath;
    private int wpState = 0;
    private final LogFile logFile = new LogFile();
    private final GpsLinkHandler handler;

    public boolean analyseResponse(Object object) {
        if (object instanceof WPResponseModel) {
            this.analyseWPData((WPResponseModel)object);
            this.wpC.getMtkModel().postEvent(14);
            this.wpC.getMtkModel().postEvent(7);
            return true;
        }
        if (object instanceof String) {
            // empty if block
        }
        return false;
    }

    public boolean notifyRun(GpsLinkHandler gpsLinkHandler) throws BT747Exception {
        boolean bl = true;
        switch (this.wpState) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
        return bl;
    }

    public WPLogDownloadHandler(WPController wPController, GpsLinkHandler gpsLinkHandler) {
        this.wpC = wPController;
        this.handler = gpsLinkHandler;
    }

    public final void getWPLog(BT747Path bT747Path) {
        this.wpC.setLogDownloadOngoing(true);
        this.wpLogPath = bT747Path;
        this.enterWPMode();
        this.wpState = 1;
    }

    public final void reqWPLog() {
        this.wpState = 2;
        this.handler.sendCmd(new WPIntCommand(null, 1622474752, -1, 0xA00000));
        this.wpC.getMtkModel().postEvent(5);
    }

    public final void enterWPMode() {
        this.exitWPMode();
        this.handler.sendCmd(new WPStrCommand("W'P Camera Detect", 255));
    }

    public final void exitWPMode() {
        this.handler.sendCmd(new WPStrCommand("WP AP-Exit", 0));
        this.wpState = 0;
    }

    protected final void analyseWPData(WPResponseModel wPResponseModel) {
        String string = wPResponseModel.getResponseType();
        if (Generic.isDebug()) {
            Generic.debug("<WP:" + string);
        }
        if (string.startsWith("WP GPS")) {
            if (this.wpState == 1) {
                this.reqWPLog();
            }
        } else if (string.equals("WP Update Over") && this.wpState == 2 && this.wpLogPath != null) {
            if (!this.wpLogPath.getPath().endsWith(".sr")) {
                this.wpLogPath = this.wpLogPath.proto(this.wpLogPath + ".sr");
            }
            this.logFile.openNewLog(this.wpLogPath);
            try {
                this.logFile.getLogFile().writeBytes(wPResponseModel.getResponseBuffer(), 0, wPResponseModel.getResponseSize());
                this.logFile.getLogFile().close();
            }
            catch (Exception exception) {
                Generic.debug("", exception);
            }
            this.wpLogPath = null;
            this.exitWPMode();
            Generic.debug("End WP");
            this.handler.getGPSRxtx().newState(0);
            this.wpC.setLogDownloadOngoing(false);
        }
    }
}

