/*
 * Decompiled with CFR 0.152.
 */
package gps.mvc;

import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Exception;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747StringTokenizer;
import gps.mvc.CmdParam;
import gps.mvc.GpsController;
import gps.mvc.MTKLogDownloadHandler;
import gps.mvc.MtkModel;
import gps.mvc.ProtectedDevControllerIF;
import gps.mvc.commands.GpsLinkExecCommand;
import gps.mvc.commands.GpsLinkNmeaCommand;

public class MtkController
implements ProtectedDevControllerIF {
    private MtkModel m;
    private GpsController c;
    private final MTKLogDownloadHandler mtkLogHandler;

    MtkController(GpsController gpsController, MtkModel mtkModel) {
        this.c = gpsController;
        this.m = mtkModel;
        this.mtkLogHandler = new MTKLogDownloadHandler(this, mtkModel);
        mtkModel.setLogHandler(this.mtkLogHandler);
    }

    public final MtkModel getMtkModel() {
        return this.m;
    }

    protected final void sendCmd(String string) {
        this.m.getHandler().sendCmd(new GpsLinkNmeaCommand(string));
    }

    protected final void sendCmd(String string, boolean bl) {
        this.m.getHandler().sendCmd(new GpsLinkNmeaCommand(string, bl));
    }

    protected final void sendCmd(GpsLinkExecCommand gpsLinkExecCommand) {
        this.m.getHandler().sendCmd(gpsLinkExecCommand);
    }

    protected final void doSendCmd(GpsLinkExecCommand gpsLinkExecCommand) {
        this.m.getHandler().doSendCmd(gpsLinkExecCommand);
    }

    public final void setLogFormat(int n) {
        int n2 = n;
        if ((n2 & 0x2000) == 0) {
            n2 &= 0xFFFE3FFF;
        }
        this.sendCmd("PMTK182,1,2," + JavaLibBridge.unsigned2hex(n2, 8));
        this.m.setChanged(3);
    }

    public boolean cmd(int n) {
        String string = null;
        int n2 = -1;
        switch (n) {
            case 0: {
                string = "PMTK101";
                break;
            }
            case 1: {
                string = "PMTK102";
                break;
            }
            case 2: {
                string = "PMTK103";
                break;
            }
            case 3: {
                string = "PMTK104";
                break;
            }
            case 4: {
                string = "PMTK182,4";
                this.m.setLoggingActive(true);
                break;
            }
            case 5: {
                string = "PMTK182,5";
                this.m.setLoggingActive(false);
                break;
            }
            case 6: {
                string = "PMTK182,11";
                break;
            }
            case 7: {
                string = "PMTK182,10";
                break;
            }
            case 12: {
                this.mtkLogHandler.stopErase();
                break;
            }
            case 13: {
                this.mtkLogHandler.eraseLog();
                break;
            }
            case 19: {
                this.mtkLogHandler.cancelGetLog();
                break;
            }
            case 20: {
                string = "PMTK127";
                this.m.setUnAvailable(17);
                n2 = 17;
                break;
            }
            default: {
                return false;
            }
        }
        if (string != null) {
            this.sendCmd(string);
            if (n2 != -1) {
                this.reqData(n2);
            }
        }
        return true;
    }

    public boolean reqData(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "PMTK182,2,9,9F";
                break;
            }
            case 3: {
                string = "PMTK182,2,2";
                break;
            }
            case 7: {
                string = "PMTK182,2,7";
                break;
            }
            case 2: {
                string = "PMTK182,2,8";
                break;
            }
            case 1: {
                string = "PMTK182,2,10";
                break;
            }
            case 8: {
                string = "PMTK182,2,12";
                break;
            }
            case 4: {
                string = "PMTK604";
                break;
            }
            case 5: {
                string = "PMTK605";
                break;
            }
            case 6: {
                this.mtkLogHandler.readLog(6, 2);
                return true;
            }
            case 9: {
                this.mtkLogHandler.readLog((this.m.getLogMemSize() - 1 & 0xFFFF0000) + 6, 4);
                return true;
            }
            case 11: {
                string = "PMTK182,2,3";
                break;
            }
            case 12: {
                string = "PMTK182,2,5";
                break;
            }
            case 13: {
                string = "PMTK182,2,4";
                break;
            }
            case 14: {
                string = "PMTK182,2,1";
                this.doSendCmd(new GpsLinkNmeaCommand(string));
                return true;
            }
            case 15: {
                string = "PMTK182,2,11";
                break;
            }
            case 16: {
                string = "PMTK400";
                break;
            }
            case 17: {
                string = "PMTK607";
                break;
            }
            case 18: {
                string = "PMTK182,2,6";
                break;
            }
            case 19: {
                string = "PMTK419";
                break;
            }
            case 20: {
                string = "PMTK413";
                break;
            }
            case 21: {
                string = "PMTK420";
                break;
            }
            case 22: {
                string = "PMTK430";
                break;
            }
            case 23: {
                string = "PMTK414";
                break;
            }
            case 24: {
                string = "PMTK401";
                break;
            }
            case 25: {
                string = "PMTK492";
                break;
            }
            case 26: {
                string = "PMTK490";
                break;
            }
            case 10: {
                string = "HOLUX241,5";
                break;
            }
        }
        if (string != null) {
            this.sendCmd(string);
            return true;
        }
        Generic.debug("Serious: (in MtkController) Unknown data type #" + n);
        return false;
    }

    public boolean cmd(int n, CmdParam cmdParam) {
        if (cmdParam == null) {
            return this.cmd(n);
        }
        switch (n) {
            case 8: {
                this.setLogTimeInterval(cmdParam.getInt());
                break;
            }
            case 9: {
                this.setLogDistanceInterval(cmdParam.getInt());
                break;
            }
            case 10: {
                this.setLogSpeedInterval(cmdParam.getInt());
                break;
            }
            case 11: {
                this.setHoluxName(cmdParam.getString());
                break;
            }
            case 14: {
                this.setFixInterval(cmdParam.getInt());
                break;
            }
            case 15: {
                this.setLogOverwrite(cmdParam.getBoolean());
                break;
            }
            case 16: {
                this.setSBASTestEnabled(cmdParam.getBoolean());
                break;
            }
            case 17: {
                this.setSBASEnabled(cmdParam.getBoolean());
                break;
            }
            case 18: {
                this.setPowerSaveEnabled(cmdParam.getBoolean());
                break;
            }
            default: {
                Generic.debug("Unsupported cmd in " + this);
                return false;
            }
        }
        return true;
    }

    private final void setLogTimeInterval(int n) {
        int n2 = n;
        if (n2 != 0 && n2 > 36000) {
            n2 = 36000;
        }
        this.sendCmd("PMTK182,1,3," + n2);
    }

    private final void setLogDistanceInterval(int n) {
        int n2 = n;
        if (n2 != 0 && n2 > 36000) {
            n2 = 36000;
        } else if (n2 != 0 && n2 < 1) {
            n2 = 1;
        }
        this.sendCmd("PMTK182,1,4," + n2);
    }

    private final void setLogSpeedInterval(int n) {
        int n2 = n;
        if (n2 != 0 && n2 > 36000) {
            n2 = 36000;
        } else if (n2 != 0 && n2 < 1) {
            n2 = 1;
        }
        this.sendCmd("PMTK182,1,5," + n2 * 10);
    }

    private final void setFixInterval(int n) {
        int n2 = n;
        if (n2 > 30000) {
            n2 = 30000;
        } else if (n2 < 200) {
            n2 = 200;
        }
        this.sendCmd("PMTK300," + n2 + ",0,0,0.0,0.0");
    }

    private final void setLogOverwrite(boolean bl) {
        this.sendCmd("PMTK182,1,6," + (bl ? "1" : "2"));
    }

    private final void setSBASTestEnabled(boolean bl) {
        this.sendCmd("PMTK319," + (bl ? "0" : "1"));
    }

    private final void setSBASEnabled(boolean bl) {
        this.sendCmd("PMTK313," + (bl ? "1" : "0"));
    }

    private final void setPowerSaveEnabled(boolean bl) {
        this.sendCmd("PMTK320," + (bl ? "1" : "0"));
    }

    public final void setDGPSMode(int n) {
        if (n >= 0 && n <= 2) {
            this.sendCmd("PMTK301," + n);
        }
    }

    private void setHoluxName(String string) {
        this.sendCmd("HOLUX241,4," + string);
        this.reqData(10);
    }

    public final void setBtMacAddr(String string) {
        String string2 = "";
        BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(string, ':');
        while (bT747StringTokenizer.hasMoreTokens()) {
            string2 = bT747StringTokenizer.nextToken() + string2;
        }
        if (string2.length() == 12) {
            this.sendCmd("PMTK392," + string2.substring(0, 6) + "," + string2.substring(6, 12));
            this.reqData(25);
        }
    }

    public final void setNMEAPeriods(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(255);
        stringBuffer.setLength(0);
        stringBuffer.append("PMTK314");
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(',');
            stringBuffer.append(nArray[i]);
        }
        this.sendCmd(stringBuffer.toString());
    }

    public final void setNMEADefaultPeriods() {
        int[] nArray = new int[19];
        for (int i = 0; i < 19; ++i) {
            nArray[i] = 0;
        }
        nArray[1] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[16] = 1;
        this.setNMEAPeriods(nArray);
        this.reqData(23);
    }

    public final void setFlashUserOption(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.sendCmd("PMTK390,0," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10);
    }

    public final void logImmediate(int n) {
        if (!this.m.isLoggingActive()) {
            this.cmd(4);
        }
        this.sendCmd("PMTK182,1,1," + JavaLibBridge.unsigned2hex(n, 4));
    }

    public final void setLogRequestAhead(int n) {
        this.mtkLogHandler.setLogRequestAhead(n);
    }

    public final void recoveryEraseLog() {
        this.mtkLogHandler.recoveryEraseLog();
    }

    public final void replyToOkToOverwrite(boolean bl) throws BT747Exception {
        this.mtkLogHandler.replyToOkToOverwrite(bl);
    }

    public final void getLogInit(int n, int n2, int n3, BT747Path bT747Path, boolean bl, boolean bl2) {
        this.mtkLogHandler.getLogInit(n, n2, n3, bT747Path, bl, bl2);
    }

    public void notifyRun() throws BT747Exception {
        if (this.mtkLogHandler != null) {
            this.mtkLogHandler.notifyRun();
        }
    }

    public void notifyDisconnected() {
        if (this.mtkLogHandler != null) {
            this.mtkLogHandler.notifyDisconnected();
        }
    }

    public void getLog(BT747Path bT747Path) {
        Generic.debug("getLog - call unexpected in MtkController");
    }
}

