/*
 * Decompiled with CFR 0.152.
 */
package gps.mvc;

import bt747.sys.Generic;
import bt747.sys.interfaces.BT747Exception;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747Thread;
import gps.GpsEvent;
import gps.ProtocolConstants;
import gps.mvc.CmdParam;
import gps.mvc.DeviceControllerIF;
import gps.mvc.DeviceOperationHandlerIF;
import gps.mvc.GpsLinkHandler;
import gps.mvc.GpsModel;
import gps.mvc.HoluxController;
import gps.mvc.MtkController;
import gps.mvc.MtkModel;
import gps.mvc.ProtectedDevControllerIF;
import gps.mvc.SkytraqController;
import gps.mvc.WPController;

public class GpsController
implements BT747Thread,
ProtocolConstants,
DeviceControllerIF {
    private final GpsModel gpsM;
    private MtkModel mtkM;
    private ProtectedDevControllerIF mtkC;
    private final GpsLinkHandler handler;
    private int protocol = -1;
    private boolean eraseRequested;
    private int nextValueToCheck = 0;
    private volatile DeviceOperationHandlerIF operationHandler;
    private int nextRun = 0;
    private int nextAvailableRun = 0;

    public static final GpsController getInstance(GpsModel gpsModel, int n) {
        return new GpsController(gpsModel, n);
    }

    private GpsController(GpsModel gpsModel, int n) {
        this.gpsM = gpsModel;
        this.mtkM = this.gpsM.getMtkModel();
        this.setProtocol(n);
        this.handler = this.gpsM.getHandler();
    }

    public final void setProtocol(int n) {
        if (this.protocol != n && this.mtkC != null) {
            if (this.handler.isConnected()) {
                this.handler.getGPSRxtx().closePort();
            }
            this.mtkC = null;
        }
        this.mtkM = this.gpsM.getMtkModel();
        if (this.mtkC != null) {
            return;
        }
        this.protocol = n;
        switch (this.protocol) {
            default: {
                this.mtkC = new MtkController(this, this.mtkM);
                break;
            }
            case 2: {
                this.mtkC = new HoluxController(this, this.mtkM, true);
                break;
            }
            case 5: {
                this.mtkC = new HoluxController(this, this.mtkM, false);
                break;
            }
            case 1: {
                this.mtkC = new WPController(this, this.mtkM);
                break;
            }
            case 4: {
                this.mtkC = new SkytraqController(this, this.mtkM);
            }
        }
    }

    public final MtkController getMtkController() {
        return (MtkController)this.mtkC;
    }

    public final void setGpsDecode(boolean bl) {
        this.gpsM.setGpsDecode(bl);
    }

    public final void setDataNeeded(int n) {
        int n2;
        if (this.handler.isConnected() && this.mtkM.isDataNeedsRequest(n2 = Generic.getTimeStamp(), n)) {
            this.mtkC.reqData(n);
        }
        if (Generic.isDebug() && Generic.getDebugLevel() >= 3) {
            Generic.debug("Data request of " + n + " skipped");
        }
    }

    public final void reqDeviceInfo() {
        this.setDataNeeded(5);
        this.setDataNeeded(4);
        this.setDataNeeded(0);
        this.setDataNeeded(8);
    }

    public final void setDownloadTimeOut(int n) {
        this.handler.setDownloadTimeOut(n);
    }

    public final void reqStatus() {
        this.setDataNeeded(3);
        this.getLogCtrlInfo();
        this.mtkC.reqData(10);
        this.setDataNeeded(17);
    }

    public final void reqLogOnOffStatus() {
        this.mtkC.reqData(7);
    }

    private final void getLogCtrlInfo() {
        this.setDataNeeded(0);
        this.setDataNeeded(2);
        this.mtkC.reqData(18);
        this.setDataNeeded(8);
        this.setDataNeeded(1);
    }

    public final void eraseLog() {
        this.eraseRequested = true;
        this.mtkM.setEraseOngoing(true);
    }

    public final void stopErase() {
        this.eraseRequested = false;
        this.mtkC.cmd(12);
    }

    public final void initConnection() {
        if (this.handler.isConnected()) {
            this.nextRun = Generic.getTimeStamp() + 300;
            this.resetAvailable();
            this.handler.initConnected();
            Generic.addThread(this, false);
        }
    }

    private void resetAvailable() {
        this.gpsM.setAllUnavailable();
        this.nextValueToCheck = 0;
    }

    private void checkNextAvailable() {
        int n = this.nextValueToCheck;
        this.setDataNeeded(n);
        if (++n > 9) {
            n = 0;
        }
        this.nextValueToCheck = n;
    }

    public final void setDeviceOperationHandler(DeviceOperationHandlerIF deviceOperationHandlerIF) {
        this.operationHandler = deviceOperationHandlerIF;
    }

    public final void run() {
        block14: {
            try {
                int n = Generic.getTimeStamp();
                ProtectedDevControllerIF protectedDevControllerIF = this.mtkC;
                if (n < this.nextRun) break block14;
                this.nextRun = n + 10;
                int n2 = 0;
                if (this.handler.isConnected()) {
                    try {
                        protectedDevControllerIF.notifyRun();
                    }
                    catch (BT747Exception bT747Exception) {
                        this.setDeviceOperationHandler(null);
                        Generic.debug("Controller: ", bT747Exception);
                        this.gpsM.postEvent(new GpsEvent(38, bT747Exception));
                    }
                    DeviceOperationHandlerIF deviceOperationHandlerIF = this.operationHandler;
                    if (deviceOperationHandlerIF != null) {
                        try {
                            if (!deviceOperationHandlerIF.notifyRun(this.handler)) {
                                this.setDeviceOperationHandler(null);
                            }
                        }
                        catch (BT747Exception bT747Exception) {
                            this.setDeviceOperationHandler(null);
                            Generic.debug("Handler: ", bT747Exception);
                            this.gpsM.postEvent(new GpsEvent(38, bT747Exception));
                        }
                    }
                    deviceOperationHandlerIF = this.operationHandler;
                    do {
                        Object object;
                        if ((object = this.handler.getResponse()) != null) {
                            if (deviceOperationHandlerIF != null && deviceOperationHandlerIF.analyseResponse(object)) continue;
                            this.gpsM.analyseResponse(object);
                        } else {
                            n2 = 0;
                        }
                        this.handler.checkSendCmdFromQueue();
                    } while (n2-- > 0);
                    if (this.nextAvailableRun < n && this.handler.getOutStandingCmdsCount() == 0 && !this.mtkM.isLogDownloadOngoing()) {
                        if (this.eraseRequested) {
                            this.eraseRequested = false;
                            protectedDevControllerIF.cmd(13);
                        }
                        this.nextAvailableRun = this.nextRun + 300;
                        this.checkNextAvailable();
                    }
                    break block14;
                }
                Generic.removeThread(this);
                protectedDevControllerIF.notifyDisconnected();
            }
            catch (Exception exception) {
                Generic.debug("Exception in Controller run", exception);
            }
        }
    }

    public final void started() {
    }

    public final boolean cmd(int n) {
        return this.mtkC.cmd(n);
    }

    public final boolean cmd(int n, CmdParam cmdParam) {
        return this.mtkC.cmd(n, cmdParam);
    }

    public void getLog(BT747Path bT747Path) {
        this.mtkC.getLog(bT747Path);
    }
}

