/*
 * Decompiled with CFR 0.152.
 */
package gps.log.out;

import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747Time;
import gps.convert.ExternalUtils;
import gps.log.GPSRecord;
import gps.log.out.CommonOut;
import gps.log.out.GPSFile;

public final class GPSNMEAFile
extends GPSFile {
    private final StringBuffer rec = new StringBuffer(1024);
    private int fieldsNmeaOut;
    private boolean separateFileForWpts = false;
    private int currentFilterIdx;

    public void initialiseFile(BT747Path bT747Path, String string, int n) {
        super.initialiseFile(bT747Path, string, n);
        this.fieldsNmeaOut = this.getParamObject().getIntParam("nmea-out");
        this.separateFileForWpts = this.getParamObject().hasParam("pos-digits") ? this.getParamObject().getBoolParam("pos-digits") : false;
        this.numberOfPasses = this.separateFileForWpts ? 2 : 1;
        this.currentFilterIdx = 0;
    }

    private final void writeNMEA(String string) {
        int n = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            n ^= (byte)string.charAt(i);
        }
        this.writeTxt("$");
        this.writeTxt(string);
        this.writeTxt("*" + JavaLibBridge.unsigned2hex(n, 2) + "\r\n");
    }

    protected final boolean recordIsNeeded(GPSRecord gPSRecord) {
        return this.ptFilters[this.currentFilterIdx].doFilter(gPSRecord);
    }

    public final void writeRecord(GPSRecord gPSRecord) {
        super.writeRecord(gPSRecord);
        if (this.cachedRecordIsNeeded(gPSRecord)) {
            String string = GPSNMEAFile.getTimeStr(this.t, gPSRecord, this.selectedFileFields);
            if ((this.fieldsNmeaOut & 0x20000) != 0) {
                this.writeZDA(gPSRecord, string);
            }
            if ((this.fieldsNmeaOut & 2) != 0) {
                this.writeRMC(gPSRecord, string);
            }
            if ((this.fieldsNmeaOut & 8) != 0) {
                this.writeGGA(gPSRecord, string);
            }
            if ((this.fieldsNmeaOut & 0x10) != 0) {
                this.writeGSA(gPSRecord, string);
            }
            if ((this.fieldsNmeaOut & 0x20) != 0) {
                this.writeGSV(gPSRecord, string);
            }
            if ((this.fieldsNmeaOut & 0x80000) != 0 && this.ptFilters[1].doFilter(gPSRecord)) {
                this.writeWPL(gPSRecord);
            }
        }
    }

    private static final String getTimeStr(BT747Time bT747Time, GPSRecord gPSRecord, GPSRecord gPSRecord2) {
        String string = "";
        if (gPSRecord.hasUtc() && gPSRecord2.hasUtc()) {
            string = (bT747Time.getHour() < 10 ? "0" : "") + bT747Time.getHour() + (bT747Time.getMinute() < 10 ? "0" : "") + bT747Time.getMinute() + (bT747Time.getSecond() < 10 ? "0" : "") + bT747Time.getSecond();
            if (gPSRecord.hasMillisecond() && gPSRecord2.hasMillisecond()) {
                string = string + "." + (gPSRecord.milisecond < 100 ? "0" : "") + (gPSRecord.milisecond < 10 ? "0" : "") + gPSRecord.milisecond;
            }
        }
        return string;
    }

    private void writeRMC(GPSRecord gPSRecord, String string) {
        this.writeNMEA(GPSNMEAFile.toRMC(this.rec, gPSRecord, this.t, string, this.selectedFileFields));
    }

    private static final void appendLatLon(StringBuffer stringBuffer, GPSRecord gPSRecord, GPSRecord gPSRecord2) {
        int n;
        double d;
        String string;
        if (gPSRecord.hasLatitude() && gPSRecord2.hasLatitude()) {
            if (gPSRecord.getLatitude() >= 0.0) {
                string = ",N,";
                d = gPSRecord.getLatitude();
            } else {
                string = ",S,";
                d = -gPSRecord.getLatitude();
            }
            n = (int)Math.floor(d);
            stringBuffer.append((n < 10 ? "0" : "") + n);
            d -= (double)n;
            stringBuffer.append(((d *= 60.0) < 10.0 ? "0" : "") + JavaLibBridge.toString(d, 6));
            stringBuffer.append(string);
        } else {
            stringBuffer.append(",,");
        }
        if (gPSRecord.hasLongitude() && gPSRecord2.hasLongitude()) {
            if (gPSRecord.getLongitude() >= 0.0) {
                string = ",E,";
                d = gPSRecord.getLongitude();
            } else {
                string = ",W,";
                d = -gPSRecord.getLongitude();
            }
            n = (int)Math.floor(d);
            stringBuffer.append((n < 100 ? "0" : "") + (n < 10 ? "0" : "") + n);
            d -= (double)n;
            stringBuffer.append(((d *= 60.0) < 10.0 ? "0" : "") + JavaLibBridge.toString(d, 6));
            stringBuffer.append(string);
        } else {
            stringBuffer.append(",,");
        }
    }

    private static final String toRMC(StringBuffer stringBuffer, GPSRecord gPSRecord, BT747Time bT747Time, String string, GPSRecord gPSRecord2) {
        String string2;
        stringBuffer.setLength(0);
        stringBuffer.append("GPRMC,");
        if (gPSRecord.hasUtc() && gPSRecord2.hasUtc()) {
            stringBuffer.append(string);
        }
        if (gPSRecord.hasValid() && gPSRecord2.hasValid()) {
            switch (gPSRecord.getValid()) {
                case 1: {
                    string2 = ",V,";
                    break;
                }
                default: {
                    string2 = ",A,";
                }
            }
            stringBuffer.append(string2);
        } else {
            stringBuffer.append(",,");
        }
        GPSNMEAFile.appendLatLon(stringBuffer, gPSRecord, gPSRecord2);
        if (gPSRecord.hasSpeed() && gPSRecord2.hasSpeed()) {
            stringBuffer.append(JavaLibBridge.toString((double)gPSRecord.getSpeed() * 0.5399568034557235, 3));
        }
        stringBuffer.append(",");
        if (gPSRecord.hasHeading() && gPSRecord2.hasHeading()) {
            stringBuffer.append(JavaLibBridge.toString(gPSRecord.getHeading(), 6));
        }
        stringBuffer.append(",");
        if (gPSRecord.hasUtc() && gPSRecord2.hasUtc()) {
            stringBuffer.append((bT747Time.getDay() < 10 ? "0" : "") + bT747Time.getDay() + (bT747Time.getMonth() < 10 ? "0" : "") + bT747Time.getMonth() + (bT747Time.getYear() % 100 < 10 ? "0" : "") + bT747Time.getYear() % 100);
        }
        stringBuffer.append(",,");
        if (gPSRecord.hasValid() && gPSRecord2.hasValid() && gPSRecord.getValid() == 4) {
            stringBuffer.append(",D");
        } else {
            stringBuffer.append(",A");
        }
        string2 = stringBuffer.toString();
        stringBuffer.setLength(0);
        return string2;
    }

    private void writeGGA(GPSRecord gPSRecord, String string) {
        this.writeNMEA(GPSNMEAFile.toGGA(this.rec, gPSRecord, string, this.selectedFileFields));
    }

    private static final String toGGA(StringBuffer stringBuffer, GPSRecord gPSRecord, String string, GPSRecord gPSRecord2) {
        stringBuffer.setLength(0);
        stringBuffer.append("GPGGA,");
        if (gPSRecord.hasUtc() && gPSRecord2.hasUtc()) {
            stringBuffer.append(string);
        }
        stringBuffer.append(",");
        GPSNMEAFile.appendLatLon(stringBuffer, gPSRecord, gPSRecord2);
        if (gPSRecord.hasValid() && gPSRecord2.hasValid()) {
            String string2 = "";
            switch (gPSRecord.getValid()) {
                case 1: {
                    string2 = "0";
                    break;
                }
                case 2: {
                    string2 = "1";
                    break;
                }
                case 4: {
                    string2 = "2";
                    break;
                }
                case 8: {
                    string2 = "3";
                    break;
                }
                case 16: {
                    string2 = "4";
                    break;
                }
                case 32: {
                    string2 = "5";
                    break;
                }
                case 64: {
                    break;
                }
                case 128: {
                    break;
                }
                case 256: {
                    break;
                }
            }
            stringBuffer.append(string2);
        }
        stringBuffer.append(",");
        if (gPSRecord.hasNsat() && gPSRecord2.hasNsat()) {
            stringBuffer.append((gPSRecord.getNsat() & 0xFF00) >> 8);
        } else {
            stringBuffer.append("8");
        }
        stringBuffer.append(",");
        if (gPSRecord.hasHdop() && gPSRecord2.hasHdop()) {
            stringBuffer.append(JavaLibBridge.toString((float)gPSRecord.getHdop() / 100.0f, 2));
        }
        stringBuffer.append(",");
        if (gPSRecord.hasHeight() && gPSRecord2.hasHeight()) {
            boolean bl;
            float f = 0.0f;
            boolean bl2 = bl = gPSRecord.hasPosition() && gPSRecord2.hasPosition();
            if (bl) {
                f = (float)((long)(10.0 * ExternalUtils.wgs84Separation(gPSRecord.getLatitude(), gPSRecord.getLongitude()))) / 10.0f;
            }
            stringBuffer.append(JavaLibBridge.toString(gPSRecord.getHeight() - f, 3));
            if (bl) {
                stringBuffer.append(",M,");
                stringBuffer.append(JavaLibBridge.toString(f, 1));
                stringBuffer.append(",M,");
            } else {
                stringBuffer.append(",M,0,M,");
            }
        } else {
            stringBuffer.append(",,,,");
        }
        if (gPSRecord.hasDage() && gPSRecord2.hasDage()) {
            stringBuffer.append(gPSRecord.getDage());
        }
        stringBuffer.append(",");
        if (gPSRecord.hasDsta() && gPSRecord2.hasDsta()) {
            stringBuffer.append(gPSRecord.getDsta());
        }
        String string3 = stringBuffer.toString();
        stringBuffer.setLength(0);
        return string3;
    }

    private void writeGSV(GPSRecord gPSRecord, String string) {
        if (gPSRecord.hasSid() && this.selectedFileFields.hasSid()) {
            int n = gPSRecord.sid.length - 1;
            int n2 = 1;
            int n3 = 0;
            while (n >= 0) {
                this.rec.setLength(0);
                this.rec.append("GPGSV,");
                this.rec.append((gPSRecord.sid.length + 3) / 4);
                this.rec.append(",");
                this.rec.append(n2);
                this.rec.append(",");
                this.rec.append(gPSRecord.getNsat() & 0xFF);
                this.rec.append(",");
                int n4 = 4;
                while (n4 > 0) {
                    if (n >= 0) {
                        if (gPSRecord.sid[n3] < 10) {
                            this.rec.append('0');
                        }
                        this.rec.append(gPSRecord.sid[n3]);
                        this.rec.append(",");
                        if (gPSRecord.hasEle() && this.selectedFileFields.hasEle()) {
                            if (gPSRecord.ele[n3] < 10) {
                                this.rec.append('0');
                            }
                            this.rec.append(gPSRecord.ele[n3]);
                        }
                        this.rec.append(",");
                        if (gPSRecord.hasAzi() && this.selectedFileFields.hasAzi()) {
                            if (gPSRecord.azi[n3] < 10) {
                                this.rec.append('0');
                            }
                            this.rec.append(gPSRecord.azi[n3]);
                        }
                        this.rec.append(",");
                        if (gPSRecord.hasSnr() && this.selectedFileFields.hasSnr()) {
                            if (gPSRecord.snr[n3] < 10) {
                                this.rec.append('0');
                            }
                            this.rec.append(gPSRecord.snr[n3]);
                        }
                        this.rec.append(",");
                    } else {
                        this.rec.append(",,,,");
                    }
                    --n;
                    --n4;
                    ++n3;
                }
                this.writeNMEA(this.rec.toString());
                this.rec.setLength(0);
                ++n2;
            }
        }
    }

    private void writeZDA(GPSRecord gPSRecord, String string) {
        if (gPSRecord.hasUtc() && this.selectedFileFields.hasUtc()) {
            this.rec.setLength(0);
            this.rec.append("GPZDA,");
            this.rec.append(string);
            this.rec.append("," + (this.t.getDay() < 10 ? "0" : "") + this.t.getDay() + "," + (this.t.getMonth() < 10 ? "0" : "") + this.t.getMonth() + "," + this.t.getYear() + ",,");
            this.writeNMEA(this.rec.toString());
            this.rec.setLength(0);
        }
    }

    private void writeGSA(GPSRecord gPSRecord, String string) {
        if (gPSRecord.hasValid() && this.selectedFileFields.hasValid() || gPSRecord.hasSid() && this.selectedFileFields.hasSid() || gPSRecord.hasPdop() && this.selectedFileFields.hasPdop() || gPSRecord.hasHdop() && this.selectedFileFields.hasHdop() || gPSRecord.hasVdop() && this.selectedFileFields.hasVdop()) {
            this.rec.setLength(0);
            this.rec.append("GPGSA,A,");
            if (gPSRecord.hasValid() && this.selectedFileFields.hasValid()) {
                if (gPSRecord.getValid() == 1) {
                    this.rec.append("1");
                } else {
                    this.rec.append("3");
                }
            }
            this.rec.append(",");
            int n = gPSRecord.sid != null ? gPSRecord.sid.length : 0;
            int n2 = n - 1;
            int n3 = 12;
            int n4 = 0;
            while (n3 > 0) {
                if (n2 > 0 && gPSRecord.sidinuse[n4]) {
                    this.rec.append(gPSRecord.sid[n4]);
                }
                this.rec.append(",");
                --n3;
                --n2;
                ++n4;
            }
            if (gPSRecord.hasPdop() && this.selectedFileFields.hasPdop()) {
                this.rec.append(JavaLibBridge.toString((float)gPSRecord.getPdop() / 100.0f, 2));
            }
            this.rec.append(",");
            if (gPSRecord.hasHdop() && this.selectedFileFields.hasHdop()) {
                this.rec.append(JavaLibBridge.toString((float)gPSRecord.getHdop() / 100.0f, 2));
            }
            this.rec.append(",");
            if (gPSRecord.hasVdop() && this.selectedFileFields.hasVdop()) {
                this.rec.append(JavaLibBridge.toString((float)gPSRecord.getVdop() / 100.0f, 2));
            }
            this.writeNMEA(this.rec.toString());
            this.rec.setLength(0);
        }
    }

    private void writeWPL(GPSRecord gPSRecord) {
        if (gPSRecord.hasPosition()) {
            this.rec.setLength(0);
            this.rec.append("GPWPL,");
            GPSNMEAFile.appendLatLon(this.rec, gPSRecord, this.selectedFileFields);
            this.rec.append(CommonOut.getRCRstr(gPSRecord));
            this.writeNMEA(this.rec.toString());
            this.rec.setLength(0);
        }
    }

    public final boolean nextPass() {
        super.nextPass();
        if (this.separateFileForWpts && this.currentFilterIdx == 0) {
            this.previousDate = 0;
            this.ext = "_WPT" + this.ext;
            this.createNewFiles = true;
            this.currentFilterIdx = 1;
            return true;
        }
        return false;
    }
}

