/*
 * Decompiled with CFR 0.152.
 */
package gps.log.out;

import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import gps.log.GPSRecord;
import gps.log.out.GPSFile;

public final class GPSGmapsHTMLFile
extends GPSFile {
    private final StringBuffer rec = new StringBuffer(1024);
    private boolean m_isWayType;
    private boolean m_newTrack = true;
    private int m_currentFilter;
    private double minlat;
    private double maxlat;
    private double minlon;
    private double maxlon;

    public GPSGmapsHTMLFile() {
        this.numberOfPasses = 2;
    }

    public void initialiseFile(BT747Path bT747Path, String string, int n) {
        super.initialiseFile(bT747Path, string, n);
        this.m_currentFilter = 1;
        this.m_isWayType = true;
    }

    public boolean nextPass() {
        super.nextPass();
        if (this.nbrOfPassesToGo > 0) {
            --this.nbrOfPassesToGo;
            this.previousDate = 0;
            this.m_isWayType = false;
            this.m_currentFilter = 0;
            return true;
        }
        return false;
    }

    protected void writeFileHeader(String string) {
        String string2 = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:v=\"urn:schemas-microsoft-com:vml\">\r\n<head>\r\n<title>KML to Google Maps converter using PHP </title>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=Windows-1252\" />\r\n<meta name=\"description\" content=\"test - powered by Google Maps\" />\r\n\r\n<script src=\"http://maps.google.com/maps?file=api&amp;v=2&amp\" type=\"text/javascript\">\r\n</script>\r\n\r\n<style type=\"text/css\">\r\n             v\\:* {\r\n             behavior:url(#default#VML);\r\n             }\r\n             html, body, #map\r\n             {\r\n               width: 100%;\r\n               height: 100%;\r\n             }\r\n           body             {\r\n             margin-top: 0px;\r\n             margin-right: 0px;\r\n             margin-left: 0px;\r\n             margin-bottom: 0px;\r\n             }\r\n\r\n</style>\r\n</head>\r\n\r\n<body>\r\n<div id=\"map\"> </div>\r\n\r\n<script type=\"text/javascript\">\r\n//<![CDATA[             // check for compatibility\r\n\r\nif (GBrowserIsCompatible()) {                 // call the info window opener for the given index\r\n\r\n  function makeOpenerCaller(i) {\r\n     return function() { showMarkerInfo(i); };\r\n\r\n  }                 // open an info window\r\n\r\n  function showMarkerInfo(i) {\r\n     markers[i].openInfoWindowHtml(infoHtmls[i]);\r\n  }                 // create the map\r\n\r\n     var map = new GMap2(document.getElementById(\"map\"));\r\n     map.setCenter(new GLatLng(0,0));\r\n     map.setMapType(G_SATELLITE_MAP);\r\n     map.enableScrollWheelZoom();\r\n     map.addControl(new GLargeMapControl());\r\n     map.addControl(new GMapTypeControl());\r\n     map.addControl(new GScaleControl());\r\n     map.addControl(new GOverviewMapControl());\r\n     if (window.attachEvent) {\r\n       window.attachEvent(\"onresize\", function() {this.map.onResize()} );\r\n     } else {\r\n       window.addEventListener(\"resize\", function() {this.map.onResize()} , false);\r\n     }                 // add a polyline overlay\r\n     var points = new Array();points=[];";
        this.writeTxt(string2);
        this.minlat = 9999.0;
        this.maxlat = -9999.0;
        this.minlon = 9999.0;
        this.maxlon = -9999.0;
    }

    protected void writeDataHeader() {
        if (!this.m_isWayType) {
            String string = "points=[];";
            this.m_newTrack = true;
            this.writeTxt(string);
        }
    }

    protected void writeDataFooter() {
        if (!this.m_isWayType) {
            this.writeTxt("map.addOverlay(new GPolyline(points,\"#0000FF\",2,.75));\r\n");
        }
    }

    public void writeRecord(GPSRecord gPSRecord) {
        super.writeRecord(gPSRecord);
        if (!this.ptFilters[this.m_currentFilter].doFilter(gPSRecord)) {
            if (!(this.m_isWayType || this.m_newTrack || this.firstRecord)) {
                this.m_newTrack = true;
                this.writeTxt("map.addOverlay(new GPolyline(points,\"#0000FF\",2,.75));\r\n");
                this.writeTxt("points=[];");
            }
        } else {
            this.rec.setLength(0);
            this.m_newTrack = false;
            if (gPSRecord.hasPosition()) {
                this.rec.append("points.push(new GLatLng(");
                this.rec.append(JavaLibBridge.toString(gPSRecord.getLatitude(), 6));
                this.rec.append(',');
                this.rec.append(JavaLibBridge.toString(gPSRecord.getLongitude(), 6));
                this.rec.append("));");
                if (gPSRecord.getLatitude() < this.minlat) {
                    this.minlat = gPSRecord.getLatitude();
                }
                if (gPSRecord.getLatitude() > this.maxlat) {
                    this.maxlat = gPSRecord.getLatitude();
                }
                if (gPSRecord.getLongitude() < this.minlon) {
                    this.minlon = gPSRecord.getLongitude();
                }
                if (gPSRecord.getLongitude() > this.maxlon) {
                    this.maxlon = gPSRecord.getLongitude();
                }
            }
            this.writeTxt(this.rec.toString());
        }
    }

    public void finaliseFile() {
        if (this.isOpen()) {
            this.writeDataFooter();
            String string = "map.setCenter(new GLatLng(" + JavaLibBridge.toString((this.maxlat + this.minlat) / 2.0) + "," + JavaLibBridge.toString((this.maxlon + this.minlon) / 2.0) + "));" + "map.setZoom(map.getBoundsZoomLevel(new GLatLngBounds(new GLatLng(" + this.minlat + ',' + this.minlon + "),new GLatLng(" + this.maxlat + ',' + this.maxlon + "))));" + "\r\n" + "   }\r\n" + "   else {\r\n" + "     document.getElementById(\"quicklinks\").innerHTML = \"Your web browser is not compatible with this website.\"\r\n" + "   }\r\n" + "//]]>\r\n" + "</script>\r\n" + "\r\n" + "</body>\r\n" + "</html>";
            this.writeTxt(string);
        }
        super.finaliseFile();
    }
}

