/*
 * Decompiled with CFR 0.152.
 */
package gps.log.out;

import bt747.sys.I18N;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Hashtable;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747Vector;
import gps.log.GPSRecord;
import gps.log.out.CommonOut;
import gps.log.out.GPSFile;
import gps.log.out.WayPointStyle;
import gps.tracks.PolylineEncoder;
import gps.tracks.Track;
import gps.tracks.Trackpoint;

public final class GPSGmapsHTMLEncodedFile
extends GPSFile {
    private final StringBuffer rec = new StringBuffer(1024);
    private boolean isWayType;
    private boolean isNewTrack = true;
    private int currentFilter;
    private final Track track = new Track();
    private final Track waypoints = new Track();
    private int trackIndex = 0;
    private String trackOnClickFuncCalls = "";
    private final StringBuffer infoHtmls = new StringBuffer(1024);
    private final BT747Vector iconList = JavaLibBridge.getVectorInstance();
    private String trackStartInfo = "";
    private String trackDescription = "";
    private double minlat;
    private double maxlat;
    private double minlon;
    private double maxlon;
    private final BT747Hashtable icons = JavaLibBridge.getHashtableInstance(10);
    private int previousTime = 0;
    private int previousRec = 0;

    public GPSGmapsHTMLEncodedFile() {
        this.numberOfPasses = 2;
    }

    public final void initialiseFile(BT747Path bT747Path, String string, int n) {
        super.initialiseFile(bT747Path, string, n);
        this.currentFilter = 1;
        this.isWayType = true;
        this.trackDescription = "";
        this.resetTrack();
    }

    private final void resetTrack() {
        this.track.removeAll();
    }

    public final boolean nextPass() {
        super.nextPass();
        if (this.nbrOfPassesToGo > 0) {
            this.trackDescription = "";
            --this.nbrOfPassesToGo;
            this.previousDate = 0;
            this.isWayType = false;
            this.currentFilter = 0;
            return true;
        }
        return false;
    }

    private final String keyCode() {
        String string = this.getParamObject().getStringParam("googlemapkey");
        if (string != null && string.length() != 0) {
            return ";key=" + string;
        }
        return "";
    }

    protected final void writeFileHeader(String string) {
        StringBuffer stringBuffer = new StringBuffer(1700);
        stringBuffer.setLength(0);
        stringBuffer.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:v=VML>\n<head>\n<title>");
        stringBuffer.append(string);
        stringBuffer.append("</title>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf8\" />\n<meta name=\"description\" content=\"Tracks - Generated with BT747 V2.1.7 http://www.bt747.org - powered by Google Maps\" />\n\n<script src=\"http://maps.google.com/maps?file=api&amp;v=2&amp");
        stringBuffer.append(this.keyCode());
        stringBuffer.append("\" type=\"text/javascript\">\n</script>\n<style type=\"text/css\">\n v\\:* {\n  behavior:url(#default#VML);\n }\n html, body, #map\n  {\n   width: 100%;\n   height: 100%;\n  }\n body {\n  margin-top: 0px;\n  margin-right: 0px;\n  margin-left: 0px;\n  margin-bottom: 0px;\n }\n\n</style>\n</head>\n\n<body  onresize=\"setFooter()\" onunload=\"GUnload()\">\n<div id=\"map\"> </div>\n<div id=\"footer\">\n\n<form style=\"display:inline\" action=\"javascript:gotoAddr()\">\n<input type=\"submit\" value=\"");
        stringBuffer.append(I18N.i18n("Go To"));
        stringBuffer.append("\" />\n<input type=\"submit\" value=\"\" style=\"display:none\" />\n<input size=\"30\" type=\"text\" name=\"adr\" id=\"adr\" />\n</form>\n<input type=\"submit\" value=\"");
        stringBuffer.append(I18N.i18n("Init"));
        stringBuffer.append("\" onclick=\"initial()\"/><span id=\"latlon\">");
        stringBuffer.append(I18N.i18n("Click on map to get position."));
        stringBuffer.append("  </span>");
        stringBuffer.append(I18N.i18n("Tracks"));
        stringBuffer.append(": \n<script type=\"text/javascript\">\nif (GBrowserIsCompatible()) {\n geocoder = new GClientGeocoder();\n preva = \"none\";\n function showaddr(latlng) {\n  if (latlng) {\n   geocoder.getLocations(latlng, function(adrs) {\n    if(adrs.Status.code == 200) {\n     adr=adrs.Placemark[0];\n     var txt=adr.address;\n     if(txt==preva) {\n      map.openInfoWindow(latlng, txt);\n     } else {\n      preva = txt;\n     }\n    }\n   });\n  }\n }\n\nfunction latlonTxt(latlon) {\n if(latlon) {\n     var s='<b>");
        stringBuffer.append(I18N.i18n("Last click"));
        stringBuffer.append(": '+ latlon.toUrlValue()+' </b>';\n  showaddr(latlon);  document.getElementById(\"latlon\").innerHTML = s;\n }\n}\nfunction latlonFunc() {\n return function(overlay,latlon) {latlonTxt(latlon);}\n}\nfunction gotoPt(pt) {\n if(!pt){\n  document.getElementById(\"latlon\").innerHTML=\"");
        stringBuffer.append(I18N.i18n("Location not found"));
        stringBuffer.append("\";\n } else {\n  map.setCenter(pt);latlonTxt(pt);\n }\n}\n\nfunction gotoAddr(){\n var ad=document.getElementById(\"adr\").value;\n new GClientGeocoder().getLatLng(ad,gotoPt);\n}\nfunction makeOpenerCaller(i) { return function() { showMarkerInfo(i); };}\nfunction showMarkerInfo(i) {\n markers[i].openInfoWindowHtml(infoHtmls[i]);\n}\nfunction getWindowHeight() {\n var windowHeight=0;\n if (typeof(window.innerHeight)=='number') {\n  windowHeight=window.innerHeight;\n } else {\n  if (document.documentElement&&document.documentElement.clientHeight) {\n  windowHeight = document.documentElement.clientHeight;\n  } else {\n   if (document.body&&document.body.clientHeight) {\n    windowHeight=document.body.clientHeight;\n   }\n  }\n }\n return windowHeight;\n}\nfunction setFooter() {\n if (document.getElementById) {\n  var windowHeight=getWindowHeight();\n  var footerElement=document.getElementById('footer');\n  var footerHeight=footerElement.offsetHeight;\n   document.getElementById('map').style.height=\n    (windowHeight-footerHeight)+'px';\n }\n}\nfunction trackClick(trk,val) {\n if (val == 1) {\n  map.addOverlay(trk);\n } else {\n  map.removeOverlay(trk);\n } }\nfunction makeLatLonInfo(h) {\n return function(latlng) {\n  latlonTxt(latlng);\n  map.openInfoWindowHtml(latlng, h);\n };\n} var clickStr; clickStr=\"\"; function clickString() {\n  document.write(clickStr);\n }\n var map = new GMap2(document.getElementById(\"map\"));\n map.setCenter(new GLatLng(0,0));\n var mgr = new GMarkerManager(map);\n map.addMapType(G_PHYSICAL_MAP);\n  map.enableScrollWheelZoom();\n map.addControl(new GLargeMapControl());\n map.addControl(new GMapTypeControl());\n map.addControl(new GScaleControl());\n map.addControl(new GOverviewMapControl());\nvar OSM = new GMapType(\n[ new GTileLayer(null,1,18,\n{ tileUrlTemplate: 'http://tile.openstreetmap.org/{Z}/{X}/{Y}.png',\n isPng: true, opacity: 1.0 })],\nnew GMercatorProjection(19),\n'OSM',\n{ errorMessage:\"More OSM coming soon\"}\n);\nvar OSMcycle = new GMapType(\n[ new GTileLayer(null,1,15,\n{ tileUrlTemplate: 'http://www.thunderflames.org/tiles/cycle/{Z}/{X}/{Y}.png',\n isPng: true, opacity: 1.0 })],\nnew GMercatorProjection(19),\n'Cycle',\n{ errorMessage:\"More OSM coming soon\"}\n);\nvar Osmarender = new GMapType(\n[ new GTileLayer(null,1,18,\n{ tileUrlTemplate: 'http://tah.openstreetmap.org/Tiles/tile/{Z}/{X}/{Y}.png',\n isPng: true, opacity: 1.0 })],\nnew GMercatorProjection(19),\n'Osmardr',\n{ errorMessage:\"More OSM coming soon\"}\n);\nmap.addMapType(OSM);\nmap.addMapType(OSMcycle);\nmap.addMapType(Osmarender);\n");
        this.writeTxt(stringBuffer.toString());
    }

    protected final void writeDataHeader() {
        if (!this.isWayType) {
            this.isNewTrack = true;
            this.minlat = 90.0;
            this.maxlat = -90.0;
            this.minlon = 180.0;
            this.maxlon = -180.0;
        }
    }

    protected final void endTrack(String string) {
        PolylineEncoder polylineEncoder = new PolylineEncoder();
        BT747Hashtable bT747Hashtable = polylineEncoder.dpEncode(this.track);
        String string2 = (String)bT747Hashtable.get("encodedPoints");
        if (string2.length() >= 2) {
            this.rec.setLength(0);
            this.trackOnClickFuncCalls = this.trackOnClickFuncCalls + "trackClick(track" + this.trackIndex + ",this.checked);";
            this.rec.append("var track");
            this.rec.append(this.trackIndex);
            this.rec.append(";\nmap.addOverlay(");
            this.rec.append("track");
            this.rec.append(this.trackIndex);
            this.rec.append("=new GPolyline.fromEncoded({\n  color: \"#");
            this.rec.append(string);
            this.rec.append("\",\n  weight: 4,\n  opacity: 0.8,\n  points: \"");
            this.rec.append(string2);
            this.rec.append("\",\n  levels: \"");
            this.rec.append(bT747Hashtable.get("encodedLevels"));
            this.rec.append("\",\n  zoomFactor: 2,\n  numLevels: 18\n}));\n");
            this.rec.append("GEvent.addListener(track");
            this.rec.append(this.trackIndex);
            this.rec.append(",'click',makeLatLonInfo(\"<b>Track span</b><br/>" + this.trackStartInfo + "<br/>");
            this.rec.append("<b>#" + this.previousRec + "# </b>" + CommonOut.getDateTimeStr(this.previousTime));
            this.rec.append("\"));\n");
            this.writeTxt(this.rec.toString());
            this.rec.setLength(0);
        }
        ++this.trackIndex;
        this.resetTrack();
    }

    protected final void writeDataFooter() {
        if (this.isWayType) {
            if (this.waypoints.size() != 0) {
                this.rec.setLength(0);
                this.rec.append("var baseIcon = new GIcon(G_DEFAULT_ICON);\nbaseIcon.iconSize = new GSize(32, 32);\n");
                BT747Hashtable bT747Hashtable = this.icons.iterator();
                while (bT747Hashtable.hasNext()) {
                    Object object = bT747Hashtable.nextKey();
                    this.rec.append("var ICON");
                    this.rec.append((String)object);
                    this.rec.append("=new GIcon(baseIcon);");
                    this.rec.append("ICON");
                    this.rec.append((String)object);
                    this.rec.append(".image='");
                    this.rec.append((String)bT747Hashtable.get(object));
                    this.rec.append("';\n");
                }
                this.rec.append("var markers;markers=[");
                for (int i = 0; i < this.waypoints.size(); ++i) {
                    this.rec.append("\n new GMarker(new GLatLng(");
                    this.rec.append(JavaLibBridge.toString(this.waypoints.get(i).getLatDouble(), 5));
                    this.rec.append(',');
                    this.rec.append(JavaLibBridge.toString(this.waypoints.get(i).getLonDouble(), 5));
                    this.rec.append(')');
                    if (((String)this.iconList.elementAt(i)).length() != 0) {
                        this.rec.append(',');
                        this.rec.append(this.iconList.elementAt(i));
                    }
                    this.rec.append("),");
                }
                this.rec.setCharAt(this.rec.length() - 1, ']');
                this.rec.append(";\n infoHtmls=[\n");
                this.rec.append(this.infoHtmls.toString());
                this.rec.append("];\n");
                this.rec.append("for (var i=0; i<markers.length; ++i) {\n");
                this.rec.append("GEvent.addListener(markers[i],'click',makeOpenerCaller(i));\n");
                this.rec.append("}\n");
                this.rec.append("mgr.addMarkers(markers,0);mgr.refresh();\n");
                this.rec.append("\n");
                this.writeTxt(this.rec.toString());
                this.rec.setLength(0);
                this.waypoints.removeAll();
                this.infoHtmls.setLength(0);
                this.iconList.removeAllElements();
            }
            this.resetTrack();
        } else {
            this.endTrack(this.goodTrackColor);
            this.splitOrEndTrack();
        }
    }

    private final void splitOrEndTrack() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isWayType && this.trackOnClickFuncCalls.length() != 0) {
            stringBuffer.setLength(0);
            stringBuffer.append("clickStr+= \"" + this.trackDescription + "<input type=\\\"checkbox\\\"" + "onClick=\\\"" + this.trackOnClickFuncCalls + "\\\" checked/>\";\n");
            this.writeTxt(stringBuffer.toString());
            this.trackOnClickFuncCalls = "";
            this.trackDescription = "";
        }
    }

    public final void writeRecord(GPSRecord gPSRecord) {
        super.writeRecord(gPSRecord);
        if (!this.ptFilters[this.currentFilter].doFilter(gPSRecord)) {
            if (!(this.isWayType || this.isNewTrack || this.firstRecord || this.ignoreBadPoints)) {
                this.isNewTrack = true;
                if (this.track.size() != 0) {
                    Trackpoint trackpoint = this.track.get(this.track.size() - 1);
                    this.endTrack(this.goodTrackColor);
                    this.track.addTrackpoint(trackpoint);
                    this.trackStartInfo = "<b>#" + this.previousRec + "# </b>" + CommonOut.getDateTimeStr(this.previousTime);
                }
            }
            if (!this.isWayType && this.cachedRecordIsNeeded(gPSRecord)) {
                if (gPSRecord.getLatitude() < this.minlat) {
                    this.minlat = gPSRecord.getLatitude();
                }
                if (gPSRecord.getLatitude() > this.maxlat) {
                    this.maxlat = gPSRecord.getLatitude();
                }
                if (gPSRecord.getLongitude() < this.minlon) {
                    this.minlon = gPSRecord.getLongitude();
                }
                if (gPSRecord.getLongitude() > this.maxlon) {
                    this.maxlon = gPSRecord.getLongitude();
                }
            }
        } else {
            Object object;
            if (!this.isWayType) {
                this.rec.setLength(0);
                if (this.isNewTrack || this.needsToSplitTrack) {
                    this.isNewTrack = false;
                    if (gPSRecord.hasLatitude() && gPSRecord.hasLongitude()) {
                        if (!this.needsToSplitTrack) {
                            this.track.addTrackpoint(new Trackpoint(gPSRecord.getLatitude(), gPSRecord.getLongitude()));
                            if (gPSRecord.hasUtc()) {
                                this.previousTime = gPSRecord.getUtc();
                                this.previousRec = gPSRecord.recCount;
                            }
                            this.endTrack(this.badTrackColor);
                        } else {
                            this.endTrack(this.goodTrackColor);
                            this.splitOrEndTrack();
                        }
                    }
                    this.resetTrack();
                    this.trackStartInfo = "<b>#" + gPSRecord.recCount + "# </b>" + CommonOut.getDateTimeStr(gPSRecord, this.t);
                    if (this.trackDescription.length() == 0) {
                        this.trackDescription = CommonOut.getDateTimeStr(gPSRecord, this.t);
                    }
                }
            }
            if (gPSRecord.hasUtc()) {
                this.previousTime = gPSRecord.getUtc();
                this.previousRec = gPSRecord.getRecCount();
            }
            if (gPSRecord.hasLatitude() && gPSRecord.hasLongitude()) {
                object = new Trackpoint(gPSRecord.getLatitude(), gPSRecord.getLongitude());
                this.track.addTrackpoint((Trackpoint)object);
                if (((Trackpoint)object).getLatDouble() < this.minlat) {
                    this.minlat = ((Trackpoint)object).getLatDouble();
                }
                if (((Trackpoint)object).getLatDouble() > this.maxlat) {
                    this.maxlat = ((Trackpoint)object).getLatDouble();
                }
                if (((Trackpoint)object).getLonDouble() < this.minlon) {
                    this.minlon = ((Trackpoint)object).getLonDouble();
                }
                if (((Trackpoint)object).getLonDouble() > this.maxlon) {
                    this.maxlon = ((Trackpoint)object).getLonDouble();
                }
            }
            if (this.isWayType && gPSRecord.hasLatitude() && gPSRecord.hasLongitude()) {
                this.waypoints.addTrackpoint(new Trackpoint(gPSRecord.getLatitude(), gPSRecord.getLongitude()));
                this.infoHtmls.append("\"");
                object = CommonOut.getRCRstr(gPSRecord);
                String string = "";
                if (this.icons.get(object) == null) {
                    WayPointStyle wayPointStyle = ((String)object).length() > 0 && ((String)object).charAt(0) == 'X' ? CommonOut.getWayPointStyles().get(((String)object).substring(1)) : (((String)object).length() > 1 ? CommonOut.getWayPointStyles().get("M") : CommonOut.getWayPointStyles().get((String)object));
                    if (wayPointStyle != null) {
                        String string2 = wayPointStyle.getIconUrl();
                        this.icons.put(object, string2);
                        string = "ICON" + (String)object;
                    }
                } else {
                    string = "ICON" + (String)object;
                }
                this.iconList.addElement(string);
                CommonOut.getHtml(this.infoHtmls, gPSRecord, this.selectedFileFields, this.t, this.recordNbrInLogs, this.imperial);
                this.infoHtmls.append("\",\n");
            }
            this.writeTxt(this.rec.toString());
            this.rec.setLength(0);
        }
    }

    public final void finaliseFile() {
        if (this.isOpen()) {
            this.writeDataFooter();
            String string = "clickString();\nGEvent.addListener(map,'click',latlonFunc());\nfunction initial() {map.setCenter(new GLatLng(" + JavaLibBridge.toString((this.maxlat + this.minlat) / 2.0) + "," + JavaLibBridge.toString((this.maxlon + this.minlon) / 2.0) + "));" + "map.setZoom(map.getBoundsZoomLevel(new GLatLngBounds(new GLatLng(" + this.minlat + ',' + this.minlon + "),new GLatLng(" + this.maxlat + ',' + this.maxlon + "))));" + "\n" + "};\n" + " setFooter();\n" + " initial();\n" + "map.enableContinuousZoom();\n" + "map.enableDoubleClickZoom();\n" + "   }\n" + "   else {\n" + "     document.getElementById(\"quicklinks\").innerHTML = \"Your web browser is not compatible with this website.\"\n" + "   }\n" + "//]]>\n" + "</script>\n" + " </div>\n" + "</body>\n" + "</html>";
            this.writeTxt(string);
        }
        super.finaliseFile();
    }
}

