/*
 * Decompiled with CFR 0.152.
 */
package gps.log.in;

import bt747.sys.File;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Date;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747Time;
import gps.log.GPSRecord;
import gps.log.in.GPSFileConverterInterface;
import gps.log.in.GPSLogConvertInterface;
import gps.log.in.WindowedFile;

public final class SkytraqLogConvert
extends GPSLogConvertInterface {
    private int recordSize = 16;
    protected boolean passToFindFieldsActivatedInLog = false;
    protected int activeFileFields = 131133;
    private static final int[] totalLeapSecond = new int[]{0, 1, 2, 3, 4, 4, 5, 5, 5, 6, 6, 7, 8, 9, 10, 11, 11, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 16, 16, 16, 17, 17};
    private static final int[] leapMonth = new int[]{1, 7, 7, 7, 100, 7, 100, 100, 1, 100, 1, 1, 7, 7, 7, 100, 1, 7, 100, 1, 100, 100, 100, 100, 100, 100, 1, 100, 100, 1, 100, 100, 7, 100, 100};
    private int error;

    public void setLoggerType(int n) {
        super.setLoggerType(n);
        switch (this.getLoggerType()) {
            case 2: 
            case 3: {
                this.activeFileFields = 61;
                this.recordSize = 16;
                break;
            }
            default: {
                this.activeFileFields = 29;
                this.recordSize = 16;
            }
        }
    }

    public int parseFile(Object object, GPSFileConverterInterface gPSFileConverterInterface) {
        try {
            WindowedFile windowedFile = (WindowedFile)object;
            GPSRecord gPSRecord = GPSRecord.getLogFormatRecord(0);
            SkytraqPositionRecord skytraqPositionRecord = new SkytraqPositionRecord();
            if (!this.passToFindFieldsActivatedInLog) {
                gPSFileConverterInterface.writeLogFmtHeader(this.getLogFormatRecord(131133));
            }
            int n = 0;
            int n2 = 0;
            int n3 = windowedFile.getSize();
            while (!this.stop && n2 + 8 + 1 < n3) {
                byte[] byArray;
                int n4 = 4096;
                if (n4 + n2 > n3) {
                    n4 = n3 - n2;
                }
                int n5 = 0;
                try {
                    byArray = windowedFile.fillBuffer(n2);
                }
                catch (Exception exception) {
                    Generic.debug("Problem reading file", exception);
                    byArray = null;
                }
                if (byArray == null) {
                    Generic.debug("fillBuffer failed", null);
                    this.errorInfo = windowedFile.getPath() + "|" + windowedFile.getLastError();
                    return -3;
                }
                n2 += n4;
                block10: while (!this.stop && n5 < n4) {
                    int n6 = 7 & byArray[n5] >> 5;
                    switch (n6) {
                        case 7: {
                            n5 += 2;
                            continue block10;
                        }
                        case 2: 
                        case 3: {
                            if (n5 + 18 <= n4) {
                                skytraqPositionRecord = this.getFull(byArray, n5);
                                gPSRecord = SkytraqLogConvert.toGpsRecord(skytraqPositionRecord);
                                gPSRecord.rcr = 1;
                                gPSRecord.rcr = n6 == 2 ? 1 : 8;
                                gPSRecord.recCount = ++n;
                                gPSFileConverterInterface.addLogRecord(gPSRecord);
                                n5 += 18;
                                continue block10;
                            }
                            n2 += n5 - n4;
                            n4 = n5;
                            continue block10;
                        }
                        case 4: {
                            if (n5 + 8 <= n4) {
                                skytraqPositionRecord = this.getCompact(skytraqPositionRecord, byArray, n5);
                                gPSRecord = SkytraqLogConvert.toGpsRecord(skytraqPositionRecord);
                                gPSRecord.rcr = 1;
                                gPSRecord.recCount = ++n;
                                gPSFileConverterInterface.addLogRecord(gPSRecord);
                                n5 += 8;
                                continue block10;
                            }
                            n2 += n5 - n4;
                            n4 = n5;
                            continue block10;
                        }
                    }
                    n5 += 18;
                }
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return 0;
    }

    private static final int getLeapSecondsSince1980(int n, int n2) {
        int n3;
        int n4 = n - 1980;
        if (n4 > 0) {
            if (n4 < totalLeapSecond.length) {
                n3 = totalLeapSecond[n4];
                if (n2 >= leapMonth[n4]) {
                    ++n3;
                }
            } else {
                n3 = totalLeapSecond[totalLeapSecond.length - 1];
            }
        } else {
            n3 = 0;
        }
        return n3;
    }

    private static final GPSRecord toGpsRecord(SkytraqPositionRecord skytraqPositionRecord) {
        GPSRecord gPSRecord = new GPSRecord();
        SkytraqLogConvert.ecef2WGS84(gPSRecord, skytraqPositionRecord.x, skytraqPositionRecord.y, skytraqPositionRecord.z);
        BT747Date bT747Date = JavaLibBridge.getDateInstance(1, 1, 1970);
        bT747Date.advance(10825 + skytraqPositionRecord.wn * 7);
        BT747Time bT747Time = JavaLibBridge.getTimeInstance();
        int n = 935280000 + skytraqPositionRecord.wn * 7 * 24 * 3600 + skytraqPositionRecord.tow;
        bT747Time.setUTCTime(n);
        gPSRecord.setUtc(n -= SkytraqLogConvert.getLeapSecondsSince1980(bT747Time.getYear(), bT747Time.getMonth()));
        gPSRecord.setSpeed(skytraqPositionRecord.speed);
        return gPSRecord;
    }

    private static void ecef2WGS84(GPSRecord gPSRecord, double d, double d2, double d3) {
        double d4 = d * d + d2 * d2;
        double d5 = 2.182048199171718E15 * d3 * d3;
        double d6 = Math.sqrt(d4);
        double d7 = d4 + 0.9933056200098587 * d3 * d3 - 1.8230912546094608E9;
        double d8 = 4.481472345240445E-5 * d5 * d4 / (d7 * d7 * d7);
        double d9 = Generic.pow(1.0 + d8 + Math.sqrt(d8 * d8 + 2.0 * d8), 0.3333333333333333);
        double d10 = d5 / (3.0 * (d9 + 1.0 / d9 + 1.0) * (d9 + 1.0 / d9 + 1.0) * d7 * d7);
        double d11 = Math.sqrt(1.0 + 8.96294469048089E-5 * d10);
        double d12 = -(0.0066943799901413165 * d10 * d6) / (1.0 + d11) + Math.sqrt(2.03403157953845E13 * (1.0 + 1.0 / d11) - 0.9933056200098587 * d10 * d3 * d3 / (d11 * (1.0 + d11)) - d10 * d4 / 2.0);
        double d13 = (d6 - 0.0066943799901413165 * d12) * (d6 - 0.0066943799901413165 * d12);
        double d14 = Math.sqrt(d13 + d3 * d3);
        double d15 = Math.sqrt(d13 + 0.9933056200098587 * d3 * d3);
        double d16 = 4.0408299984661445E13 * d3 / (6378137.0 * d15);
        float f = (float)(d14 * (1.0 - 4.0408299984661445E13 / (6378137.0 * d15)));
        double d17 = JavaLibBridge.atan((d3 + 0.006739496742276434 * d16) / d6);
        double d18 = JavaLibBridge.atan2(d2, d);
        gPSRecord.setLongitude(d18 * 180.0 / Math.PI);
        gPSRecord.setLatitude(d17 * 180.0 / Math.PI);
        gPSRecord.setHeight(f);
    }

    private SkytraqPositionRecord getFull(byte[] byArray, int n) {
        SkytraqPositionRecord skytraqPositionRecord = new SkytraqPositionRecord();
        skytraqPositionRecord.speed = ((byArray[n] & 3) << 8) + (byArray[n + 1] & 0xFF);
        skytraqPositionRecord.tow = ((byArray[n + 4] & 0xFF) << 12) + ((byArray[n + 5] & 0xFF) << 4) + (byArray[n + 2] >> 4 & 0xF);
        skytraqPositionRecord.wn = ((byArray[n + 2] & 3) << 8) + (byArray[n + 3] & 0xFF);
        skytraqPositionRecord.x = ((byArray[n + 6] & 0xFF) << 8) + (byArray[n + 7] & 0xFF) + ((byArray[n + 8] & 0xFF) << 24) + ((byArray[n + 9] & 0xFF) << 16);
        skytraqPositionRecord.y = ((byArray[n + 10] & 0xFF) << 8) + (byArray[n + 11] & 0xFF) + ((byArray[n + 12] & 0xFF) << 24) + ((byArray[n + 13] & 0xFF) << 16);
        skytraqPositionRecord.z = ((byArray[n + 14] & 0xFF) << 8) + (byArray[n + 15] & 0xFF) + ((byArray[n + 16] & 0xFF) << 24) + ((byArray[n + 17] & 0xFF) << 16);
        return skytraqPositionRecord;
    }

    private SkytraqPositionRecord getCompact(SkytraqPositionRecord skytraqPositionRecord, byte[] byArray, int n) {
        SkytraqPositionRecord skytraqPositionRecord2 = skytraqPositionRecord;
        skytraqPositionRecord2.speed = ((byArray[n] & 3) << 8) + (byArray[n + 1] & 0xFF);
        int n2 = ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
        int n3 = ((byArray[n + 4] & 0xFF) << 2) + ((byArray[n + 5] & 0xC0) >> 6);
        int n4 = (byArray[n + 5] & 0x3F) + ((byArray[n + 6] & 0xF0) << 2);
        int n5 = ((byArray[n + 6] & 3) << 8) + (byArray[n + 7] & 0xFF);
        if ((n3 & 0x200) != 0) {
            n3 = 511 - n3;
        }
        if ((n4 & 0x200) != 0) {
            n4 = 511 - n4;
        }
        if ((n5 & 0x200) != 0) {
            n5 = 511 - n5;
        }
        skytraqPositionRecord2.tow += n2;
        skytraqPositionRecord2.x += n3;
        skytraqPositionRecord2.y += n4;
        skytraqPositionRecord2.z += n5;
        return skytraqPositionRecord2;
    }

    protected Object getFileObject(BT747Path bT747Path) {
        WindowedFile windowedFile = null;
        if (File.isAvailable()) {
            try {
                windowedFile = new WindowedFile(bT747Path, 1);
                windowedFile.setBufferSize(4096);
                this.errorInfo = bT747Path.toString() + "|" + windowedFile.getLastError();
            }
            catch (Exception exception) {
                Generic.debug("Error during initial open", exception);
            }
            if (windowedFile == null || !windowedFile.isOpen()) {
                this.errorInfo = bT747Path.toString();
                if (windowedFile != null) {
                    this.errorInfo = this.errorInfo + "|" + windowedFile.getLastError();
                }
                this.error = -1;
                windowedFile = null;
            }
        }
        return windowedFile;
    }

    protected void closeFileObject(Object object) {
        ((WindowedFile)object).close();
    }

    public int toGPSFile(BT747Path bT747Path, GPSFileConverterInterface gPSFileConverterInterface) {
        this.error = 0;
        try {
            Object object = this.getFileObject(bT747Path);
            if (object != null) {
                this.passToFindFieldsActivatedInLog = gPSFileConverterInterface.needPassToFindFieldsActivatedInLog();
                if (this.passToFindFieldsActivatedInLog) {
                    gPSFileConverterInterface.setActiveFileFields(this.getLogFormatRecord(this.activeFileFields));
                }
                this.passToFindFieldsActivatedInLog = false;
                if (this.error == 0) {
                    do {
                        this.error = this.parseFile(object, gPSFileConverterInterface);
                    } while (gPSFileConverterInterface.nextPass());
                }
                gPSFileConverterInterface.finaliseFile();
                this.closeFileObject(object);
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return this.error;
    }

    public GPSRecord getLogFormatRecord(int n) {
        int n2 = 45;
        switch (this.getLoggerType()) {
            case 2: 
            case 3: {
                n2 |= 0x10;
                break;
            }
        }
        return GPSRecord.getLogFormatRecord(n2);
    }

    public int getType() {
        return 10;
    }

    private static class SkytraqPositionRecord {
        public int tow;
        public int wn;
        public int x;
        public int y;
        public int z;
        public int speed;

        private SkytraqPositionRecord() {
        }
    }
}

