/*
 * Decompiled with CFR 0.152.
 */
package gps.log.in;

import bt747.sys.Generic;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747Vector;
import gps.log.GPSRecord;
import gps.log.in.CommonIn;
import gps.log.in.GPSFileConverterInterface;
import gps.log.in.GPSLogConvertInterface;

public class ArrayLogConvert
extends GPSLogConvertInterface {
    private BT747Vector trackVector = null;
    private GPSRecord[] trackArray = null;
    private boolean passToFindFieldsActivatedInLog = false;
    private int activeFileFields = 0;

    private final GPSRecord getRecord(int n) {
        try {
            if (this.trackVector != null) {
                return (GPSRecord)this.trackVector.elementAt(n);
            }
            if (this.trackArray != null && n < this.trackArray.length) {
                return this.trackArray[n];
            }
        }
        catch (Exception exception) {
            Generic.debug("ArrayLogConvert - get record", exception);
        }
        return null;
    }

    private final int size() {
        if (this.trackVector != null) {
            return this.trackVector.size();
        }
        if (this.trackArray != null) {
            return this.trackArray.length;
        }
        return 0;
    }

    protected void closeFileObject(Object object) {
    }

    protected Object getFileObject(BT747Path bT747Path) {
        return this;
    }

    public int getType() {
        return 12;
    }

    public int parseFile(Object object, GPSFileConverterInterface gPSFileConverterInterface) {
        int n = this.size();
        for (int i = 0; !this.stop && i < n; ++i) {
            GPSRecord gPSRecord = this.getRecord(i);
            if (gPSRecord == null) continue;
            if (!this.passToFindFieldsActivatedInLog) {
                gPSRecord = gPSRecord.cloneRecord();
                CommonIn.convertHeight(gPSRecord, this.factorConversionWGS84ToMSL);
                gPSFileConverterInterface.addLogRecord(gPSRecord.cloneRecord());
                continue;
            }
            this.activeFileFields |= gPSRecord.getLogFormat();
        }
        return 0;
    }

    public int toGPSFile(BT747Path bT747Path, GPSFileConverterInterface gPSFileConverterInterface) {
        int n = 0;
        this.passToFindFieldsActivatedInLog = gPSFileConverterInterface.needPassToFindFieldsActivatedInLog();
        if (this.passToFindFieldsActivatedInLog) {
            n = this.parseFile(null, gPSFileConverterInterface);
        }
        this.passToFindFieldsActivatedInLog = false;
        gPSFileConverterInterface.setActiveFileFields(GPSRecord.getLogFormatRecord(this.activeFileFields));
        if (n == 0) {
            while ((n = this.parseFile(null, gPSFileConverterInterface)) == 0 && gPSFileConverterInterface.nextPass()) {
            }
        }
        gPSFileConverterInterface.finaliseFile();
        if (gPSFileConverterInterface.getNbrFilesCreated() == 0) {
            n = -2;
        }
        try {
            this.closeFileObject(null);
        }
        catch (Exception exception) {
            Generic.debug("close", exception);
        }
        Generic.debug("Conversion done", null);
        return n;
    }
}

