/*
 * Decompiled with CFR 0.152.
 */
package gps.log;

import bt747.sys.JavaLibBridge;
import gps.log.out.CommonOut;

public class GPSRecord {
    public int utc = 0;
    public int tagutc = 0;
    public int valid = -1;
    public double latitude = -100000.0;
    public double longitude = -100000.0;
    public float height = -100000.0f;
    public float speed = -100000.0f;
    public float heading = -100000.0f;
    public int dsta = -1;
    public int dage = -1;
    public int pdop = -1;
    public int hdop = -1;
    public int vdop = -1;
    public int nsat = -1;
    public int[] sid = null;
    public boolean[] sidinuse = null;
    public int[] ele = null;
    public int[] azi = null;
    public int[] snr = null;
    public int rcr = -2147483641;
    public int milisecond = -1;
    public double distance = -1.0;
    public float geoid = -100000.0f;
    public int recCount = -1;
    public int logPeriod = 0;
    public int logSpeed = 0;
    public int logDistance = 0;
    public String voxStr;

    public final boolean isLogOn() {
        return this.voxStr.equals("logon");
    }

    public GPSRecord() {
        this.utc = 0;
    }

    public GPSRecord(GPSRecord gPSRecord) {
        this.utc = gPSRecord.utc;
        this.tagutc = gPSRecord.tagutc;
        this.valid = gPSRecord.valid;
        this.latitude = gPSRecord.latitude;
        this.longitude = gPSRecord.longitude;
        this.height = gPSRecord.height;
        this.speed = gPSRecord.speed;
        this.heading = gPSRecord.heading;
        this.dsta = gPSRecord.dsta;
        this.dage = gPSRecord.dage;
        this.pdop = gPSRecord.pdop;
        this.hdop = gPSRecord.hdop;
        this.vdop = gPSRecord.vdop;
        this.nsat = gPSRecord.nsat;
        if (gPSRecord.sid != null) {
            int n = gPSRecord.sid.length;
            this.sid = new int[n];
            this.sidinuse = new boolean[n];
            if (gPSRecord.ele != null) {
                this.ele = new int[n];
            }
            if (gPSRecord.azi != null) {
                this.azi = new int[n];
            }
            if (gPSRecord.snr != null) {
                this.snr = new int[n];
            }
            --n;
            while (n >= 0) {
                this.sid[n] = gPSRecord.sid[n];
                this.sidinuse[n] = gPSRecord.sidinuse[n];
                if (gPSRecord.ele != null) {
                    this.ele[n] = gPSRecord.ele[n];
                }
                if (gPSRecord.azi != null) {
                    this.azi[n] = gPSRecord.azi[n];
                }
                if (gPSRecord.snr != null) {
                    this.snr[n] = gPSRecord.snr[n];
                }
                --n;
            }
        }
        this.rcr = gPSRecord.rcr;
        this.milisecond = gPSRecord.milisecond;
        this.distance = gPSRecord.distance;
        this.geoid = gPSRecord.geoid;
        this.recCount = gPSRecord.recCount;
        this.logDistance = gPSRecord.logDistance;
        this.logPeriod = gPSRecord.logPeriod;
        this.logSpeed = gPSRecord.logSpeed;
        if (gPSRecord.voxStr != null) {
            this.voxStr = gPSRecord.voxStr;
        }
    }

    public final void cloneActiveFields(GPSRecord gPSRecord) {
        if (gPSRecord.hasUtc()) {
            this.utc = gPSRecord.utc;
        }
        if (gPSRecord.hasTagUtc()) {
            this.tagutc = gPSRecord.tagutc;
        }
        if (gPSRecord.hasValid()) {
            this.valid = gPSRecord.valid;
        }
        if (gPSRecord.hasLatitude()) {
            this.latitude = gPSRecord.latitude;
        }
        if (gPSRecord.hasLongitude()) {
            this.longitude = gPSRecord.longitude;
        }
        if (gPSRecord.hasHeight()) {
            this.height = gPSRecord.height;
        }
        if (gPSRecord.hasSpeed()) {
            this.speed = gPSRecord.speed;
        }
        if (gPSRecord.hasHeading()) {
            this.heading = gPSRecord.heading;
        }
        if (gPSRecord.hasDsta()) {
            this.dsta = gPSRecord.dsta;
        }
        if (gPSRecord.hasDage()) {
            this.dage = gPSRecord.dage;
        }
        if (gPSRecord.hasPdop()) {
            this.pdop = gPSRecord.pdop;
        }
        if (gPSRecord.hasHdop()) {
            this.hdop = gPSRecord.hdop;
        }
        if (gPSRecord.hasVdop()) {
            this.vdop = gPSRecord.vdop;
        }
        if (gPSRecord.hasNsat()) {
            this.nsat = gPSRecord.nsat;
        }
        if (gPSRecord.hasSid()) {
            int n = gPSRecord.sid.length;
            this.sid = new int[n];
            this.sidinuse = new boolean[n];
            if (gPSRecord.hasEle()) {
                this.ele = new int[n];
            }
            if (gPSRecord.hasAzi()) {
                this.azi = new int[n];
            }
            if (gPSRecord.hasSnr()) {
                this.snr = new int[n];
            }
            --n;
            while (n >= 0) {
                this.sid[n] = gPSRecord.sid[n];
                this.sidinuse[n] = gPSRecord.sidinuse[n];
                if (gPSRecord.hasEle()) {
                    this.ele[n] = gPSRecord.ele[n];
                }
                if (gPSRecord.hasAzi()) {
                    this.azi[n] = gPSRecord.azi[n];
                }
                if (gPSRecord.hasSnr()) {
                    this.snr[n] = gPSRecord.snr[n];
                }
                --n;
            }
        }
        if (gPSRecord.hasRcr()) {
            this.rcr = gPSRecord.rcr;
        }
        if (gPSRecord.hasMillisecond()) {
            this.milisecond = gPSRecord.milisecond;
        }
        if (gPSRecord.hasDistance()) {
            this.distance = gPSRecord.distance;
        }
        if (gPSRecord.hasGeoid()) {
            this.geoid = gPSRecord.geoid;
        }
        if (gPSRecord.hasRecCount()) {
            this.recCount = gPSRecord.recCount;
        }
        if (gPSRecord.hasLogDistance()) {
            this.logDistance = gPSRecord.logDistance;
        }
        if (gPSRecord.hasLogPeriod()) {
            this.logPeriod = gPSRecord.logPeriod;
        }
        if (gPSRecord.hasLogSpeed()) {
            this.logSpeed = gPSRecord.logSpeed;
        }
        if (gPSRecord.hasVoxStr()) {
            this.voxStr = gPSRecord.voxStr;
        }
    }

    public final GPSRecord cloneRecord() {
        return new GPSRecord(this);
    }

    public static final GPSRecord getCommonFormat(GPSRecord gPSRecord, GPSRecord gPSRecord2) {
        GPSRecord gPSRecord3 = new GPSRecord();
        if (gPSRecord.hasUtc() && gPSRecord2.hasUtc()) {
            gPSRecord3.utc = 1;
        }
        if (gPSRecord.hasValid() && gPSRecord2.hasValid()) {
            gPSRecord3.valid = 0;
        }
        if (gPSRecord.hasLatitude() && gPSRecord2.hasLatitude()) {
            gPSRecord3.latitude = 0.0;
        }
        if (gPSRecord.hasLongitude() && gPSRecord2.hasLongitude()) {
            gPSRecord3.longitude = 0.0;
        }
        if (gPSRecord.hasHeight() && gPSRecord2.hasHeight()) {
            gPSRecord3.height = 0.0f;
        }
        if (gPSRecord.hasSpeed() && gPSRecord2.hasSpeed()) {
            gPSRecord3.speed = 0.0f;
        }
        if (gPSRecord.hasHeading() && gPSRecord2.hasHeading()) {
            gPSRecord3.heading = 0.0f;
        }
        if (gPSRecord.hasDsta() && gPSRecord2.hasDsta()) {
            gPSRecord3.dsta = 0;
        }
        if (gPSRecord.hasDage() && gPSRecord2.hasDage()) {
            gPSRecord3.dage = 0;
        }
        if (gPSRecord.hasPdop() && gPSRecord2.hasPdop()) {
            gPSRecord3.pdop = 0;
        }
        if (gPSRecord.hasHdop() && gPSRecord2.hasHdop()) {
            gPSRecord3.hdop = 0;
        }
        if (gPSRecord.hasVdop() && gPSRecord2.hasVdop()) {
            gPSRecord3.vdop = 0;
        }
        if (gPSRecord.hasNsat() && gPSRecord2.hasNsat()) {
            gPSRecord3.nsat = 0;
        }
        if (gPSRecord.hasSid() && gPSRecord2.hasSid()) {
            gPSRecord3.sid = new int[0];
        }
        if (gPSRecord.hasSidInUse() && gPSRecord2.hasSidInUse()) {
            gPSRecord3.sidinuse = new boolean[0];
        }
        if (gPSRecord.hasEle() && gPSRecord2.hasEle()) {
            gPSRecord3.ele = new int[0];
        }
        if (gPSRecord.hasAzi() && gPSRecord2.hasAzi()) {
            gPSRecord3.azi = new int[0];
        }
        if (gPSRecord.hasSnr() && gPSRecord2.hasSnr()) {
            gPSRecord3.snr = new int[0];
        }
        if (gPSRecord.hasRcr() && gPSRecord2.hasRcr()) {
            gPSRecord3.rcr = 7;
        }
        if (gPSRecord.hasMillisecond() && gPSRecord2.hasMillisecond()) {
            gPSRecord3.milisecond = 0;
        }
        if (gPSRecord.hasDistance() && gPSRecord2.hasDistance()) {
            gPSRecord3.distance = 0.0;
        }
        return gPSRecord3;
    }

    public final int getLogFormat() {
        int n = 0;
        if (this.hasUtc()) {
            n |= 1;
        }
        if (this.hasValid()) {
            n |= 2;
        }
        if (this.hasLatitude()) {
            n |= 4;
        }
        if (this.hasLongitude()) {
            n |= 8;
        }
        if (this.hasHeight()) {
            n |= 0x10;
        }
        if (this.hasSpeed()) {
            n |= 0x20;
        }
        if (this.hasHeading()) {
            n |= 0x40;
        }
        if (this.hasDsta()) {
            n |= 0x80;
        }
        if (this.hasDage()) {
            n |= 0x100;
        }
        if (this.hasPdop()) {
            n |= 0x200;
        }
        if (this.hasHdop()) {
            n |= 0x400;
        }
        if (this.hasVdop()) {
            n |= 0x800;
        }
        if (this.hasNsat()) {
            n |= 0x1000;
        }
        if (this.hasSid()) {
            n |= 0x2000;
        }
        if (this.hasEle()) {
            n |= 0x4000;
        }
        if (this.hasAzi()) {
            n |= 0x8000;
        }
        if (this.hasSnr()) {
            n |= 0x10000;
        }
        if (this.hasRcr()) {
            n |= 0x20000;
        }
        if (this.hasMillisecond()) {
            n |= 0x40000;
        }
        if (this.hasDistance()) {
            n |= 0x80000;
        }
        return n;
    }

    public static final GPSRecord getLogFormatRecord(int n) {
        GPSRecord gPSRecord = new GPSRecord();
        if ((n & 1) != 0) {
            gPSRecord.utc = 1;
        }
        if ((n & 2) != 0) {
            gPSRecord.valid = 0;
        }
        if ((n & 4) != 0) {
            gPSRecord.latitude = 0.0;
        }
        if ((n & 8) != 0) {
            gPSRecord.longitude = 0.0;
        }
        if ((n & 0x10) != 0) {
            gPSRecord.height = 0.0f;
        }
        if ((n & 0x20) != 0) {
            gPSRecord.speed = 0.0f;
        }
        if ((n & 0x40) != 0) {
            gPSRecord.heading = 0.0f;
        }
        if ((n & 0x80) != 0) {
            gPSRecord.dsta = 0;
        }
        if ((n & 0x100) != 0) {
            gPSRecord.dage = 0;
        }
        if ((n & 0x200) != 0) {
            gPSRecord.pdop = 0;
        }
        if ((n & 0x400) != 0) {
            gPSRecord.hdop = 0;
        }
        if ((n & 0x800) != 0) {
            gPSRecord.vdop = 0;
        }
        if ((n & 0x1000) != 0) {
            gPSRecord.nsat = 0;
        }
        if ((n & 0x2000) != 0) {
            gPSRecord.sid = new int[0];
            gPSRecord.sidinuse = new boolean[0];
        }
        if ((n & 0x4000) != 0) {
            gPSRecord.ele = new int[0];
        }
        if ((n & 0x8000) != 0) {
            gPSRecord.azi = new int[0];
        }
        if ((n & 0x10000) != 0) {
            gPSRecord.snr = new int[0];
        }
        if ((n & 0x20000) != 0) {
            gPSRecord.rcr = 7;
        }
        if ((n & 0x40000) != 0) {
            gPSRecord.milisecond = 0;
        }
        if ((n & 0x80000) != 0) {
            gPSRecord.distance = 0.0;
        }
        return gPSRecord;
    }

    public final boolean hasRecCount() {
        return this.recCount != -1;
    }

    public final boolean hasUtc() {
        return this.utc != 0;
    }

    public final boolean hasTagUtc() {
        return this.tagutc != 0;
    }

    public final boolean hasValid() {
        return this.valid != -1;
    }

    public final boolean hasPosition() {
        return this.hasLatitude() && this.hasLongitude();
    }

    public final boolean hasLatitude() {
        return this.latitude != -100000.0;
    }

    public final boolean hasLongitude() {
        return this.longitude != -100000.0;
    }

    public final boolean hasHeight() {
        return this.height != -100000.0f;
    }

    public final boolean hasSpeed() {
        return this.speed != -100000.0f;
    }

    public final boolean hasHeading() {
        return this.heading != -100000.0f;
    }

    public final boolean hasDsta() {
        return this.dsta != -1;
    }

    public final boolean hasDage() {
        return this.dage != -1;
    }

    public final boolean hasPdop() {
        return this.pdop != -1;
    }

    public final boolean hasHdop() {
        return this.hdop != -1;
    }

    public final boolean hasVdop() {
        return this.vdop != -1;
    }

    public final boolean hasNsat() {
        return this.nsat != -1;
    }

    public final boolean hasSid() {
        return this.sid != null;
    }

    public final boolean hasSidInUse() {
        return this.sidinuse != null;
    }

    public final boolean hasEle() {
        return this.ele != null;
    }

    public final boolean hasAzi() {
        return this.azi != null;
    }

    public final boolean hasSnr() {
        return this.snr != null;
    }

    public final boolean hasRcr() {
        return this.rcr != -2147483641;
    }

    public final boolean hasMillisecond() {
        return this.milisecond != -1;
    }

    public final boolean hasDistance() {
        return this.distance != -1.0;
    }

    public final boolean hasVoxStr() {
        return this.voxStr != null;
    }

    public final boolean hasGeoid() {
        return this.geoid != -100000.0f;
    }

    public final boolean hasLogDistance() {
        return this.logDistance != 0;
    }

    public final boolean hasLogPeriod() {
        return this.logPeriod != 0;
    }

    public final boolean hasLogSpeed() {
        return this.logSpeed != 0;
    }

    public final boolean equalsFormat(GPSRecord gPSRecord) {
        return this.hasUtc() == gPSRecord.hasUtc() && this.hasValid() == gPSRecord.hasValid() && this.hasLatitude() == gPSRecord.hasLatitude() && this.hasLongitude() == gPSRecord.hasLongitude() && this.hasHeight() == gPSRecord.hasHeight() && this.hasSpeed() == gPSRecord.hasSpeed() && this.hasHeading() == gPSRecord.hasHeading() && this.hasDsta() == gPSRecord.hasDsta() && this.hasDage() == gPSRecord.hasDage() && this.hasPdop() == gPSRecord.hasPdop() && this.hasHdop() == gPSRecord.hasHdop() && this.hasVdop() == gPSRecord.hasVdop() && this.hasNsat() == gPSRecord.hasNsat() && this.hasSid() == gPSRecord.hasSid() && this.hasSidInUse() == gPSRecord.hasSidInUse() && this.hasEle() == gPSRecord.hasEle() && this.hasAzi() == gPSRecord.hasAzi() && this.hasSnr() == gPSRecord.hasSnr() && this.hasRcr() == gPSRecord.hasRcr() && this.hasMillisecond() == gPSRecord.hasMillisecond() && this.hasDistance() == gPSRecord.hasDistance() && this.hasVoxStr() == gPSRecord.hasVoxStr() && this.hasLogDistance() == gPSRecord.hasLogDistance() && this.hasLogSpeed() == gPSRecord.hasLogSpeed() && this.hasLogPeriod() == gPSRecord.hasLogSpeed();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.setLength(0);
        stringBuffer.append("CNT:" + this.recCount);
        if (this.hasUtc()) {
            stringBuffer.append("\nUTC:" + CommonOut.getDateTimeStr(this.utc) + "(" + this.utc + ")");
        }
        if (this.hasTagUtc()) {
            stringBuffer.append("\nTAGUTC:" + CommonOut.getDateTimeStr(this.tagutc) + "(" + this.tagutc + ")");
        }
        if (this.hasValid()) {
            stringBuffer.append("\nVALID:" + JavaLibBridge.unsigned2hex(this.valid, 8));
        }
        if (this.hasLatitude()) {
            stringBuffer.append("\nLAT:" + this.latitude);
        }
        if (this.hasLongitude()) {
            stringBuffer.append("\nLON:" + this.longitude);
        }
        if (this.hasRcr()) {
            stringBuffer.append("\nRCR:" + JavaLibBridge.unsigned2hex(this.rcr, 8));
        }
        if (this.hasHeight()) {
            stringBuffer.append("\nHEIGHT:" + this.height);
        }
        if (this.hasSpeed()) {
            stringBuffer.append("\nSPEED:" + this.speed);
        }
        if (this.hasHdop()) {
            stringBuffer.append("\nHDOP:" + (float)this.hdop / 100.0f);
        }
        if (this.hasVdop()) {
            stringBuffer.append("\nVDOP:" + (float)this.vdop / 100.0f);
        }
        if (this.hasPdop()) {
            stringBuffer.append("\nPDOP:" + (float)this.pdop / 100.0f);
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public final int getUtc() {
        return this.utc;
    }

    public final void setUtc(int n) {
        this.utc = n;
    }

    public final int getValid() {
        return this.valid;
    }

    public final void setValid(int n) {
        this.valid = n;
    }

    public final double getLatitude() {
        return this.latitude;
    }

    public final void setLatitude(double d) {
        this.latitude = d;
    }

    public final double getLongitude() {
        return this.longitude;
    }

    public final void setLongitude(double d) {
        this.longitude = d;
    }

    public final float getHeight() {
        return this.height;
    }

    public final void setHeight(float f) {
        this.height = f;
    }

    public final float getSpeed() {
        return this.speed;
    }

    public final void setSpeed(float f) {
        this.speed = f;
    }

    public final float getHeading() {
        return this.heading;
    }

    public final int getDsta() {
        return this.dsta;
    }

    public final int getDage() {
        return this.dage;
    }

    public final int getPdop() {
        return this.pdop;
    }

    public final void setPdop(int n) {
        this.pdop = n;
    }

    public final int getHdop() {
        return this.hdop;
    }

    public final void setHdop(int n) {
        this.hdop = n;
    }

    public final int getVdop() {
        return this.vdop;
    }

    public final void setVdop(int n) {
        this.vdop = n;
    }

    public final int getNsat() {
        return this.nsat;
    }

    public final void setNsat(int n) {
        this.nsat = n;
    }

    public final int getRcr() {
        return this.rcr;
    }

    public final void setRcr(int n) {
        this.rcr = n;
    }

    public final int getMilisecond() {
        return this.milisecond;
    }

    public final void setDistance(double d) {
        this.distance = d;
    }

    public final float getGeoid() {
        return this.geoid;
    }

    public final int getRecCount() {
        return this.recCount;
    }

    public final String getVoxStr() {
        return this.voxStr;
    }

    public final void setVoxStr(String string) {
        this.voxStr = string;
    }

    public final void tagFromRecord(GPSRecord gPSRecord) {
        this.utc = gPSRecord.utc;
        this.valid = gPSRecord.valid;
        this.latitude = gPSRecord.latitude;
        this.longitude = gPSRecord.longitude;
        this.height = gPSRecord.height;
        this.speed = gPSRecord.speed;
        this.heading = gPSRecord.heading;
        this.dsta = gPSRecord.dsta;
        this.dage = gPSRecord.dage;
        this.pdop = gPSRecord.pdop;
        this.hdop = gPSRecord.hdop;
        this.vdop = gPSRecord.vdop;
        this.nsat = gPSRecord.nsat;
        if (gPSRecord.sid != null) {
            int n = gPSRecord.sid.length;
            this.sid = new int[n];
            this.sidinuse = new boolean[n];
            if (gPSRecord.ele != null) {
                this.ele = new int[n];
            }
            if (gPSRecord.azi != null) {
                this.azi = new int[n];
            }
            if (gPSRecord.snr != null) {
                this.snr = new int[n];
            }
            --n;
            while (n >= 0) {
                this.sid[n] = gPSRecord.sid[n];
                this.sidinuse[n] = gPSRecord.sidinuse[n];
                if (gPSRecord.ele != null) {
                    this.ele[n] = gPSRecord.ele[n];
                }
                if (gPSRecord.azi != null) {
                    this.azi[n] = gPSRecord.azi[n];
                }
                if (gPSRecord.snr != null) {
                    this.snr[n] = gPSRecord.snr[n];
                }
                --n;
            }
        }
        this.milisecond = gPSRecord.milisecond;
        this.distance = gPSRecord.distance;
        this.geoid = gPSRecord.geoid;
        this.logDistance = gPSRecord.logDistance;
        this.logPeriod = gPSRecord.logPeriod;
        this.logSpeed = gPSRecord.logSpeed;
    }
}

