/*
 * Decompiled with CFR 0.152.
 */
package gps.log;

import bt747.sys.JavaLibBridge;
import gps.log.GPSRecord;

public class GPSFilter {
    private int startTime = 0;
    private int endTime = Integer.MAX_VALUE;
    private int validMask = -2;
    private int rcrMask = -1;

    public final void setStartTime(int n) {
        this.startTime = n;
    }

    public final void setEndTime(int n) {
        this.endTime = n;
    }

    public final void setRcrMask(int n) {
        this.rcrMask = n;
    }

    public final void setValidMask(int n) {
        this.validMask = n;
    }

    public boolean doFilter(GPSRecord gPSRecord) {
        boolean bl = (gPSRecord.utc >= 0 && gPSRecord.utc <= 86400 || gPSRecord.utc >= this.startTime && gPSRecord.utc <= this.endTime) && (!gPSRecord.hasValid() || (gPSRecord.valid & this.validMask) != 0) && (!gPSRecord.hasRcr() && (this.rcrMask & 1) != 0 || gPSRecord.hasRcr() && (gPSRecord.rcr & this.rcrMask) != 0);
        return bl;
    }

    public String toString() {
        return this.startTime + "<UTC<" + this.endTime + "\n" + "VALIDMASK=" + JavaLibBridge.unsigned2hex(this.validMask, 8) + "\n" + "RCRMASK=" + JavaLibBridge.unsigned2hex(this.rcrMask, 8) + "\n";
    }
}

