/*
 * Decompiled with CFR 0.152.
 */
package gps.convert;

import bt747.sys.Generic;
import gps.convert.Geoid;
import gps.convert.GeoidIF;

public class ExternalUtils {
    private static GeoidIF geoid = Geoid.getInstance();

    public static final double bilinear(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        if (d2 == d4 && d == d3) {
            return d7;
        }
        if (d2 == d4 && d != d3) {
            return (d10 * (d5 - d) + d7 * (d3 - d5)) / (d3 - d);
        }
        if (d == d3 && d2 != d4) {
            return (d10 * (d6 - d2) + d7 * (d4 - d6)) / (d4 - d2);
        }
        double d11 = (d4 - d2) * (d3 - d);
        return (d10 * (d6 - d2) * (d5 - d) + d8 * (d4 - d6) * (d5 - d) + d9 * (d6 - d2) * (d3 - d5) + d7 * (d4 - d6) * (d3 - d5)) / d11;
    }

    public static final double wgs84Separation(double d, double d2) {
        return geoid.wgs84Separation(d, d2);
    }

    public static final double earthDistance(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12 = ExternalUtils.calcR(d) * Math.cos(ExternalUtils.rad2deg(d2)) * Math.sin(ExternalUtils.rad2deg(90.0 - d));
        double d13 = (d12 * (d11 = ExternalUtils.calcR(d3) * Math.cos(ExternalUtils.rad2deg(d4)) * Math.sin(ExternalUtils.rad2deg(90.0 - d3))) + (d10 = ExternalUtils.calcR(d) * Math.sin(ExternalUtils.rad2deg(d2)) * Math.sin(ExternalUtils.rad2deg(90.0 - d))) * (d9 = ExternalUtils.calcR(d3) * Math.sin(ExternalUtils.rad2deg(d4)) * Math.sin(ExternalUtils.rad2deg(90.0 - d3))) + (d8 = ExternalUtils.calcR(d) * Math.cos(ExternalUtils.rad2deg(90.0 - d))) * (d7 = ExternalUtils.calcR(d3) * Math.cos(ExternalUtils.rad2deg(90.0 - d3)))) / (d6 = (d5 = ExternalUtils.calcR((d + d3) / 2.0)) * d5);
        if (d13 > 1.0) {
            d13 = 1.0;
        } else if (d13 < -1.0) {
            d13 = -1.0;
        }
        double d14 = Generic.acos(d13);
        return ExternalUtils.calcR((d + d3) / 2.0) * d14;
    }

    public static final double calcR(double d) {
        double d2 = d * Math.PI / 180.0;
        double d3 = Math.sin(d2);
        double d4 = 1.0 - 0.006574290724000001 * d3 * d3;
        double d5 = Generic.pow(d4, 1.5);
        double d6 = 6336205.273084499 / d5;
        return d6;
    }

    public static final double rad2deg(double d) {
        return d * Math.PI / 180.0;
    }

    public static final int getDayOfWeek(int n, int n2, int n3) {
        int n4 = (n3 - 1582) * 365;
        int n5 = (n3 - 1581) / 4;
        int n6 = (n3 - 1501) / 100;
        int n7 = (n3 - 1201) / 400;
        int n8 = (n2 - 1) * 31;
        int n9 = (n2 + 7) / 10;
        int n10 = (n2 * 4 + 23) * n9 / 10;
        int n11 = 1 / (n3 % 4 + 1) * n9;
        int n12 = 1 / (n3 % 100 + 1) * n9;
        int n13 = 1 / (n3 % 400 + 1) * n9;
        int n14 = n4 + n5 - n6 + n7 + n8 + n - n10 + n11 - n12 + n13 + 5;
        int n15 = n14 % 7;
        return n15 > 0 ? n15 - 1 : 6;
    }
}

