/*
 * Decompiled with CFR 0.152.
 */
package gps.connection;

import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Semaphore;
import bt747.sys.interfaces.BT747Vector;
import gps.connection.DecoderStateInterface;
import gps.connection.GPSPort;
import gps.connection.GPSrxtx;

public final class NMEADecoderState
implements DecoderStateInterface {
    private int current_state = 0;
    private final BT747Vector vCmd = JavaLibBridge.getVectorInstance();
    private final char[] cmd_buf = new char[4352];
    private int cmd_buf_p = 0;
    private int checksum = 0;
    private int read_checksum;
    private static boolean ignoreNMEA = false;
    private final BT747Semaphore rcvSema = JavaLibBridge.getSemaphoreInstance(1);

    private static final boolean isIgnoreNMEA() {
        return ignoreNMEA;
    }

    public static final void setIgnoreNMEA(boolean bl) {
        ignoreNMEA = bl;
    }

    public final Object getResponse(GPSrxtx gPSrxtx) {
        Object object = null;
        this.rcvSema.down();
        try {
            object = this.myGetResponse(gPSrxtx);
        }
        catch (Exception exception) {
            Generic.debug("getResponse exception", exception);
        }
        this.rcvSema.up();
        return object;
    }

    private final Object myGetResponse(GPSrxtx gPSrxtx) {
        GPSPort gPSPort = gPSrxtx.getGpsPort();
        int n = 0;
        boolean bl = NMEADecoderState.isIgnoreNMEA();
        boolean bl2 = gPSPort.isConnected();
        if (this.current_state == 8) {
            this.current_state = 1;
        }
        while (bl2 && !gPSrxtx.isReadBufferEmpty()) {
            char c = gPSrxtx.getReadBufferChar();
            switch (this.current_state) {
                case 6: {
                    if (c == '\n' || c == '\r') {
                        this.current_state = 8;
                        bl2 = false;
                        if (!bl) break;
                        bl2 = ((String)this.vCmd.elementAt(0)).startsWith("GP");
                        break;
                    }
                    this.current_state = 7;
                    break;
                }
                case 8: {
                    this.current_state = 1;
                }
                case 0: 
                case 1: {
                    this.vCmd.removeAllElements();
                    if (c == '$') {
                        this.current_state = 2;
                        this.cmd_buf_p = 0;
                        this.checksum = 0;
                        break;
                    }
                    if (c == '\n' || c == '\r' || this.current_state != 1) break;
                    n = 2;
                    this.current_state = 7;
                    break;
                }
                case 2: {
                    if (c == '\n' || c == '\r') {
                        this.current_state = 6;
                        break;
                    }
                    if (c == '*') {
                        this.current_state = 3;
                        this.vCmd.addElement(new String(this.cmd_buf, 0, this.cmd_buf_p));
                        break;
                    }
                    if (c == ',') {
                        this.checksum ^= c;
                        this.vCmd.addElement(new String(this.cmd_buf, 0, this.cmd_buf_p));
                        this.cmd_buf_p = 0;
                        break;
                    }
                    this.cmd_buf[this.cmd_buf_p++] = c;
                    this.checksum ^= c;
                    break;
                }
                case 3: {
                    if (c == '\n' || c == '\r') {
                        this.current_state = 7;
                        break;
                    }
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') {
                        this.read_checksum = c >= '0' && c <= '9' ? c - 48 << 4 : (c >= 'A' && c <= 'F' ? c - 65 + 10 << 4 : c - 97 + 10 << 4);
                        this.current_state = 4;
                        break;
                    }
                    n = 2;
                    this.current_state = 7;
                    break;
                }
                case 4: {
                    if (c == '\n' || c == '\r') {
                        n = 2;
                        this.current_state = 7;
                        break;
                    }
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') {
                        this.read_checksum = c >= '0' && c <= '9' ? (this.read_checksum += c - 48) : (c >= 'A' && c <= 'F' ? (this.read_checksum += c - 65 + 10) : (this.read_checksum += c - 97 + 10));
                        if (this.read_checksum != this.checksum) {
                            n = 1;
                            this.current_state = 7;
                        }
                        this.current_state = 6;
                        break;
                    }
                    n = 2;
                    this.current_state = 7;
                    break;
                }
                case 7: {
                    if (c != '\n' && c != '\r') break;
                    this.current_state = 1;
                    break;
                }
                default: {
                    this.current_state = 7;
                }
            }
            if (this.cmd_buf_p > 4351) {
                n = 3;
                this.current_state = 7;
            }
            if (this.current_state != 7) continue;
            this.current_state = 0;
            this.vCmd.removeAllElements();
        }
        if (n == 7) {
            this.vCmd.removeAllElements();
        }
        if (this.current_state == 8) {
            return JavaLibBridge.toStringArrayAndEmpty(this.vCmd);
        }
        return null;
    }

    public final void enterState(GPSrxtx gPSrxtx) {
        this.current_state = 0;
        this.vCmd.removeAllElements();
    }

    public void exitState(GPSrxtx gPSrxtx) {
    }
}

