/*
 * Decompiled with CFR 0.152.
 */
package bt747.waba_view.ui;

import waba.fx.Rect;
import waba.io.File;
import waba.ui.Control;
import waba.ui.Event;
import waba.ui.ListBox;
import waba.ui.Window;
import waba.util.Vector;

public final class FileSelect
extends Window {
    private String root = "";
    private String relPath = "/";
    private int cardSlot = -1;
    private ListBox cb;
    private int defaultIdx;
    private boolean dirOnly = false;

    public FileSelect() {
        this("Select path");
    }

    public FileSelect(String string) {
        this(string, 1);
    }

    public FileSelect(String string, byte by) {
        super(string, by);
    }

    public final void setDirOnly(boolean bl) {
        this.dirOnly = bl;
    }

    public final void setPath(String string) {
        this.relPath = this.dirOnly && !string.endsWith("/") ? string + "/" : string;
    }

    public void setRoot(String string) {
        this.root = string.endsWith("/") ? string : string + "/";
    }

    public String getPath() {
        if (this.relPath.endsWith("/")) {
            return this.root + this.relPath.substring(0, this.relPath.length() - 1);
        }
        return this.root + this.relPath;
    }

    public final String getRelPath() {
        if (this.relPath.endsWith("/")) {
            return this.relPath.substring(0, this.relPath.length() - 1);
        }
        return this.relPath;
    }

    public final void setCardSlot(int n) {
        this.cardSlot = n;
    }

    protected final void onPopup() {
        this.buildWindow();
    }

    private void buildWindow() {
        this.filePopList(this.root, this.relPath);
        this.add((Control)this.cb);
        Rect rect = this.getAbsoluteRect().modifiedBy(4, 26, -8, -38);
        this.cb.setRect(rect);
        this.cb.select(this.defaultIdx);
        this.cb.enableHorizScroll();
    }

    private int buildFileList(String string, String string2, Vector vector, int n, int n2) {
        int n3 = 0;
        if (string2 == null || n <= 0) {
            return n3;
        }
        File file = new File(string + string2, 0, this.cardSlot);
        String[] stringArray = file.listFiles();
        if (stringArray != null) {
            int n4;
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                if (stringArray[n4] == null || this.dirOnly && !stringArray[n4].endsWith("/")) continue;
                vector.addElement((Object)(string2 + stringArray[n4]));
                ++n3;
            }
            if (n3 < n2) {
                for (n4 = 0; n4 < stringArray.length; ++n4) {
                    if (!stringArray[n4].endsWith("/") || n <= 1 || n3 >= n2) continue;
                    n3 += this.buildFileList(string, string2 + stringArray[n4], vector, n - 1, n2 - n3);
                }
            }
        }
        return n3;
    }

    private void filePopList(String string, String string2) {
        Vector vector = new Vector(50);
        String string3 = "";
        int n = 1;
        if (!this.dirOnly) {
            vector.addElement((Object)"../");
        }
        if (string2.length() > 0) {
            int n2 = string2.lastIndexOf(47, string2.length() - 2);
            if (n2 >= 0) {
                string3 = string2.substring(0, n2 + 1);
                vector.addElement((Object)string3);
                ++n;
            } else if (!this.dirOnly) {
                vector.addElement((Object)"./");
            }
        }
        vector.addElement((Object)string2);
        File file = new File(string + string2, 0, this.cardSlot);
        if (!this.dirOnly && file.isDir()) {
            string3 = string2 + "/";
        }
        int n3 = this.buildFileList(string, this.dirOnly ? this.relPath : string3, vector, 2, 15);
        Object[] objectArray = (String[])vector.toObjectArray();
        if (n3 != 0 && objectArray[n].charAt(1) == '[') {
            objectArray[n] = ((String)objectArray[n]).substring(1);
        }
        if (this.cb != null) {
            this.remove((Control)this.cb);
        }
        this.cb = new ListBox(objectArray);
        this.defaultIdx = n - 1;
    }

    public final void onEvent(Event event) {
        if (event.target != null) {
            switch (event.type) {
                case 300: {
                    if (event.target != this.cb) break;
                    this.relPath = (String)this.cb.getSelectedItem();
                    this.unpop();
                }
            }
        }
    }
}

