/*
 * Decompiled with CFR 0.152.
 */
package bt747.waba_view;

import bt747.Txt;
import bt747.model.Model;
import bt747.model.ModelEvent;
import bt747.model.ModelListener;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Time;
import bt747.waba_view.AppController;
import gps.convert.ExternalUtils;
import gps.log.GPSRecord;
import waba.ui.Button;
import waba.ui.ComboBox;
import waba.ui.Container;
import waba.ui.Control;
import waba.ui.Event;
import waba.ui.Label;

public final class GPSconctrl
extends Container
implements ModelListener {
    private Button btnRestartGps;
    private Button btnStopGps;
    private Button btnBluetooth;
    private Button btnConnectPort;
    private final AppController c;
    private Label lbLat;
    private Label lbLon;
    private Label lbGeoid;
    private Label lbVersion;
    private Label lbFlashInfo;
    private Label lbFirmwareMainVersion;
    private Label lbFirmwareName;
    private Label lbModel;
    private ComboBox cbPorts;
    private ComboBox cbBaud;
    private static final String[] BaudRates = new String[]{"115200", "38400"};
    private final Model m;
    private String TimeStr = "";

    public GPSconctrl(AppController appController, Model model) {
        this.c = appController;
        this.m = model;
    }

    protected final void onStart() {
        int n;
        this.btnBluetooth = new Button(Txt.getString(39));
        this.btnConnectPort = new Button(Txt.getString(40));
        this.btnStopGps = new Button(Txt.getString(41));
        this.btnRestartGps = new Button(Txt.getString(42));
        Object[] objectArray = new String[33];
        for (n = 0; n <= 32; ++n) {
            objectArray[n] = "" + n;
        }
        this.cbPorts = new ComboBox(objectArray);
        n = this.m.getIntOpt(16);
        String string = "" + this.m.getIntOpt(17);
        this.cbBaud = new ComboBox((Object[])BaudRates);
        this.add((Control)this.btnBluetooth, 110000, 140000);
        this.add((Control)this.btnRestartGps, 190010, 180000);
        this.add((Control)this.cbBaud, 130000, 180000);
        this.add((Control)this.btnConnectPort, 110000, 190002);
        this.add((Control)this.cbPorts, 190003, 180000);
        this.add((Control)this.btnStopGps, 130000, 180000);
        if (this.m.getIntOpt(16) < 32) {
            this.cbPorts.select(n);
        }
        this.cbBaud.select(0);
        for (int i = 0; i < this.cbBaud.size(); ++i) {
            if (!string.equals((String)this.cbBaud.getItemAt(i))) continue;
            this.cbBaud.select(i);
            break;
        }
        if (!string.equals((String)this.cbBaud.getSelectedItem())) {
            this.c.setIntOpt(17, JavaLibBridge.toInt(string));
        }
        this.lbLat = new Label("");
        this.add((Control)this.lbLat, 110000, 190002);
        this.lbLon = new Label("");
        this.add((Control)this.lbLon, 110000, 190000);
        this.lbGeoid = new Label("");
        this.add((Control)this.lbGeoid, 110000, 190000);
        this.lbVersion = new Label("");
        this.add((Control)this.lbVersion, 110000, 149995);
        this.lbFirmwareMainVersion = new Label("");
        this.add((Control)this.lbFirmwareMainVersion, 110000, 170000);
        this.lbFirmwareName = new Label("");
        this.add((Control)this.lbFirmwareName, 110000, 170000);
        this.lbModel = new Label("");
        this.add((Control)this.lbModel, 110000, 170000);
        this.lbFlashInfo = new Label("");
        this.add((Control)this.lbFlashInfo, 110000, 170000);
        this.updateButtons();
        this.m.addListener(this);
    }

    private void GPS_setChannel(int n) {
        switch (n) {
            case 4099: {
                this.c.setBluetooth();
                this.btnBluetooth.press(true);
                break;
            }
            default: {
                this.c.setPort(n);
            }
        }
    }

    private void updateButtons() {
        this.lbVersion.setText("V2.1.7(29.10.2014)   " + Txt.getString(147) + this.m.getMtkLogVersion());
        this.lbFirmwareMainVersion.setText((this.m.getMainVersion().length() != 0 ? Txt.getString(43) : "") + this.m.getMainVersion());
        this.lbFirmwareName.setText((this.m.getFirmwareVersion().length() != 0 ? Txt.getString(44) : "") + this.m.getFirmwareVersion());
        String string = this.m.getModelStr();
        this.lbModel.setText((string.length() != 0 ? Txt.getString(45) : "") + string);
        this.lbFlashInfo.setText(this.m.getFlashManuProdID() != 0 ? Txt.getString(46) + JavaLibBridge.unsigned2hex(this.m.getFlashManuProdID(), 8) + " " + this.m.getFlashDesc() : "");
    }

    private void updateRMCData(GPSRecord gPSRecord) {
        if (gPSRecord.utc > 0) {
            BT747Time bT747Time = JavaLibBridge.getTimeInstance();
            bT747Time.setUTCTime(gPSRecord.utc);
            this.TimeStr = Txt.getString(47) + (bT747Time.getHour() < 10 ? "0" : "") + bT747Time.getHour() + ":" + (bT747Time.getMinute() < 10 ? "0" : "") + bT747Time.getMinute() + ":" + (bT747Time.getSecond() < 10 ? "0" : "") + bT747Time.getSecond();
        }
    }

    private void updateGPSData(GPSRecord gPSRecord) {
        this.lbLat.setText(Txt.getString(48) + JavaLibBridge.toString(gPSRecord.latitude, 5) + Txt.getString(52) + JavaLibBridge.toString(gPSRecord.height, 3) + Txt.getString(53));
        this.lbLon.setText(Txt.getString(49) + JavaLibBridge.toString(gPSRecord.longitude, 5) + this.TimeStr);
        this.lbGeoid.setText(Txt.getString(50) + JavaLibBridge.toString(gPSRecord.geoid, 3) + Txt.getString(53) + Txt.getString(51) + JavaLibBridge.toString(ExternalUtils.wgs84Separation(gPSRecord.latitude, gPSRecord.longitude), 3) + Txt.getString(53) + ")");
    }

    public final void onEvent(Event event) {
        switch (event.type) {
            case 300: {
                if (event.target == this.btnBluetooth) {
                    this.GPS_setChannel(4099);
                    break;
                }
                if (event.target == this.btnConnectPort) {
                    this.c.setBaudRate(JavaLibBridge.toInt((String)this.cbBaud.getSelectedItem()));
                    this.GPS_setChannel(JavaLibBridge.toInt((String)this.cbPorts.getSelectedItem()));
                    break;
                }
                if (event.target == this.cbBaud || event.target == this.cbPorts) break;
                if (event.target == this) {
                    this.c.reqDeviceInfo();
                    event.consumed = true;
                    break;
                }
                if (event.target == this.btnStopGps) {
                    this.c.closeGPS();
                    break;
                }
                if (event.target != this.btnRestartGps) break;
                this.c.connectGPS();
                break;
            }
        }
    }

    public final void modelEvent(ModelEvent modelEvent) {
        switch (modelEvent.getType()) {
            case 4: {
                this.updateGPSData((GPSRecord)modelEvent.getArg());
                break;
            }
            case 3: {
                this.updateRMCData((GPSRecord)modelEvent.getArg());
                this.updateGPSData((GPSRecord)modelEvent.getArg());
                break;
            }
            case 23: 
            case 26: 
            case 35: 
            case 36: {
                if (!this.isVisible()) break;
                this.updateButtons();
            }
        }
    }
}

