/*
 * Decompiled with CFR 0.152.
 */
package bt747.waba_view;

import bt747.waba_view.ui.BT747MessageBox;
import gps.connection.GPSPort;
import waba.io.Socket;

public final class GPSWabaSocketPort
extends GPSPort {
    private Socket sp = null;
    private String MacAddr = "btspp://000B0D87E7CA";
    private boolean portIsOK = false;

    public final boolean isConnected() {
        return this.sp != null && this.sp.isOpen();
    }

    public final void closePort() {
        if (this.sp != null && this.sp.isOpen()) {
            this.portIsOK = false;
            this.sp.close();
        }
    }

    public int openPort() {
        int n = -1;
        this.closePort();
        try {
            this.sp = new Socket(this.MacAddr, 1);
            n = this.sp.lastError;
            new BT747MessageBox("waba.io.Socket open", "Result:" + n).popupBlockingModal();
            this.portIsOK = this.sp.isOpen();
            if (this.portIsOK) {
                this.sp.setReadTimeout(20);
            } else {
                this.sp = null;
            }
        }
        catch (Exception exception) {
            new BT747MessageBox("waba.io.Socket open", "Unexpected exception catched").popupBlockingModal();
            this.sp = null;
        }
        return n;
    }

    public final void setBlueTooth() {
        this.spPortNbr = 4099;
    }

    public final void setUSB() {
        this.spPortNbr = 4098;
    }

    public final void write(byte[] byArray) {
        this.sp.writeBytes(byArray, 0, byArray.length);
        if (this.debugFile != null) {
            try {
                this.debugFile.writeBytes(byArray, 0, byArray.length);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void write(String string) {
        this.write(string.getBytes());
    }

    public final int readCheck() {
        if (this.sp != null) {
            return 255;
        }
        return -1;
    }

    public final int readBytes(byte[] byArray, int n, int n2) {
        return this.sp.readBytes(byArray, n, n2);
    }
}

