/*
 * Decompiled with CFR 0.152.
 */
package bt747.waba_view;

import bt747.Txt;
import bt747.model.Model;
import bt747.model.ModelEvent;
import bt747.model.ModelListener;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Time;
import bt747.waba_view.AppController;
import bt747.waba_view.MyCheck;
import gps.BT747Constants;
import net.sf.bt747.waba.system.WabaDate;
import waba.fx.Color;
import waba.sys.Settings;
import waba.ui.Button;
import waba.ui.Calendar;
import waba.ui.ComboBox;
import waba.ui.Container;
import waba.ui.Control;
import waba.ui.Edit;
import waba.ui.Event;
import waba.ui.Label;
import waba.util.Date;

public final class GPSLogGet
extends Container
implements ModelListener {
    private final Model m;
    private final AppController c;
    private MyCheck chkLogOnOff;
    private MyCheck chkLogOverwriteStop;
    private Button btStartDate;
    private Button btEndDate;
    private Button btGetLog;
    private ComboBox cbHeightConversion;
    private Button btCancelGetLog;
    private Button btToCSV;
    private Button btToKML;
    private Button btToGPX;
    private Button btToTRK;
    private Button btToPLT;
    private Button btToNMEA;
    private Button btToGMAP;
    private Edit edTrkSep;
    private ComboBox cbTimeOffsetHours;
    private Calendar cal;
    private Button btCal;
    private static final String[] offsetStr = BT747Constants.getUtcStrings("");
    private ComboBox cbColors;
    private static final String[] colors = new String[]{"FF0000", "0000FF", "800000", "000080", "00FF00", "008000"};
    private ComboBox cbDownload;
    private static final String[] downloadStr = new String[]{Txt.getString(178), Txt.getString(176), Txt.getString(177)};
    private ComboBox cbFileSplitType;
    private static final String[] fileStr = new String[]{Txt.getString(99), Txt.getString(100), Txt.getString(101)};
    private static final String[] heightCorrectStr = new String[]{Txt.getString(189), Txt.getString(191), Txt.getString(190), Txt.getString(192)};
    private Color savedBackColor;
    private Label lbUsedMem;
    private Label lbUsedRecords;

    public GPSLogGet(Model model, AppController appController) {
        this.m = model;
        this.c = appController;
    }

    private static final String convertUTCtoDateString(int n) {
        BT747Time bT747Time = JavaLibBridge.getTimeInstance();
        bT747Time.setUTCTime(n);
        int n2 = bT747Time.getDay();
        int n3 = bT747Time.getMonth();
        int n4 = bT747Time.getYear();
        String string = (n2 < 10 ? "0" : "") + n2 + "/" + (n3 < 10 ? "0" : "") + bT747Time.getMonth() + "/" + n4;
        bT747Time = null;
        return string;
    }

    protected final void onStart() {
        super.onStart();
        this.chkLogOnOff = new MyCheck(Txt.getString(102));
        this.add((Control)this.chkLogOnOff, 110000, 140000);
        this.cbDownload = new ComboBox((Object[])downloadStr);
        this.add((Control)this.cbDownload, 130000, 180000);
        this.cbDownload.select(this.m.getDownloadMethod());
        this.chkLogOverwriteStop = new MyCheck(Txt.getString(104));
        this.add((Control)this.chkLogOverwriteStop, 110000, 190000);
        this.add((Control)new Label(Txt.getString(105)), 110000, 190000);
        this.btStartDate = new Button(GPSLogGet.convertUTCtoDateString(this.m.getFilterStartTime()));
        this.add((Control)this.btStartDate, 190000, 180000);
        this.btEndDate = new Button(GPSLogGet.convertUTCtoDateString(this.m.getFilterEndTime()));
        this.add((Control)this.btEndDate, 130000, 180000);
        this.btGetLog = new Button(Txt.getString(106));
        this.add((Control)this.btGetLog, 110000, 190002);
        this.btCancelGetLog = new Button(Txt.getString(107));
        this.add((Control)this.btCancelGetLog, 190005, 180000);
        this.cbColors = new ComboBox((Object[])colors);
        this.add((Control)this.cbColors, 130000, 180000);
        this.add((Control)new Label(Txt.getString(108)), 170000, 180000);
        this.add((Control)new Label(Txt.getString(109)), 110000, 190000);
        this.edTrkSep = new Edit("00000");
        this.add((Control)this.edTrkSep, 190000, 180000);
        this.edTrkSep.setValidChars("0123456789");
        this.add((Control)new Label(Txt.getString(110)), 190000, 180000);
        this.edTrkSep.setText("" + this.m.getIntOpt(47));
        this.edTrkSep.alignment = 130000;
        int n = BT747Constants.getUtcIdx(this.m.getIntOpt(68));
        this.cbTimeOffsetHours = new ComboBox((Object[])offsetStr);
        this.add((Control)this.cbTimeOffsetHours, 130000, 180000);
        this.cbTimeOffsetHours.select(n);
        this.add((Control)new Label(Txt.getString(111)), 170000, 180000);
        this.cbFileSplitType = new ComboBox((Object[])fileStr);
        this.add((Control)this.cbFileSplitType, 110000, 190002);
        this.cbFileSplitType.select(this.m.getIntOpt(73));
        this.cbHeightConversion = new ComboBox((Object[])heightCorrectStr);
        this.add((Control)this.cbHeightConversion, 130000, 180000);
        this.setHeightConversionModeFromSettings();
        this.btToCSV = new Button(Txt.getString(113));
        this.add((Control)this.btToCSV, 110000, 190005);
        this.btToGPX = new Button(Txt.getString(114));
        this.add((Control)this.btToGPX, 190005, 180000);
        this.btToKML = new Button(Txt.getString(115));
        this.add((Control)this.btToKML, 130000, 180000);
        this.btToTRK = new Button(Txt.getString(116));
        this.add((Control)this.btToTRK, 169995, 180000);
        this.btToPLT = new Button(Txt.getString(117));
        this.add((Control)this.btToPLT, 110000, 190002);
        this.btToGMAP = new Button(Txt.getString(118));
        this.add((Control)this.btToGMAP, 120000, 180000);
        this.btToNMEA = new Button(Txt.getString(119));
        this.add((Control)this.btToNMEA, 130000, 180000);
        this.savedBackColor = this.btToCSV.getBackColor();
        this.lbUsedMem = new Label("");
        this.add((Control)this.lbUsedMem, 110000, 190003);
        this.lbUsedRecords = new Label("");
        this.add((Control)this.lbUsedRecords, 110000, 190003);
        String string = this.m.getStringOpt(44);
        this.cbColors.select(0);
        for (int i = 0; i < this.cbColors.size() - 1; ++i) {
            if (!string.equals((String)this.cbColors.getItemAt(i))) continue;
            this.cbColors.select(i);
            break;
        }
    }

    private final void updateHeightConversionModeFromControl() {
        int n;
        switch (this.cbHeightConversion.getSelectedIndex()) {
            default: {
                n = 2;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 0;
            }
        }
        this.c.setIntOpt(84, n);
    }

    private final void setHeightConversionModeFromSettings() {
        int n;
        switch (this.m.getIntOpt(84)) {
            default: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 0: {
                n = 3;
            }
        }
        this.cbHeightConversion.select(n);
    }

    private final void reqLogInfo() {
        this.c.setMtkDataNeeded(7);
        this.c.setMtkDataNeeded(8);
        this.c.setMtkDataNeeded(2);
        this.c.setMtkDataNeeded(1);
        this.c.setMtkDataNeeded(18);
    }

    private final void updateButtons() {
        this.chkLogOnOff.setChecked(this.m.isLoggingActive());
        this.chkLogOverwriteStop.setChecked(this.m.isLogFullOverwrite());
        this.lbUsedMem.setText(Txt.getString(120) + this.m.logMemUsed() + "(" + this.m.logMemUsedPercent() + "%)");
        this.lbUsedRecords.setText(Txt.getString(121) + this.m.logNbrLogPts() + " (" + this.m.getEstimatedNbrRecordsFree(this.m.getLogFormat()) + " " + Txt.getString(173) + ")");
    }

    public final void onEvent(Event event) {
        super.onEvent(event);
        switch (event.type) {
            case 300: {
                event.consumed = true;
                if (event.target == this.btGetLog) {
                    this.c.startDownload();
                    break;
                }
                if (event.target == this.btCancelGetLog) {
                    this.c.cancelGetLog();
                    break;
                }
                if (event.target == this.cbDownload) {
                    this.c.setDownloadMethod(this.cbDownload.getSelectedIndex());
                    break;
                }
                if (event.target == this.chkLogOnOff) {
                    this.c.setLoggingActive(this.chkLogOnOff.getChecked());
                    break;
                }
                if (event.target == this.cbColors) {
                    this.c.setStringOpt(44, (String)this.cbColors.getSelectedItem());
                    break;
                }
                if (event.target == this.cbTimeOffsetHours) {
                    int n = this.cbTimeOffsetHours.getSelectedIndex();
                    this.c.setIntOpt(68, BT747Constants.timeZones[n]);
                    break;
                }
                if (event.target == this.chkLogOverwriteStop) {
                    this.c.setLogOverwrite(this.chkLogOverwriteStop.getChecked());
                    break;
                }
                if (event.target == this.cbFileSplitType) {
                    this.c.setIntOpt(73, this.cbFileSplitType.getSelectedIndex());
                    break;
                }
                if (event.target == this.cbHeightConversion) {
                    this.updateHeightConversionModeFromControl();
                    break;
                }
                if (event.target == this.btEndDate) {
                    if (this.cal == null) {
                        this.cal = new Calendar();
                    }
                    this.btCal = this.btEndDate;
                    this.cal.popupModal();
                    break;
                }
                if (event.target == this.btStartDate) {
                    if (this.cal == null) {
                        this.cal = new Calendar();
                    }
                    this.btCal = this.btStartDate;
                    this.cal.popupModal();
                    break;
                }
                if (event.target == this.btToCSV || event.target == this.btToKML || event.target == this.btToPLT || event.target == this.btToGPX || event.target == this.btToTRK || event.target == this.btToGMAP || event.target == this.btToNMEA) {
                    int n = 0;
                    if (event.target == this.btToCSV) {
                        n = 1;
                    } else if (event.target == this.btToTRK) {
                        n = 7;
                    } else if (event.target == this.btToKML) {
                        n = 4;
                    } else if (event.target == this.btToPLT) {
                        n = 6;
                    } else if (event.target == this.btToGPX) {
                        n = 3;
                    } else if (event.target == this.btToNMEA) {
                        n = 5;
                    } else if (event.target == this.btToGMAP) {
                        n = 2;
                    }
                    this.c.convertLog(n);
                    break;
                }
                if (event.target == this) {
                    this.reqLogInfo();
                    break;
                }
                event.consumed = false;
                break;
            }
            case 302: {
                if (event.target != this.edTrkSep) break;
                this.c.setIntOpt(47, JavaLibBridge.toInt(this.edTrkSep.getText()));
                this.edTrkSep.setText("" + this.m.getIntOpt(47));
                break;
            }
            case 499: {
                Date date;
                if (event.target != this.cal || (date = this.cal.getSelectedDate()) == null) break;
                this.btCal.setText(date.toString());
                this.c.setFilterStartTime(new WabaDate(this.btStartDate.getText(), Settings.dateFormat).dateToUTCepoch1970());
                this.c.setFilterEndTime(new WabaDate(this.btEndDate.getText(), Settings.dateFormat).dateToUTCepoch1970() + 86400 - 1);
                break;
            }
        }
    }

    public final void modelEvent(ModelEvent modelEvent) {
        switch (modelEvent.getType()) {
            case 22: 
            case 24: 
            case 27: 
            case 28: {
                this.updateButtons();
                break;
            }
            case 270: {
                this.cbDownload.select(this.m.getDownloadMethod());
                break;
            }
            case 256: 
            case 257: {
                Button button = null;
                switch (this.m.getLastConversionOngoing()) {
                    case 1: {
                        button = this.btToCSV;
                        break;
                    }
                    case 7: {
                        button = this.btToTRK;
                        break;
                    }
                    case 4: {
                        button = this.btToKML;
                        break;
                    }
                    case 6: {
                        button = this.btToPLT;
                        break;
                    }
                    case 3: {
                        button = this.btToGPX;
                        break;
                    }
                    case 5: {
                        button = this.btToNMEA;
                        break;
                    }
                    case 2: {
                        button = this.btToGMAP;
                        break;
                    }
                }
                if (button == null) break;
                if (this.m.isConversionOngoing()) {
                    button.setBackColor(Color.GREEN);
                } else {
                    button.setBackColor(this.savedBackColor);
                }
                button.repaintNow();
                break;
            }
        }
    }
}

