/*
 * Decompiled with CFR 0.152.
 */
package bt747.waba_view;

import bt747.Txt;
import bt747.model.Model;
import bt747.model.ModelEvent;
import bt747.model.ModelListener;
import bt747.waba_view.AppController;
import bt747.waba_view.MyCheck;
import waba.ui.Container;
import waba.ui.Control;
import waba.ui.Event;
import waba.ui.PushButtonGroup;

public final class GPSLogFilter
extends Container
implements ModelListener {
    private int currentLogFilter = 0;
    private final Model m;
    private final AppController c;
    private static final String[] C_PB_TYPE_NAMES = new String[2];
    private final MyCheck[] chkRCR = new MyCheck[16];
    private final MyCheck[] chkValid = new MyCheck[9];
    private PushButtonGroup pbPtType;

    public GPSLogFilter(AppController appController, Model model) {
        this.m = model;
        this.c = appController;
    }

    protected final void onStart() {
        int n;
        this.pbPtType = new PushButtonGroup(C_PB_TYPE_NAMES, true, 0, 1, 2, 1, true, 0);
        this.add((Control)this.pbPtType, 120000, 140002);
        for (n = 0; n < 9; ++n) {
            this.chkValid[n] = new MyCheck(Txt.getValidString(n));
            this.add((Control)this.chkValid[n], n == 0 ? 110000 : (n == 4 ? this.getClientRect().width / 2 : 180000), n == 0 || n == 4 ? 190002 : 189999, (Control)(n == 0 || n == 4 ? this.pbPtType : this.chkValid[n - 1]));
            this.chkValid[n].setEnabled(true);
        }
        n = 110000;
        int n2 = 180000;
        MyCheck myCheck = null;
        for (int i = 0; i < 16; ++i) {
            this.chkRCR[i] = new MyCheck(Txt.getRcrString(i));
            if (i == 0) {
                n = 110000;
            } else if (i % 4 == 0) {
                n = this.getClientRect().width * (i / 4) / 4 + 8;
            }
            if (i % 4 == 0) {
                myCheck = this.chkValid[8];
                n2 = 190006;
            } else {
                n2 = 189999;
            }
            this.add((Control)this.chkRCR[i], n, n2, (Control)myCheck);
            myCheck = this.chkRCR[i];
            this.chkRCR[i].setEnabled(true);
        }
    }

    private int getValid() {
        int n = 1;
        int n2 = 0;
        for (int i = 0; i < 9; ++i) {
            if (this.chkValid[i].getChecked()) {
                n2 |= n;
            }
            n <<= 1;
        }
        return n2;
    }

    private void setValid(int n) {
        int n2 = 1;
        for (int i = 0; i < 9; ++i) {
            this.chkValid[i].setChecked((n & n2) != 0);
            n2 <<= 1;
        }
    }

    private int getRCR() {
        int n = 1;
        int n2 = 0;
        for (int i = 0; i < 16; ++i) {
            if (this.chkRCR[i].getChecked()) {
                n2 |= n;
            }
            n <<= 1;
        }
        return n2;
    }

    private void setRCR(int n) {
        int n2 = 1;
        for (int i = 0; i < 16; ++i) {
            this.chkRCR[i].setChecked((n & n2) != 0);
            n2 <<= 1;
        }
    }

    private void updateFromFilter() {
        this.setValid(this.m.getValidMask(this.currentLogFilter));
        this.setRCR(this.m.getRcrMask(this.currentLogFilter));
    }

    public final void onEvent(Event event) {
        block0 : switch (event.type) {
            case 300: {
                int n;
                if (event.target == this) {
                    this.updateFromFilter();
                    event.consumed = true;
                    break;
                }
                if (event.target == null) break;
                if (event.target == this.pbPtType) {
                    this.currentLogFilter = this.pbPtType.getSelected();
                    this.updateFromFilter();
                    break;
                }
                boolean bl = false;
                for (n = 0; n < 9; ++n) {
                    if (event.target != this.chkValid[n]) continue;
                    bl = true;
                }
                if (bl) {
                    switch (this.currentLogFilter) {
                        case 0: {
                            this.c.setIntOpt(88, this.getValid());
                            break;
                        }
                        case 1: {
                            this.c.setIntOpt(86, this.getValid());
                            break;
                        }
                    }
                }
                bl = false;
                for (n = 0; n < 16; ++n) {
                    if (event.target != this.chkRCR[n]) continue;
                    bl = true;
                }
                if (!bl) break;
                switch (this.currentLogFilter) {
                    case 0: {
                        this.c.setIntOpt(87, this.getRCR());
                        break block0;
                    }
                    case 1: {
                        this.c.setIntOpt(89, this.getRCR());
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public final void modelEvent(ModelEvent modelEvent) {
    }

    static {
        GPSLogFilter.C_PB_TYPE_NAMES[0] = Txt.getString(77);
        GPSLogFilter.C_PB_TYPE_NAMES[1] = Txt.getString(78);
    }
}

