/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.CommDriver;
import gnu.io.CommPort;
import gnu.io.CommPortEnumerator;
import gnu.io.CommPortOwnershipListener;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.FileDescriptor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class CommPortIdentifier {
    public static final int PORT_SERIAL = 1;
    public static final int PORT_PARALLEL = 2;
    public static final int PORT_I2C = 3;
    public static final int PORT_RS485 = 4;
    public static final int PORT_RAW = 5;
    private String PortName;
    private boolean Available = true;
    private String Owner;
    private CommPort commport;
    private CommDriver RXTXDriver;
    static CommPortIdentifier CommPortIndex;
    CommPortIdentifier next;
    private int PortType;
    private static final boolean debug = true;
    static Object Sync;
    Vector ownershipListener;
    private boolean HideOwnerEvents;

    CommPortIdentifier(String string, CommPort commPort, int n, CommDriver commDriver) {
        this.PortName = string;
        this.commport = commPort;
        this.PortType = n;
        this.next = null;
        this.RXTXDriver = commDriver;
    }

    public static void addPortName(String string, int n, CommDriver commDriver) {
        System.out.println("CommPortIdentifier:addPortName(" + string + ")");
        CommPortIdentifier.AddIdentifierToList(new CommPortIdentifier(string, null, n, commDriver));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void AddIdentifierToList(CommPortIdentifier commPortIdentifier) {
        System.out.println("CommPortIdentifier:AddIdentifierToList()");
        Object object = Sync;
        synchronized (object) {
            if (CommPortIndex == null) {
                CommPortIndex = commPortIdentifier;
                System.out.println("CommPortIdentifier:AddIdentifierToList() null");
            } else {
                CommPortIdentifier commPortIdentifier2 = CommPortIndex;
                while (commPortIdentifier2.next != null) {
                    commPortIdentifier2 = commPortIdentifier2.next;
                    System.out.println("CommPortIdentifier:AddIdentifierToList() index.next");
                }
                commPortIdentifier2.next = commPortIdentifier;
            }
        }
    }

    public void addPortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        System.out.println("CommPortIdentifier:addPortOwnershipListener()");
        if (this.ownershipListener == null) {
            this.ownershipListener = new Vector();
        }
        if (!this.ownershipListener.contains(commPortOwnershipListener)) {
            this.ownershipListener.addElement(commPortOwnershipListener);
        }
    }

    public String getCurrentOwner() {
        System.out.println("CommPortIdentifier:getCurrentOwner()");
        return this.Owner;
    }

    public String getName() {
        System.out.println("CommPortIdentifier:getName()");
        return this.PortName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommPortIdentifier getPortIdentifier(String string) throws NoSuchPortException {
        CommPortIdentifier commPortIdentifier;
        System.out.println("CommPortIdentifier:getPortIdentifier(" + string + ")");
        Object object = Sync;
        synchronized (object) {
            commPortIdentifier = CommPortIndex;
            while (commPortIdentifier != null && !commPortIdentifier.PortName.equals(string)) {
                commPortIdentifier = commPortIdentifier.next;
            }
            if (commPortIdentifier == null) {
                CommPortIdentifier.getPortIdentifiers();
                commPortIdentifier = CommPortIndex;
                while (commPortIdentifier != null && !commPortIdentifier.PortName.equals(string)) {
                    commPortIdentifier = commPortIdentifier.next;
                }
            }
        }
        if (commPortIdentifier != null) {
            return commPortIdentifier;
        }
        System.out.println("not found!" + string);
        throw new NoSuchPortException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommPortIdentifier getPortIdentifier(CommPort commPort) throws NoSuchPortException {
        CommPortIdentifier commPortIdentifier;
        System.out.println("CommPortIdentifier:getPortIdentifier(CommPort)");
        Object object = Sync;
        synchronized (object) {
            commPortIdentifier = CommPortIndex;
            while (commPortIdentifier != null && commPortIdentifier.commport != commPort) {
                commPortIdentifier = commPortIdentifier.next;
            }
        }
        if (commPortIdentifier != null) {
            return commPortIdentifier;
        }
        System.out.println("not found!" + commPort.getName());
        throw new NoSuchPortException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getPortIdentifiers() {
        System.out.println("static CommPortIdentifier:getPortIdentifiers()");
        Object object = Sync;
        synchronized (object) {
            HashMap<String, CommPortIdentifier> hashMap = new HashMap<String, CommPortIdentifier>();
            CommPortIdentifier commPortIdentifier = CommPortIndex;
            while (commPortIdentifier != null) {
                hashMap.put(commPortIdentifier.PortName, commPortIdentifier);
                commPortIdentifier = commPortIdentifier.next;
            }
            CommPortIndex = null;
            try {
                CommDriver commDriver = (CommDriver)Class.forName("gnu.io.RXTXCommDriver").newInstance();
                commDriver.initialize();
                CommPortIdentifier commPortIdentifier2 = CommPortIndex;
                CommPortIdentifier commPortIdentifier3 = null;
                while (commPortIdentifier2 != null) {
                    CommPortIdentifier commPortIdentifier4 = (CommPortIdentifier)hashMap.get(commPortIdentifier2.PortName);
                    if (commPortIdentifier4 != null && commPortIdentifier4.PortType == commPortIdentifier2.PortType) {
                        commPortIdentifier4.RXTXDriver = commPortIdentifier2.RXTXDriver;
                        commPortIdentifier4.next = commPortIdentifier2.next;
                        if (commPortIdentifier3 == null) {
                            CommPortIndex = commPortIdentifier4;
                        } else {
                            commPortIdentifier3.next = commPortIdentifier4;
                        }
                        commPortIdentifier3 = commPortIdentifier4;
                    } else {
                        commPortIdentifier3 = commPortIdentifier2;
                    }
                    commPortIdentifier2 = commPortIdentifier2.next;
                }
            }
            catch (Throwable throwable) {
                System.err.println(throwable + " thrown while loading " + "gnu.io.RXTXCommDriver");
                System.err.flush();
            }
        }
        return new CommPortEnumerator();
    }

    public int getPortType() {
        System.out.println("CommPortIdentifier:getPortType()");
        return this.PortType;
    }

    public synchronized boolean isCurrentlyOwned() {
        System.out.println("CommPortIdentifier:isCurrentlyOwned()");
        return !this.Available;
    }

    public synchronized CommPort open(FileDescriptor fileDescriptor) throws UnsupportedCommOperationException {
        System.out.println("CommPortIdentifier:open(FileDescriptor)");
        throw new UnsupportedCommOperationException();
    }

    private native String native_psmisc_report_owner(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommPort open(String string, int n) throws PortInUseException {
        block23: {
            Object object;
            block24: {
                CommPortIdentifier commPortIdentifier;
                boolean bl;
                System.out.println("CommPortIdentifier:open(" + string + ", " + n + ")");
                object = this;
                synchronized (object) {
                    bl = this.Available;
                    if (bl) {
                        this.Available = false;
                        this.Owner = string;
                    }
                }
                if (!bl) {
                    long l = System.currentTimeMillis() + (long)n;
                    this.fireOwnershipEvent(3);
                    CommPortIdentifier commPortIdentifier2 = this;
                    synchronized (commPortIdentifier2) {
                        long l2;
                        while (!this.Available && (l2 = System.currentTimeMillis()) < l) {
                            try {
                                this.wait(l - l2);
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                                break;
                            }
                        }
                        if (bl = this.Available) {
                            this.Available = false;
                            this.Owner = string;
                        }
                    }
                }
                if (!bl) {
                    throw new PortInUseException(this.getCurrentOwner());
                }
                try {
                    if (this.commport == null) {
                        this.commport = this.RXTXDriver.getCommPort(this.PortName, this.PortType);
                    }
                    if (this.commport == null) break block23;
                    this.fireOwnershipEvent(1);
                    object = this.commport;
                    Object var12_11 = null;
                    if (this.commport != null) break block24;
                    commPortIdentifier = this;
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    if (this.commport == null) {
                        CommPortIdentifier commPortIdentifier3 = this;
                        synchronized (commPortIdentifier3) {
                            this.Available = true;
                            this.Owner = null;
                        }
                    }
                    throw throwable;
                }
                synchronized (commPortIdentifier) {
                    this.Available = true;
                    this.Owner = null;
                }
            }
            return object;
        }
        throw new PortInUseException(this.native_psmisc_report_owner(this.PortName));
    }

    public void removePortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        System.out.println("CommPortIdentifier:removePortOwnershipListener()");
        if (this.ownershipListener != null) {
            this.ownershipListener.removeElement(commPortOwnershipListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalClosePort() {
        CommPortIdentifier commPortIdentifier = this;
        synchronized (commPortIdentifier) {
            System.out.println("CommPortIdentifier:internalClosePort()");
            this.Owner = null;
            this.Available = true;
            this.commport = null;
            this.notifyAll();
        }
        this.fireOwnershipEvent(2);
    }

    void fireOwnershipEvent(int n) {
        System.out.println("CommPortIdentifier:fireOwnershipEvent( " + n + " )");
        if (this.ownershipListener != null) {
            Enumeration enumeration = this.ownershipListener.elements();
            while (enumeration.hasMoreElements()) {
                CommPortOwnershipListener commPortOwnershipListener = (CommPortOwnershipListener)enumeration.nextElement();
                commPortOwnershipListener.ownershipChange(n);
            }
        }
    }

    static {
        Object object;
        System.out.println("CommPortIdentifier:static initialization()");
        Sync = new Object();
        try {
            object = (CommDriver)Class.forName("gnu.io.RXTXCommDriver").newInstance();
            object.initialize();
        }
        catch (Throwable throwable) {
            System.err.println(throwable + " thrown while loading " + "gnu.io.RXTXCommDriver");
        }
        object = System.getProperty("os.name");
        if (((String)object).toLowerCase().indexOf("linux") == -1) {
            System.out.println("Have not implemented native_psmisc_report_owner(PortName)); in CommPortIdentifier");
        }
        System.loadLibrary("rxtxSerial");
    }
}

