/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.Validate;

public class Tag {
    private static final Map<String, Tag> tags = new HashMap<String, Tag>();
    private static final Tag defaultAncestor = new Tag("BODY");
    private String tagName;
    private boolean knownTag = false;
    private boolean isBlock = true;
    private boolean canContainBlock = true;
    private boolean canContainInline = true;
    private boolean optionalClosing = false;
    private boolean empty = false;
    private boolean selfClosing = false;
    private boolean preserveWhitespace = false;
    private List<Tag> ancestors;
    private List<Tag> excludes = Collections.emptyList();
    private boolean directDescendant;
    private boolean limitChildren;

    private Tag(String tagName) {
        this.tagName = tagName.toLowerCase();
    }

    public String getName() {
        return this.tagName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tag valueOf(String tagName) {
        Validate.notNull(tagName);
        tagName = tagName.trim().toLowerCase();
        Validate.notEmpty(tagName);
        Map<String, Tag> map = tags;
        synchronized (map) {
            Tag tag = tags.get(tagName);
            if (tag == null) {
                tag = new Tag(tagName);
                tag.setAncestor(Tag.defaultAncestor.tagName);
                tag.setExcludes(new String[0]);
                tag.isBlock = false;
                tag.canContainBlock = true;
            }
            return tag;
        }
    }

    boolean canContain(Tag child) {
        Validate.notNull(child);
        if (child.isBlock && !this.canContainBlock) {
            return false;
        }
        if (!child.isBlock && !this.canContainInline) {
            return false;
        }
        if (this.optionalClosing && this.equals(child)) {
            return false;
        }
        if (this.empty || this.isData()) {
            return false;
        }
        if (this.requiresSpecificParent() && this.getImplicitParent().equals(child)) {
            return false;
        }
        if (this.limitChildren) {
            for (Tag childParent : child.ancestors) {
                if (!childParent.equals(this)) continue;
                return true;
            }
            return false;
        }
        if (!this.excludes.isEmpty()) {
            for (Tag excluded : this.excludes) {
                if (!child.equals(excluded)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public boolean canContainBlock() {
        return this.canContainBlock;
    }

    public boolean isInline() {
        return !this.isBlock;
    }

    public boolean isData() {
        return !this.canContainInline && !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isSelfClosing() {
        return this.empty || this.selfClosing;
    }

    public boolean isKnownTag() {
        return this.knownTag;
    }

    public boolean preserveWhitespace() {
        return this.preserveWhitespace;
    }

    Tag getImplicitParent() {
        return !this.ancestors.isEmpty() ? this.ancestors.get(0) : null;
    }

    boolean requiresSpecificParent() {
        return this.directDescendant;
    }

    boolean isValidParent(Tag child) {
        return this.isValidAncestor(child);
    }

    boolean isValidAncestor(Tag child) {
        if (child.ancestors.isEmpty()) {
            return true;
        }
        for (int i = 0; i < child.ancestors.size(); ++i) {
            if (!this.equals(child.ancestors.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        return !(this.tagName != null ? !this.tagName.equals(tag.tagName) : tag.tagName != null);
    }

    public int hashCode() {
        int result = this.tagName != null ? this.tagName.hashCode() : 0;
        result = 31 * result + (this.isBlock ? 1 : 0);
        result = 31 * result + (this.canContainBlock ? 1 : 0);
        result = 31 * result + (this.canContainInline ? 1 : 0);
        result = 31 * result + (this.optionalClosing ? 1 : 0);
        result = 31 * result + (this.empty ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.tagName;
    }

    private static Tag createBlock(String tagName) {
        return Tag.register(new Tag(tagName));
    }

    private static Tag createInline(String tagName) {
        Tag inline = new Tag(tagName);
        inline.isBlock = false;
        inline.canContainBlock = false;
        return Tag.register(inline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Tag register(Tag tag) {
        tag.setAncestor(Tag.defaultAncestor.tagName);
        tag.setKnownTag();
        Map<String, Tag> map = tags;
        synchronized (map) {
            tags.put(tag.tagName, tag);
        }
        return tag;
    }

    private Tag setContainInlineOnly() {
        this.canContainBlock = false;
        this.canContainInline = true;
        return this;
    }

    private Tag setContainDataOnly() {
        this.canContainBlock = false;
        this.canContainInline = false;
        this.preserveWhitespace = true;
        return this;
    }

    private Tag setEmpty() {
        this.canContainBlock = false;
        this.canContainInline = false;
        this.empty = true;
        return this;
    }

    private Tag setOptionalClosing() {
        this.optionalClosing = true;
        return this;
    }

    private Tag setPreserveWhitespace() {
        this.preserveWhitespace = true;
        return this;
    }

    private Tag setAncestor(String ... tagNames) {
        if (tagNames == null || tagNames.length == 0) {
            this.ancestors = Collections.emptyList();
        } else {
            this.ancestors = new ArrayList<Tag>(tagNames.length);
            for (String name : tagNames) {
                this.ancestors.add(Tag.valueOf(name));
            }
        }
        return this;
    }

    private Tag setExcludes(String ... tagNames) {
        if (tagNames == null || tagNames.length == 0) {
            this.excludes = Collections.emptyList();
        } else {
            this.excludes = new ArrayList<Tag>(tagNames.length);
            for (String name : tagNames) {
                this.excludes.add(Tag.valueOf(name));
            }
        }
        return this;
    }

    private Tag setParent(String ... tagNames) {
        this.directDescendant = true;
        this.setAncestor(tagNames);
        return this;
    }

    private Tag setLimitChildren() {
        this.limitChildren = true;
        return this;
    }

    Tag setSelfClosing() {
        this.selfClosing = true;
        return this;
    }

    private Tag setKnownTag() {
        this.knownTag = true;
        return this;
    }

    static {
        tags.put(Tag.defaultAncestor.tagName, defaultAncestor);
        Tag.createBlock("HTML").setAncestor(new String[0]);
        Tag.createBlock("HEAD").setParent("HTML").setLimitChildren();
        Tag.createBlock("BODY").setAncestor("HTML");
        Tag.createBlock("FRAMESET").setAncestor("HTML");
        Tag.createBlock("SCRIPT").setAncestor("HEAD", "BODY").setContainDataOnly();
        Tag.createBlock("NOSCRIPT").setAncestor("HEAD", "BODY");
        Tag.createBlock("STYLE").setAncestor("HEAD", "BODY").setContainDataOnly();
        Tag.createBlock("META").setAncestor("HEAD", "BODY").setEmpty();
        Tag.createBlock("LINK").setAncestor("HEAD", "BODY").setEmpty();
        Tag.createInline("OBJECT").setAncestor("HEAD", "BODY");
        Tag.createBlock("TITLE").setAncestor("HEAD", "BODY").setContainDataOnly();
        Tag.createInline("BASE").setAncestor("HEAD", "BODY").setEmpty();
        Tag.createBlock("FRAME").setParent("FRAMESET").setEmpty();
        Tag.createBlock("NOFRAMES").setParent("FRAMESET").setContainDataOnly();
        Tag.createBlock("SECTION");
        Tag.createBlock("NAV");
        Tag.createBlock("ASIDE");
        Tag.createBlock("HGROUP").setLimitChildren();
        Tag.createBlock("HEADER").setExcludes("HEADER", "FOOTER");
        Tag.createBlock("FOOTER").setExcludes("HEADER", "FOOTER");
        Tag.createInline("FONT");
        Tag.createInline("TT");
        Tag.createInline("I");
        Tag.createInline("B");
        Tag.createInline("BIG");
        Tag.createInline("SMALL");
        Tag.createInline("EM");
        Tag.createInline("STRONG");
        Tag.createInline("DFN").setOptionalClosing();
        Tag.createInline("CODE");
        Tag.createInline("SAMP");
        Tag.createInline("KBD");
        Tag.createInline("VAR");
        Tag.createInline("CITE");
        Tag.createInline("ABBR");
        Tag.createInline("TIME").setOptionalClosing();
        Tag.createInline("ACRONYM");
        Tag.createInline("MARK");
        Tag.createInline("RUBY");
        Tag.createInline("RT").setParent("RUBY").setExcludes("RT", "RP");
        Tag.createInline("RP").setParent("RUBY").setExcludes("RT", "RP");
        Tag.createInline("A").setOptionalClosing();
        Tag.createInline("IMG").setEmpty();
        Tag.createInline("BR").setEmpty();
        Tag.createInline("WBR").setEmpty();
        Tag.createInline("MAP");
        Tag.createInline("Q");
        Tag.createInline("SUB");
        Tag.createInline("SUP");
        Tag.createInline("SPAN");
        Tag.createInline("BDO");
        Tag.createInline("IFRAME").setOptionalClosing();
        Tag.createInline("EMBED").setEmpty();
        Tag.createBlock("P").setContainInlineOnly();
        Tag.createBlock("H1").setAncestor("BODY", "HGROUP").setContainInlineOnly();
        Tag.createBlock("H2").setAncestor("BODY", "HGROUP").setContainInlineOnly();
        Tag.createBlock("H3").setAncestor("BODY", "HGROUP").setContainInlineOnly();
        Tag.createBlock("H4").setAncestor("BODY", "HGROUP").setContainInlineOnly();
        Tag.createBlock("H5").setAncestor("BODY", "HGROUP").setContainInlineOnly();
        Tag.createBlock("H6").setAncestor("BODY", "HGROUP").setContainInlineOnly();
        Tag.createBlock("UL");
        Tag.createBlock("OL");
        Tag.createBlock("PRE").setContainInlineOnly().setPreserveWhitespace();
        Tag.createBlock("DIV");
        Tag.createBlock("BLOCKQUOTE");
        Tag.createBlock("HR").setEmpty();
        Tag.createBlock("ADDRESS").setContainInlineOnly();
        Tag.createBlock("FIGURE");
        Tag.createBlock("FIGCAPTION").setAncestor("FIGURE");
        Tag.createBlock("FORM").setOptionalClosing();
        Tag.createInline("INPUT").setAncestor("FORM").setEmpty();
        Tag.createInline("SELECT").setAncestor("FORM");
        Tag.createInline("TEXTAREA").setAncestor("FORM").setContainDataOnly();
        Tag.createInline("LABEL").setAncestor("FORM").setOptionalClosing();
        Tag.createInline("BUTTON").setAncestor("FORM");
        Tag.createInline("OPTGROUP").setParent("SELECT");
        Tag.createInline("OPTION").setParent("SELECT", "OPTGROUP", "DATALIST").setOptionalClosing();
        Tag.createBlock("FIELDSET").setAncestor("FORM");
        Tag.createInline("LEGEND").setAncestor("FIELDSET");
        Tag.createInline("DATALIST");
        Tag.createInline("KEYGEN").setEmpty();
        Tag.createInline("OUTPUT");
        Tag.createInline("PROGRESS").setOptionalClosing();
        Tag.createInline("METER").setOptionalClosing();
        Tag.createInline("AREA").setAncestor("MAP").setEmpty();
        Tag.createInline("PARAM").setParent("OBJECT").setEmpty();
        Tag.createBlock("INS");
        Tag.createBlock("DEL");
        Tag.createBlock("DL").setOptionalClosing();
        Tag.createBlock("DT").setAncestor("DL").setExcludes("DL", "DD").setOptionalClosing();
        Tag.createBlock("DD").setAncestor("DL").setExcludes("DL", "DT").setOptionalClosing();
        Tag.createBlock("LI").setAncestor("UL", "OL").setOptionalClosing();
        Tag.createBlock("TABLE");
        Tag.createBlock("CAPTION").setParent("TABLE").setExcludes("THEAD", "TFOOT", "TBODY", "COLGROUP", "COL", "TR", "TH", "TD").setOptionalClosing();
        Tag.createBlock("THEAD").setParent("TABLE").setLimitChildren().setOptionalClosing();
        Tag.createBlock("TFOOT").setParent("TABLE").setLimitChildren().setOptionalClosing();
        Tag.createBlock("TBODY").setParent("TABLE").setLimitChildren().setOptionalClosing();
        Tag.createBlock("COLGROUP").setParent("TABLE").setLimitChildren().setOptionalClosing();
        Tag.createBlock("COL").setParent("COLGROUP").setEmpty();
        Tag.createBlock("TR").setParent("TBODY", "THEAD", "TFOOT", "TABLE").setLimitChildren().setOptionalClosing();
        Tag.createBlock("TH").setParent("TR").setExcludes("THEAD", "TFOOT", "TBODY", "COLGROUP", "COL", "TR", "TH", "TD").setOptionalClosing();
        Tag.createBlock("TD").setParent("TR").setExcludes("THEAD", "TFOOT", "TBODY", "COLGROUP", "COL", "TR", "TH", "TD").setOptionalClosing();
        Tag.createBlock("VIDEO").setExcludes("VIDEO", "AUDIO");
        Tag.createBlock("AUDIO").setExcludes("VIDEO", "AUDIO");
        Tag.createInline("SOURCE").setParent("VIDEO", "AUDIO").setEmpty();
        Tag.createInline("TRACK").setParent("VIDEO", "AUDIO").setEmpty();
        Tag.createBlock("CANVAS");
        Tag.createBlock("DETAILS");
        Tag.createInline("SUMMARY").setParent("DETAILS");
        Tag.createInline("COMMAND").setEmpty();
        Tag.createBlock("MENU");
        Tag.createInline("DEVICE").setEmpty();
    }
}

