/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Element;

public abstract class Evaluator {
    private Evaluator() {
    }

    public abstract boolean matches(Element var1);

    static final class MatchesOwn
    extends Evaluator {
        private Pattern pattern;

        MatchesOwn(Pattern pattern) {
            this.pattern = pattern;
        }

        public boolean matches(Element element) {
            Matcher m = this.pattern.matcher(element.ownText());
            return m.find();
        }
    }

    static final class Matches
    extends Evaluator {
        private Pattern pattern;

        Matches(Pattern pattern) {
            this.pattern = pattern;
        }

        public boolean matches(Element element) {
            Matcher m = this.pattern.matcher(element.text());
            return m.find();
        }
    }

    static final class ContainsOwnText
    extends Evaluator {
        private String searchText;

        ContainsOwnText(String searchText) {
            this.searchText = searchText.toLowerCase();
        }

        public boolean matches(Element element) {
            return element.ownText().toLowerCase().contains(this.searchText);
        }
    }

    static final class ContainsText
    extends Evaluator {
        private String searchText;

        ContainsText(String searchText) {
            this.searchText = searchText.toLowerCase();
        }

        public boolean matches(Element element) {
            return element.text().toLowerCase().contains(this.searchText);
        }
    }

    static abstract class IndexEvaluator
    extends Evaluator {
        protected int index;

        IndexEvaluator(int index) {
            this.index = index;
        }
    }

    static final class IndexEquals
    extends IndexEvaluator {
        IndexEquals(int index) {
            super(index);
        }

        public boolean matches(Element element) {
            return element.elementSiblingIndex() == this.index;
        }
    }

    static final class IndexGreaterThan
    extends IndexEvaluator {
        IndexGreaterThan(int index) {
            super(index);
        }

        public boolean matches(Element element) {
            return element.elementSiblingIndex() > this.index;
        }
    }

    static final class IndexLessThan
    extends IndexEvaluator {
        IndexLessThan(int index) {
            super(index);
        }

        public boolean matches(Element element) {
            return element.elementSiblingIndex() < this.index;
        }
    }

    static final class AllElements
    extends Evaluator {
        AllElements() {
        }

        public boolean matches(Element element) {
            return true;
        }
    }

    static abstract class AttributeKeyPair
    extends Evaluator {
        protected String key;
        protected String value;

        AttributeKeyPair(String key, String value) {
            Validate.notEmpty(key);
            Validate.notEmpty(value);
            this.key = key.trim().toLowerCase();
            this.value = value.trim().toLowerCase();
        }
    }

    static final class AttributeWithValueMatching
    extends Evaluator {
        protected String key;
        protected Pattern pattern;

        AttributeWithValueMatching(String key, Pattern pattern) {
            this.key = key.trim().toLowerCase();
            this.pattern = pattern;
        }

        public boolean matches(Element element) {
            return element.hasAttr(this.key) && this.pattern.matcher(element.attr(this.key)).find();
        }
    }

    static final class AttributeWithValueContaining
    extends AttributeKeyPair {
        AttributeWithValueContaining(String key, String value) {
            super(key, value);
        }

        public boolean matches(Element element) {
            return element.hasAttr(this.key) && element.attr(this.key).toLowerCase().contains(this.value);
        }
    }

    static final class AttributeWithValueEnding
    extends AttributeKeyPair {
        AttributeWithValueEnding(String key, String value) {
            super(key, value);
        }

        public boolean matches(Element element) {
            return element.hasAttr(this.key) && element.attr(this.key).toLowerCase().endsWith(this.value);
        }
    }

    static final class AttributeWithValueStarting
    extends AttributeKeyPair {
        AttributeWithValueStarting(String key, String value) {
            super(key, value);
        }

        public boolean matches(Element element) {
            return element.hasAttr(this.key) && element.attr(this.key).toLowerCase().startsWith(this.value);
        }
    }

    static final class AttributeWithValueNot
    extends AttributeKeyPair {
        AttributeWithValueNot(String key, String value) {
            super(key, value);
        }

        public boolean matches(Element element) {
            return !this.value.equalsIgnoreCase(element.attr(this.key));
        }
    }

    static final class AttributeWithValue
    extends AttributeKeyPair {
        AttributeWithValue(String key, String value) {
            super(key, value);
        }

        public boolean matches(Element element) {
            return element.hasAttr(this.key) && this.value.equalsIgnoreCase(element.attr(this.key));
        }
    }

    static final class AttributeStarting
    extends Evaluator {
        private String keyPrefix;

        AttributeStarting(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        public boolean matches(Element element) {
            List<org.jsoup.nodes.Attribute> values = element.attributes.asList();
            for (org.jsoup.nodes.Attribute attribute : values) {
                if (!attribute.getKey().startsWith(this.keyPrefix)) continue;
                return true;
            }
            return false;
        }
    }

    static final class Attribute
    extends Evaluator {
        private String key;

        Attribute(String key) {
            this.key = key;
        }

        public boolean matches(Element element) {
            return element.hasAttr(this.key);
        }
    }

    static final class Class
    extends Evaluator {
        private String className;

        Class(String className) {
            this.className = className;
        }

        public boolean matches(Element element) {
            return element.hasClass(this.className);
        }
    }

    static final class Id
    extends Evaluator {
        private String id;

        Id(String id) {
            this.id = id;
        }

        public boolean matches(Element element) {
            return this.id.equals(element.id());
        }
    }

    static final class Tag
    extends Evaluator {
        private String tagName;

        Tag(String tagName) {
            this.tagName = tagName;
        }

        public boolean matches(Element element) {
            return element.tagName().equals(this.tagName);
        }
    }
}

