/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class DataUtil {
    private static final Pattern charsetPattern = Pattern.compile("(?i)\\bcharset=([^\\s;]*)");
    static final String defaultCharset = "UTF-8";
    private static final int bufferSize = 131072;

    public static Document load(File in, String charsetName, String baseUri) throws IOException {
        FileInputStream inStream = new FileInputStream(in);
        ByteBuffer byteData = DataUtil.readToByteBuffer(inStream);
        Document doc = DataUtil.parseByteData(byteData, charsetName, baseUri);
        ((InputStream)inStream).close();
        return doc;
    }

    static Document parseByteData(ByteBuffer byteData, String charsetName, String baseUri) {
        String docData;
        Document doc = null;
        if (charsetName == null) {
            docData = Charset.forName(defaultCharset).decode(byteData).toString();
            doc = Jsoup.parse(docData, baseUri);
            Element meta = doc.select("meta[http-equiv=content-type], meta[charset]").first();
            if (meta != null) {
                String foundCharset;
                String string = foundCharset = meta.hasAttr("http-equiv") ? DataUtil.getCharsetFromContentType(meta.attr("content")) : meta.attr("charset");
                if (foundCharset != null && !foundCharset.equals(defaultCharset)) {
                    charsetName = foundCharset;
                    byteData.rewind();
                    docData = Charset.forName(foundCharset).decode(byteData).toString();
                    doc = null;
                }
            }
        } else {
            docData = Charset.forName(charsetName).decode(byteData).toString();
        }
        if (doc == null) {
            doc = Jsoup.parse(docData, baseUri);
            doc.outputSettings().charset(charsetName);
        }
        return doc;
    }

    static ByteBuffer readToByteBuffer(InputStream inStream) throws IOException {
        int read;
        byte[] buffer = new byte[131072];
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(131072);
        while ((read = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, read);
        }
        ByteBuffer byteData = ByteBuffer.wrap(outStream.toByteArray());
        return byteData;
    }

    static String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m = charsetPattern.matcher(contentType);
        if (m.find()) {
            return m.group(1).trim().toUpperCase();
        }
        return null;
    }
}

