/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.swinggui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.core.Card;
import net.yura.domination.engine.guishared.PicturePanel;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.swing.GraphicsUtil;

public class CardsDialog
extends JDialog {
    private Risk myrisk;
    private JPanel CardsPanel;
    private JPanel TradePanel;
    private JScrollPane CardsPlane;
    private BufferedImage Infantry;
    private BufferedImage Cavalry;
    private BufferedImage Artillery;
    private BufferedImage Wildcard;
    private JButton tradeButton;
    private boolean canTrade;
    private JLabel getNum;
    private PicturePanel pp;
    ResourceBundle resb = null;

    public CardsDialog(Frame parent, PicturePanel p, boolean modal, Risk r, boolean ct) {
        super(parent, modal);
        this.myrisk = r;
        this.canTrade = ct;
        this.pp = p;
        this.resb = TranslationBundle.getBundle();
        this.tradeButton = new JButton(this.resb.getString("cards.trade"));
        this.Infantry = RiskUIUtil.getUIImage(this.getClass(), "infantry.gif");
        this.Cavalry = RiskUIUtil.getUIImage(this.getClass(), "cavalry.gif");
        this.Artillery = RiskUIUtil.getUIImage(this.getClass(), "artillery.gif");
        this.Wildcard = RiskUIUtil.getUIImage(this.getClass(), "wildcard.gif");
        this.CardsPanel = new JPanel();
        this.CardsPanel.setLayout(new FlowLayout(0));
        this.TradePanel = new JPanel();
        this.TradePanel.setLayout(new FlowLayout(0));
        this.initGUI();
        this.pack();
    }

    public void populate(List cards) {
        this.tradeButton.setEnabled(false);
        for (int c = 0; c < cards.size(); ++c) {
            CardPanel cp = new CardPanel((Card)cards.get(c));
            this.CardsPanel.add(cp);
        }
    }

    private void initGUI() {
        this.setTitle(this.resb.getString("cards.title"));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getNum = new JLabel();
        this.getNum.setText(this.getNumArmies());
        JTextArea note = new JTextArea(this.resb.getString("cards.note"));
        note.setLineWrap(true);
        note.setWrapStyleWord(true);
        note.setForeground(this.getNum.getForeground());
        note.setFont(new JLabel().getFont());
        note.setEditable(false);
        note.setOpaque(false);
        Dimension noteSize = GraphicsUtil.newDimension(180, 120);
        note.setPreferredSize(noteSize);
        note.setMinimumSize(noteSize);
        note.setMaximumSize(noteSize);
        JButton okButton = new JButton(this.resb.getString("cards.done"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CardsDialog.this.setVisible(false);
                CardsDialog.this.dispose();
            }
        });
        this.tradeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CardsDialog.this.myrisk.parser("trade " + ((CardPanel)CardsDialog.this.TradePanel.getComponent(0)).getCardName() + " " + ((CardPanel)CardsDialog.this.TradePanel.getComponent(1)).getCardName() + " " + ((CardPanel)CardsDialog.this.TradePanel.getComponent(2)).getCardName());
                CardsDialog.this.TradePanel.remove(CardsDialog.this.TradePanel.getComponent(2));
                CardsDialog.this.TradePanel.remove(CardsDialog.this.TradePanel.getComponent(1));
                CardsDialog.this.TradePanel.remove(CardsDialog.this.TradePanel.getComponent(0));
                CardsDialog.this.TradePanel.repaint();
                CardsDialog.this.TradePanel.validate();
                CardsDialog.this.getNum.setText(CardsDialog.this.getNumArmies());
                CardsDialog.this.tradeButton.setEnabled(false);
            }
        });
        this.CardsPlane = new JScrollPane();
        this.CardsPlane.setOpaque(false);
        this.CardsPlane.getViewport().add(this.CardsPanel);
        Dimension CardsPlaneSize = GraphicsUtil.newDimension(550, 230);
        this.CardsPlane.setBorder(BorderFactory.createTitledBorder(this.resb.getString("cards.yourcards")));
        this.CardsPlane.setPreferredSize(CardsPlaneSize);
        this.CardsPlane.setMinimumSize(CardsPlaneSize);
        this.CardsPlane.setMaximumSize(CardsPlaneSize);
        Dimension TradePlaneSize = GraphicsUtil.newDimension(340, 210);
        this.TradePanel.setBorder(BorderFactory.createTitledBorder(this.resb.getString("cards.trade")));
        this.TradePanel.setPreferredSize(TradePlaneSize);
        this.TradePanel.setMinimumSize(TradePlaneSize);
        this.TradePanel.setMaximumSize(TradePlaneSize);
        Dimension otherSize = GraphicsUtil.newDimension(200, 180);
        JPanel other = new JPanel();
        other.setPreferredSize(otherSize);
        other.setMinimumSize(otherSize);
        other.setMaximumSize(otherSize);
        other.add(note);
        other.add(this.getNum);
        other.add(this.tradeButton);
        other.add(okButton);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(3, 3, 3, 3);
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        this.getContentPane().add((Component)this.CardsPlane, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.getContentPane().add((Component)this.TradePanel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.getContentPane().add((Component)other, c);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CardsDialog.this.closeDialog(evt);
            }
        });
    }

    public String getNumArmies() {
        if (this.myrisk.getGame().getCardMode() == 1) {
            return this.resb.getString("cards.fixed");
        }
        if (this.myrisk.getGame().getCardMode() == 2) {
            return this.resb.getString("cards.italianlike");
        }
        return this.resb.getString("cards.nexttrade").replaceAll("\\{0\\}", "" + this.myrisk.getNewCardState());
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    class CardPanel
    extends JPanel
    implements MouseListener {
        private Card card;
        private BufferedImage grayImage;
        private BufferedImage highlightImage;
        private boolean select;

        public CardPanel(Card c) {
            this.card = c;
            this.addMouseListener(this);
            int cardWidth = 100;
            int cardHeight = 170;
            this.select = false;
            Dimension CardSize = GraphicsUtil.newDimension(cardWidth, cardHeight);
            this.setPreferredSize(CardSize);
            this.setMinimumSize(CardSize);
            this.setMaximumSize(CardSize);
            this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0), 1));
            this.grayImage = new BufferedImage(CardSize.width, CardSize.height, 1);
            Graphics2D g2 = this.grayImage.createGraphics();
            g2.setColor(Color.lightGray);
            g2.fillRect(0, 0, this.grayImage.getWidth(), this.grayImage.getHeight());
            g2.setFont(this.getFont());
            if (!this.card.getName().equals("wildcard")) {
                g2.setColor(Color.black);
                GraphicsUtil.drawStringCenteredAt(g2, this.card.getCountry().getName(), cardWidth / 2, 15);
                BufferedImage pictureB = CardsDialog.this.pp.getCountryImage(this.card.getCountry().getColor(), false);
                int width = pictureB.getWidth();
                int height = pictureB.getHeight();
                if (width > 50) {
                    width = 50;
                }
                if (height > 50) {
                    height = 50;
                }
                Image i = pictureB.getScaledInstance(width, height, 4);
                GraphicsUtil.drawImage(g2, i, 25 + (25 - i.getWidth(this) / 2), 25 + (25 - i.getHeight(this) / 2), null);
                if (this.card.getName().equals("Infantry")) {
                    GraphicsUtil.drawImage(g2, CardsDialog.this.Infantry, 15, 85, null);
                } else if (this.card.getName().equals("Cavalry")) {
                    GraphicsUtil.drawImage(g2, CardsDialog.this.Cavalry, 15, 85, null);
                } else if (this.card.getName().equals("Cannon")) {
                    GraphicsUtil.drawImage(g2, CardsDialog.this.Artillery, 15, 85, null);
                }
            } else {
                GraphicsUtil.drawImage(g2, CardsDialog.this.Wildcard, 20, 8, null);
            }
            g2.setColor(Color.black);
            GraphicsUtil.drawStringCenteredAt(g2, this.card.getName(), cardWidth / 2, 160);
            this.highlightImage = new BufferedImage(this.grayImage.getWidth(), this.grayImage.getHeight(), 1);
            RescaleOp HighLight = new RescaleOp(1.5f, 1.0f, null);
            HighLight.filter(this.grayImage, this.highlightImage);
            g2.dispose();
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.select) {
                g.drawImage(this.highlightImage, 0, 0, this);
            } else {
                g.drawImage(this.grayImage, 0, 0, this);
            }
        }

        public String getCardName() {
            if (!this.card.getName().equals("wildcard")) {
                return this.card.getCountry().getColor() + "";
            }
            return this.card.getName();
        }

        public void mouseClicked(MouseEvent e) {
            if (this.getParent() == CardsDialog.this.CardsPanel) {
                if (CardsDialog.this.TradePanel.getComponentCount() < 3) {
                    CardsDialog.this.CardsPanel.remove(this);
                    this.select = false;
                    CardsDialog.this.TradePanel.add(this);
                }
                if (CardsDialog.this.TradePanel.getComponentCount() == 3 && CardsDialog.this.canTrade && CardsDialog.this.myrisk.canTrade(((CardPanel)CardsDialog.this.TradePanel.getComponent(0)).getCardName(), ((CardPanel)CardsDialog.this.TradePanel.getComponent(1)).getCardName(), ((CardPanel)CardsDialog.this.TradePanel.getComponent(2)).getCardName())) {
                    CardsDialog.this.tradeButton.setEnabled(true);
                }
            } else if (this.getParent() == CardsDialog.this.TradePanel) {
                CardsDialog.this.TradePanel.remove(this);
                this.select = false;
                CardsDialog.this.CardsPanel.add(this);
                CardsDialog.this.tradeButton.setEnabled(false);
            }
            CardsDialog.this.CardsPanel.repaint();
            CardsDialog.this.TradePanel.repaint();
            CardsDialog.this.CardsPanel.validate();
            CardsDialog.this.TradePanel.validate();
            CardsDialog.this.CardsPlane.validate();
        }

        public void mouseEntered(MouseEvent e) {
            this.select = true;
            this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            this.select = false;
            this.repaint();
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

