/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.border;

import javax.microedition.lcdui.Image;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.Midlet;
import net.yura.mobile.gui.border.EmptyBorder;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.Properties;

public class MatteBorder
extends EmptyBorder {
    private Icon activeimage;
    private int imageTop;
    private int imageBottom;
    private int imageRight;
    private int imageLeft;
    private boolean back;
    private int color;
    public boolean opaque = true;

    public MatteBorder(int top, int left, int bottom, int right, int color) {
        super(top, left, bottom, right);
        this.color = color;
    }

    public MatteBorder(int top, int left, int bottom, int right, Icon tileIcon) {
        super(top, left, bottom, right);
        this.activeimage = tileIcon;
        this.back = true;
    }

    public static MatteBorder load9png(Image img) {
        int width = img.getWidth();
        int height = img.getHeight();
        int[] result = new int[2];
        int[] insets = new int[(height > width ? height : width) - 2];
        img.getRGB(insets, 0, 1, 0, 1, 1, height - 2);
        MatteBorder.topBotton(insets, result, height - 2);
        int imageTop = result[0];
        int imageBottom = result[1];
        img.getRGB(insets, 0, 1, width - 1, 1, 1, height - 2);
        MatteBorder.topBotton(insets, result, height - 2);
        int top = result[0];
        int bottom = result[1];
        img.getRGB(insets, 0, width - 2, 1, 0, width - 2, 1);
        MatteBorder.topBotton(insets, result, width - 2);
        int imageLeft = result[0];
        int imageRight = result[1];
        img.getRGB(insets, 0, width - 2, 1, height - 1, width - 2, 1);
        MatteBorder.topBotton(insets, result, width - 2);
        int left = result[0];
        int right = result[1];
        MatteBorder border = new MatteBorder(new Icon(img).getSubimage(1, 1, img.getWidth() - 2, img.getHeight() - 2), top, left, bottom, right, imageTop, imageLeft, imageBottom, imageRight, true, 0);
        img.getRGB(insets, 0, 1, img.getWidth() / 2, img.getHeight() / 2, 1, 1);
        border.opaque = Graphics2D.isOpaque(insets[0]);
        return border;
    }

    private static void topBotton(int[] insets, int[] result, int length) {
        result[0] = 0;
        result[1] = 0;
        for (int c = 0; c < length; ++c) {
            if (insets[c] >= 0 && result[1] == 0) {
                result[0] = c + 1;
                continue;
            }
            if (insets[c] >= 0) continue;
            result[1] = length - (c + 1);
        }
    }

    public static MatteBorder load(String name) throws Exception {
        Properties newborder = new Properties();
        newborder.load(Midlet.getResourceAsStream(name));
        String imageName = newborder.getProperty("active");
        if (name.charAt(0) == '/' && imageName.charAt(0) != '/') {
            imageName = "/" + imageName;
        }
        Icon activeimage = new Icon(imageName);
        int imageTop = Integer.parseInt(newborder.getProperty("itop"));
        int imageBottom = Integer.parseInt(newborder.getProperty("ibottom"));
        int imageRight = Integer.parseInt(newborder.getProperty("iright"));
        int imageLeft = Integer.parseInt(newborder.getProperty("ileft"));
        int top = Integer.parseInt(newborder.getProperty("top"));
        int bottom = Integer.parseInt(newborder.getProperty("bottom"));
        int right = Integer.parseInt(newborder.getProperty("right"));
        int left = Integer.parseInt(newborder.getProperty("left"));
        String b = newborder.getProperty("back");
        boolean back = b != null && b.equals("Y");
        String c = newborder.getProperty("color");
        int color = 0;
        if (c != null) {
            color = Integer.parseInt(c, 16);
            if (c.length() == 6) {
                color |= 0xFF000000;
            }
        }
        return new MatteBorder(activeimage, top, left, bottom, right, imageTop, imageLeft, imageBottom, imageRight, back, color);
    }

    public MatteBorder(Icon i, int top, int left, int bottom, int right, int t, int l, int b, int r, boolean back, int color) {
        super(top, left, bottom, right);
        this.activeimage = i;
        this.imageTop = t;
        this.imageLeft = l;
        this.imageBottom = b;
        this.imageRight = r;
        this.back = back;
        this.color = color;
        if (back) {
            Logger.debug("[WARN] MatteBorder created with filling background with tiled image set to true, this should be avoided unless a textured background is needed");
        }
    }

    public Icon getTileIcon() {
        return this.activeimage;
    }

    public void paintBorder(Component c, Graphics2D g, int width, int height) {
        if (this.activeimage == null) {
            g.setColor(this.color);
            if (this.back) {
                g.fillRect(-this.left, -this.top, width + this.left + this.right, height + this.top + this.bottom);
            } else {
                g.fillRect(-this.left, -this.top, width + this.left + this.right, this.top);
                g.fillRect(-this.left, height, width + this.left + this.right, this.bottom);
                g.fillRect(-this.left, 0, this.left, height);
                g.fillRect(width, 0, this.right, height);
            }
        } else if (this.activeimage.getImage() == null) {
            if (this.color != 0) {
                g.setColor(this.color);
                g.fillRect(-this.left, -this.top, width + this.left + this.right, height + this.top + this.bottom);
            }
        } else {
            int imageWidth = this.activeimage.getIconWidth();
            int imageHeight = this.activeimage.getIconHeight();
            int topDiff = this.imageTop - this.top;
            int rightDiff = this.imageRight - this.right;
            int leftDiff = this.imageLeft - this.left;
            int bottomDiff = this.imageBottom - this.bottom;
            Image image = this.activeimage.getImage();
            if (this.imageTop > 0) {
                if (this.imageLeft > 0) {
                    g.drawRegion(image, 0, 0, this.imageLeft, this.imageTop, -this.left, -this.top);
                }
                if (this.imageRight > 0) {
                    g.drawRegion(image, imageWidth - this.imageRight, 0, this.imageRight, this.imageTop, width - rightDiff, -this.top);
                }
            }
            if (this.imageBottom > 0) {
                if (this.imageLeft > 0) {
                    g.drawRegion(image, 0, imageHeight - this.imageBottom, this.imageLeft, this.imageBottom, -this.left, height - bottomDiff);
                }
                if (this.imageRight > 0) {
                    g.drawRegion(image, imageWidth - this.imageRight, imageHeight - this.imageBottom, this.imageRight, this.imageBottom, width - rightDiff, height - bottomDiff);
                }
            }
            g.drawImage(image, this.imageLeft, 0, imageWidth - this.imageRight - this.imageLeft, this.imageTop, leftDiff, -this.top, width - leftDiff - rightDiff, this.imageTop);
            g.drawImage(image, this.imageLeft, imageHeight - this.imageBottom, imageWidth - this.imageRight - this.imageLeft, this.imageBottom, leftDiff, height - bottomDiff, width - leftDiff - rightDiff, this.imageBottom);
            g.drawImage(image, 0, this.imageTop, this.imageLeft, imageHeight - this.imageTop - this.imageBottom, -this.left, topDiff, this.imageLeft, height - topDiff - bottomDiff);
            g.drawImage(image, imageWidth - this.imageRight, this.imageTop, this.imageRight, imageHeight - this.imageTop - this.imageBottom, width - rightDiff, topDiff, this.imageRight, height - topDiff - bottomDiff);
            if (this.back || this.color != 0) {
                if (this.back) {
                    int src_w = imageWidth - this.imageRight - this.imageLeft;
                    int src_h = imageHeight - this.imageTop - this.imageBottom;
                    int dist_w = width - leftDiff - rightDiff;
                    int dist_h = height - topDiff - bottomDiff;
                    if (dist_w > 0 && dist_h > 0 && src_w >= dist_w && src_h >= dist_h) {
                        g.drawRegion(image, this.imageLeft + (src_w - dist_w) / 2, this.imageTop + (src_h - dist_h) / 2, dist_w, dist_h, leftDiff, topDiff);
                    } else {
                        g.drawImage(image, this.imageLeft, this.imageTop, src_w, src_h, leftDiff, topDiff, dist_w, dist_h);
                    }
                } else if (this.color != 0) {
                    boolean fillsides = imageHeight - this.imageTop - this.imageBottom == 0;
                    boolean filltop = imageWidth - this.imageRight - this.imageLeft == 0;
                    g.setColor(this.color);
                    g.fillRect(fillsides ? -this.left : leftDiff, filltop ? -this.top : topDiff, width - (fillsides ? -(this.left + this.right) : leftDiff + rightDiff), height - (filltop ? -(this.top + this.bottom) : topDiff + bottomDiff));
                } else {
                    Logger.info("imagePainter has image but does not have anything to fill the area, this is prob bad");
                }
            }
        }
    }

    public boolean isBorderOpaque() {
        return this.opaque && (this.back || this.activeimage != null && Graphics2D.isOpaque(this.color));
    }

    public void setColor(int c) {
        this.color = c;
    }
}

