/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.properties.PropertyValidationContext;
import org.gradle.api.internal.tasks.properties.ValidatingProperty;
import org.gradle.api.internal.tasks.properties.ValidationAction;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.Severity;
import org.gradle.api.provider.Provider;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.util.internal.DeferredUtil;

public abstract class AbstractValidatingProperty
implements ValidatingProperty {
    private final String propertyName;
    private final PropertyValue value;
    private final boolean optional;
    private final ValidationAction validationAction;

    public AbstractValidatingProperty(String propertyName, PropertyValue value, boolean optional, ValidationAction validationAction) {
        this.propertyName = propertyName;
        this.value = value;
        this.optional = optional;
        this.validationAction = validationAction;
    }

    public static void reportValueNotSet(String propertyName, TypeValidationContext context) {
        context.visitPropertyProblem(problem -> problem.forProperty(propertyName).label("doesn't have a configured value", new Object[0]).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)"value_not_set")).noLocation().type(ValidationProblemId.VALUE_NOT_SET.name()).group("type_validation").severity(Severity.ERROR).details("This property isn't marked as optional and no value has been configured").solution("Assign a value to '" + propertyName + "'").solution("Mark property '" + propertyName + "' as optional"));
    }

    @Override
    public void validate(PropertyValidationContext context) {
        Object unnested = DeferredUtil.unpackNestableDeferred((Object)this.value.call());
        if (AbstractValidatingProperty.isPresent(unnested)) {
            Supplier valueSupplier = Suppliers.memoize(() -> DeferredUtil.unpack((Object)unnested));
            this.validationAction.validate(this.propertyName, (java.util.function.Supplier<Object>)valueSupplier, context);
        } else if (!this.optional) {
            AbstractValidatingProperty.reportValueNotSet(this.propertyName, context);
        }
    }

    private static boolean isPresent(@Nullable Object value) {
        if (value instanceof Provider) {
            return ((Provider)value).isPresent();
        }
        return value != null;
    }

    @Override
    public void prepareValue() {
        this.value.maybeFinalizeValue();
    }

    @Override
    public void cleanupValue() {
    }
}

