/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Table;
import com.google.common.truth.BigDecimalSubject;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.ClassSubject;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.CustomSubjectBuilder;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.FloatSubject;
import com.google.common.truth.GuavaOptionalSubject;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.J2ktIncompatible;
import com.google.common.truth.LongSubject;
import com.google.common.truth.MapSubject;
import com.google.common.truth.MultimapSubject;
import com.google.common.truth.MultisetSubject;
import com.google.common.truth.ObjectArraySubject;
import com.google.common.truth.PrimitiveBooleanArraySubject;
import com.google.common.truth.PrimitiveByteArraySubject;
import com.google.common.truth.PrimitiveCharArraySubject;
import com.google.common.truth.PrimitiveDoubleArraySubject;
import com.google.common.truth.PrimitiveFloatArraySubject;
import com.google.common.truth.PrimitiveIntArraySubject;
import com.google.common.truth.PrimitiveLongArraySubject;
import com.google.common.truth.PrimitiveShortArraySubject;
import com.google.common.truth.SimpleSubjectBuilder;
import com.google.common.truth.StandardSubjectBuilder;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.TableSubject;
import com.google.common.truth.ThrowableSubject;
import java.math.BigDecimal;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Truth {
    private static final StandardSubjectBuilder ASSERT = StandardSubjectBuilder.forCustomFailureStrategy(failure -> {
        throw failure;
    });

    private Truth() {
    }

    public static StandardSubjectBuilder assert_() {
        return ASSERT;
    }

    public static StandardSubjectBuilder assertWithMessage(@Nullable String messageToPrepend) {
        return Truth.assert_().withMessage(messageToPrepend);
    }

    public static StandardSubjectBuilder assertWithMessage(String format, Object ... args) {
        return Truth.assert_().withMessage(format, args);
    }

    public static <S extends Subject, T> SimpleSubjectBuilder<S, T> assertAbout(Subject.Factory<S, T> factory) {
        return Truth.assert_().about(factory);
    }

    public static <CustomSubjectBuilderT extends CustomSubjectBuilder> CustomSubjectBuilderT assertAbout(CustomSubjectBuilder.Factory<CustomSubjectBuilderT> factory) {
        return Truth.assert_().about(factory);
    }

    public static <ComparableT extends Comparable<?>> ComparableSubject<ComparableT> assertThat(@Nullable ComparableT actual) {
        return Truth.assert_().that(actual);
    }

    public static BigDecimalSubject assertThat(@Nullable BigDecimal actual) {
        return Truth.assert_().that(actual);
    }

    public static Subject assertThat(@Nullable Object actual) {
        return Truth.assert_().that(actual);
    }

    @GwtIncompatible(value="ClassSubject.java")
    @J2ktIncompatible
    public static ClassSubject assertThat(@Nullable Class<?> actual) {
        return Truth.assert_().that(actual);
    }

    public static ThrowableSubject assertThat(@Nullable Throwable actual) {
        return Truth.assert_().that(actual);
    }

    public static LongSubject assertThat(@Nullable Long actual) {
        return Truth.assert_().that(actual);
    }

    public static DoubleSubject assertThat(@Nullable Double actual) {
        return Truth.assert_().that(actual);
    }

    public static FloatSubject assertThat(@Nullable Float actual) {
        return Truth.assert_().that(actual);
    }

    public static IntegerSubject assertThat(@Nullable Integer actual) {
        return Truth.assert_().that(actual);
    }

    public static BooleanSubject assertThat(@Nullable Boolean actual) {
        return Truth.assert_().that(actual);
    }

    public static StringSubject assertThat(@Nullable String actual) {
        return Truth.assert_().that(actual);
    }

    public static IterableSubject assertThat(@Nullable Iterable<?> actual) {
        return Truth.assert_().that(actual);
    }

    public static <T> ObjectArraySubject<T> assertThat(@Nullable T @Nullable [] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveBooleanArraySubject assertThat(boolean @Nullable [] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveShortArraySubject assertThat(short @Nullable [] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveIntArraySubject assertThat(int @Nullable [] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveLongArraySubject assertThat(long @Nullable [] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveByteArraySubject assertThat(byte @Nullable [] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveCharArraySubject assertThat(char @Nullable [] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveFloatArraySubject assertThat(float @Nullable [] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveDoubleArraySubject assertThat(double @Nullable [] actual) {
        return Truth.assert_().that(actual);
    }

    public static GuavaOptionalSubject assertThat(@Nullable Optional<?> actual) {
        return Truth.assert_().that(actual);
    }

    public static MapSubject assertThat(@Nullable Map<?, ?> actual) {
        return Truth.assert_().that(actual);
    }

    public static MultimapSubject assertThat(@Nullable Multimap<?, ?> actual) {
        return Truth.assert_().that(actual);
    }

    public static MultisetSubject assertThat(@Nullable Multiset<?> actual) {
        return Truth.assert_().that(actual);
    }

    public static TableSubject assertThat(@Nullable Table<?, ?, ?> actual) {
        return Truth.assert_().that(actual);
    }

    static final class SimpleAssertionError
    extends AssertionError {
        private final @Nullable Throwable cause;

        private SimpleAssertionError(String message, @Nullable Throwable cause) {
            super(Preconditions.checkNotNull((Object)message));
            this.cause = cause;
            try {
                this.initCause(cause);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        static SimpleAssertionError create(String message, @Nullable Throwable cause) {
            return new SimpleAssertionError(message, cause);
        }

        static SimpleAssertionError createWithNoStack(String message, @Nullable Throwable cause) {
            SimpleAssertionError error = SimpleAssertionError.create(message, cause);
            error.setStackTrace(new StackTraceElement[0]);
            return error;
        }

        static SimpleAssertionError createWithNoStack(String message) {
            return SimpleAssertionError.createWithNoStack(message, null);
        }

        public @Nullable Throwable getCause() {
            return this.cause;
        }

        public String toString() {
            return (String)Preconditions.checkNotNull((Object)this.getLocalizedMessage());
        }
    }
}

