/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.CaseFormat;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Chars;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.LazyMessage;
import com.google.common.truth.Platform;
import com.google.common.truth.StandardSubjectBuilder;
import com.google.common.truth.SubjectUtils;
import com.google.errorprone.annotations.DoNotCall;
import com.google.errorprone.annotations.ForOverride;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Subject {
    private final @Nullable FailureMetadata metadata;
    private final @Nullable Object actual;
    private final @Nullable String typeDescriptionOverride;
    private static final char[] hexDigits = "0123456789ABCDEF".toCharArray();
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    protected Subject(FailureMetadata metadata, @Nullable Object actual) {
        this(metadata, actual, null);
    }

    Subject(@Nullable FailureMetadata metadata, @Nullable Object actual, @Nullable String typeDescriptionOverride) {
        this.metadata = metadata == null ? null : metadata.updateForSubject(this);
        this.actual = actual;
        this.typeDescriptionOverride = typeDescriptionOverride;
    }

    public void isNull() {
        this.standardIsEqualTo(null);
    }

    public void isNotNull() {
        this.standardIsNotEqualTo(null);
    }

    public void isEqualTo(@Nullable Object expected) {
        this.standardIsEqualTo(expected);
    }

    private void standardIsEqualTo(@Nullable Object expected) {
        ComparisonResult difference = this.compareForEquality(expected);
        if (!difference.valuesAreEqual()) {
            this.failEqualityCheck(EqualityCheck.EQUAL, expected, difference);
        }
    }

    public void isNotEqualTo(@Nullable Object unexpected) {
        this.standardIsNotEqualTo(unexpected);
    }

    private void standardIsNotEqualTo(@Nullable Object unexpected) {
        ComparisonResult difference = this.compareForEquality(unexpected);
        if (difference.valuesAreEqual()) {
            String unexpectedAsString = this.formatActualOrExpected(unexpected);
            if (this.actualCustomStringRepresentation().equals(unexpectedAsString)) {
                this.failWithoutActual(Fact.fact("expected not to be", unexpectedAsString), new Fact[0]);
            } else {
                this.failWithoutActual(Fact.fact("expected not to be", unexpectedAsString), Fact.fact("but was; string representation of actual value", this.actualCustomStringRepresentation()));
            }
        }
    }

    private ComparisonResult compareForEquality(@Nullable Object expected) {
        if (this.actual == null && expected == null) {
            return ComparisonResult.equal();
        }
        if (this.actual == null || expected == null) {
            return ComparisonResult.differentNoDescription();
        }
        if (this.actual instanceof byte[] && expected instanceof byte[]) {
            return Subject.checkByteArrayEquals((byte[])expected, (byte[])this.actual);
        }
        if (this.actual.getClass().isArray() && expected.getClass().isArray()) {
            return Subject.checkArrayEqualsRecursive(expected, this.actual, "");
        }
        if (Subject.isIntegralBoxedPrimitive(this.actual) && Subject.isIntegralBoxedPrimitive(expected)) {
            return ComparisonResult.fromEqualsResult(Subject.integralValue(this.actual) == Subject.integralValue(expected));
        }
        if (this.actual instanceof Double && expected instanceof Double) {
            return ComparisonResult.fromEqualsResult(Double.compare((Double)this.actual, (Double)expected) == 0);
        }
        if (this.actual instanceof Float && expected instanceof Float) {
            return ComparisonResult.fromEqualsResult(Float.compare(((Float)this.actual).floatValue(), ((Float)expected).floatValue()) == 0);
        }
        if (this.actual instanceof Double && expected instanceof Integer) {
            return ComparisonResult.fromEqualsResult(Double.compare((Double)this.actual, ((Integer)expected).intValue()) == 0);
        }
        if (this.actual instanceof Float && expected instanceof Integer) {
            return ComparisonResult.fromEqualsResult(Double.compare(((Float)this.actual).floatValue(), ((Integer)expected).intValue()) == 0);
        }
        return ComparisonResult.fromEqualsResult(this.actual == expected || this.actual.equals(expected));
    }

    private static boolean isIntegralBoxedPrimitive(@Nullable Object o) {
        return o instanceof Byte || o instanceof Short || o instanceof Character || o instanceof Integer || o instanceof Long;
    }

    private static long integralValue(Object o) {
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        throw new AssertionError((Object)(o + " must be either a Character or a Number."));
    }

    public final void isSameInstanceAs(@Nullable Object expected) {
        if (this.actual != expected) {
            this.failEqualityCheck(EqualityCheck.SAME_INSTANCE, expected, this.compareForEquality(expected).withoutDescription());
        }
    }

    public final void isNotSameInstanceAs(@Nullable Object unexpected) {
        if (this.actual == unexpected) {
            this.failWithoutActual(Fact.fact("expected not to be specific instance", this.actualCustomStringRepresentation()), new Fact[0]);
        }
    }

    public void isInstanceOf(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (this.actual == null) {
            this.failWithActual("expected instance of", clazz.getName());
            return;
        }
        if (!Subject.isInstanceOfType(this.actual, clazz)) {
            if (Subject.classMetadataUnsupported()) {
                throw new UnsupportedOperationException(this.actualCustomStringRepresentation() + ", an instance of " + this.actual.getClass().getName() + ", may or may not be an instance of " + clazz.getName() + ". Under -XdisableClassMetadata, we do not have enough information to tell.");
            }
            this.failWithoutActual(Fact.fact("expected instance of", clazz.getName()), Fact.fact("but was instance of", this.actual.getClass().getName()), Fact.fact("with value", this.actualCustomStringRepresentation()));
        }
    }

    public void isNotInstanceOf(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (Subject.classMetadataUnsupported()) {
            throw new UnsupportedOperationException("isNotInstanceOf is not supported under -XdisableClassMetadata");
        }
        if (this.actual == null) {
            return;
        }
        if (Subject.isInstanceOfType(this.actual, clazz)) {
            this.failWithActual("expected not to be an instance of", clazz.getName());
        }
    }

    private static boolean isInstanceOfType(Object instance, Class<?> clazz) {
        Preconditions.checkArgument((!clazz.isPrimitive() ? 1 : 0) != 0, (String)"Cannot check instanceof for primitive type %s. Pass the wrapper class instead.", (Object)clazz.getSimpleName());
        return Platform.isInstanceOfType(instance, clazz);
    }

    public void isIn(@Nullable Iterable<?> iterable) {
        Preconditions.checkNotNull(iterable);
        if (!Subject.contains(iterable, this.actual)) {
            this.failWithActual("expected any of", iterable);
        }
    }

    private static boolean contains(Iterable<?> haystack, @Nullable Object needle) {
        if (Platform.isKotlinRange(haystack)) {
            return Platform.kotlinRangeContains(haystack, needle);
        }
        return Iterables.contains(haystack, (Object)needle);
    }

    public void isAnyOf(@Nullable Object first, @Nullable Object second, Object ... rest) {
        this.isIn(SubjectUtils.accumulate(first, second, rest));
    }

    public void isNotIn(@Nullable Iterable<?> iterable) {
        Preconditions.checkNotNull(iterable);
        if (Iterables.contains(iterable, (Object)this.actual)) {
            this.failWithActual("expected not to be any of", iterable);
        }
    }

    public void isNoneOf(@Nullable Object first, @Nullable Object second, Object ... rest) {
        this.isNotIn(SubjectUtils.accumulate(first, second, rest));
    }

    final @Nullable Object actual() {
        return this.actual;
    }

    @ForOverride
    protected String actualCustomStringRepresentation() {
        return this.formatActualOrExpected(this.actual);
    }

    final String actualCustomStringRepresentationForPackageMembersToCall() {
        return this.actualCustomStringRepresentation();
    }

    private String formatActualOrExpected(@Nullable Object o) {
        if (o instanceof byte[]) {
            return Subject.base16((byte[])o);
        }
        if (o != null && o.getClass().isArray()) {
            return String.valueOf(Subject.arrayAsListRecursively(o));
        }
        if (o instanceof Double) {
            return Platform.doubleToString((Double)o);
        }
        if (o instanceof Float) {
            return Platform.floatToString(((Float)o).floatValue());
        }
        return Platform.stringValueOfNonFloatingPoint(o);
    }

    private static String base16(byte[] bytes) {
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            sb.append(hexDigits[b >> 4 & 0xF]).append(hexDigits[b & 0xF]);
        }
        return sb.toString();
    }

    private static @Nullable Object arrayAsListRecursively(@Nullable Object input) {
        if (input instanceof Object[]) {
            return Lists.transform(Arrays.asList((Object[])input), Subject::arrayAsListRecursively);
        }
        if (input instanceof boolean[]) {
            return Booleans.asList((boolean[])((boolean[])input));
        }
        if (input instanceof int[]) {
            return Ints.asList((int[])((int[])input));
        }
        if (input instanceof long[]) {
            return Longs.asList((long[])((long[])input));
        }
        if (input instanceof short[]) {
            return Shorts.asList((short[])((short[])input));
        }
        if (input instanceof byte[]) {
            return Bytes.asList((byte[])((byte[])input));
        }
        if (input instanceof double[]) {
            return Subject.doubleArrayAsString((double[])input);
        }
        if (input instanceof float[]) {
            return Subject.floatArrayAsString((float[])input);
        }
        if (input instanceof char[]) {
            return Chars.asList((char[])((char[])input));
        }
        return input;
    }

    private static ComparisonResult checkByteArrayEquals(byte[] expected, byte[] actual) {
        if (Arrays.equals(expected, actual)) {
            return ComparisonResult.equal();
        }
        return ComparisonResult.differentWithDescription(Fact.fact("expected", Arrays.toString(expected)), Fact.fact("but was", Arrays.toString(actual)));
    }

    private static ComparisonResult checkArrayEqualsRecursive(Object expectedArray, Object actualArray, String lastIndex) {
        String actualType;
        if (expectedArray == actualArray) {
            return ComparisonResult.equal();
        }
        String expectedType = Subject.arrayType(expectedArray);
        if (!expectedType.equals(actualType = Subject.arrayType(actualArray))) {
            Fact indexFact = lastIndex.isEmpty() ? Fact.simpleFact("wrong type") : Fact.fact("wrong type for index", lastIndex);
            return ComparisonResult.differentWithDescription(indexFact, Fact.fact("expected", expectedType), Fact.fact("but was", actualType));
        }
        int actualLength = Array.getLength(actualArray);
        int expectedLength = Array.getLength(expectedArray);
        if (expectedLength != actualLength) {
            Fact indexFact = lastIndex.isEmpty() ? Fact.simpleFact("wrong length") : Fact.fact("wrong length for index", lastIndex);
            return ComparisonResult.differentWithDescription(indexFact, Fact.fact("expected", expectedLength), Fact.fact("but was", actualLength));
        }
        for (int i = 0; i < actualLength; ++i) {
            String index = lastIndex + "[" + i + "]";
            Object expected = Array.get(expectedArray, i);
            Object actual = Array.get(actualArray, i);
            if (actual != null && actual.getClass().isArray() && expected != null && expected.getClass().isArray()) {
                ComparisonResult result = Subject.checkArrayEqualsRecursive(expected, actual, index);
                if (result.valuesAreEqual()) continue;
                return result;
            }
            if (Subject.gwtSafeObjectEquals(actual, expected)) continue;
            return ComparisonResult.differentWithDescription(Fact.fact("differs at index", index));
        }
        return ComparisonResult.equal();
    }

    private static String arrayType(Object array) {
        if (array.getClass() == boolean[].class) {
            return "boolean[]";
        }
        if (array.getClass() == int[].class) {
            return "int[]";
        }
        if (array.getClass() == long[].class) {
            return "long[]";
        }
        if (array.getClass() == short[].class) {
            return "short[]";
        }
        if (array.getClass() == byte[].class) {
            return "byte[]";
        }
        if (array.getClass() == double[].class) {
            return "double[]";
        }
        if (array.getClass() == float[].class) {
            return "float[]";
        }
        if (array.getClass() == char[].class) {
            return "char[]";
        }
        return "Object[]";
    }

    private static boolean gwtSafeObjectEquals(@Nullable Object actual, @Nullable Object expected) {
        if (actual instanceof Double && expected instanceof Double) {
            return Double.doubleToLongBits((Double)actual) == Double.doubleToLongBits((Double)expected);
        }
        if (actual instanceof Float && expected instanceof Float) {
            return Float.floatToIntBits(((Float)actual).floatValue()) == Float.floatToIntBits(((Float)expected).floatValue());
        }
        return Objects.equal((Object)actual, (Object)expected);
    }

    private static List<String> doubleArrayAsString(double[] items) {
        ArrayList<String> itemAsStrings = new ArrayList<String>(items.length);
        for (double item : items) {
            itemAsStrings.add(Platform.doubleToString(item));
        }
        return itemAsStrings;
    }

    private static List<String> floatArrayAsString(float[] items) {
        ArrayList<String> itemAsStrings = new ArrayList<String>(items.length);
        for (float item : items) {
            itemAsStrings.add(Platform.floatToString(item));
        }
        return itemAsStrings;
    }

    @Deprecated
    final StandardSubjectBuilder check() {
        return new StandardSubjectBuilder(((FailureMetadata)Preconditions.checkNotNull((Object)this.metadata)).updateForCheckCall());
    }

    protected final StandardSubjectBuilder check(String format, Object ... args) {
        return this.doCheck(FailureMetadata.OldAndNewValuesAreSimilar.DIFFERENT, format, args);
    }

    final StandardSubjectBuilder checkNoNeedToDisplayBothValues(String format, Object ... args) {
        return this.doCheck(FailureMetadata.OldAndNewValuesAreSimilar.SIMILAR, format, args);
    }

    private StandardSubjectBuilder doCheck(FailureMetadata.OldAndNewValuesAreSimilar valuesAreSimilar, String format, @Nullable Object[] args) {
        LazyMessage message = new LazyMessage(format, args);
        return new StandardSubjectBuilder(((FailureMetadata)Preconditions.checkNotNull((Object)this.metadata)).updateForCheckCall(valuesAreSimilar, (Function<String, String>)((Function)input -> input + "." + message)));
    }

    protected final StandardSubjectBuilder ignoreCheck() {
        return StandardSubjectBuilder.forCustomFailureStrategy(failure -> {});
    }

    protected final void failWithActual(String key, @Nullable Object value) {
        this.failWithActual(Fact.fact(key, value), new Fact[0]);
    }

    protected final void failWithActual(Fact first, Fact ... rest) {
        this.doFail(SubjectUtils.sandwich(first, rest, this.butWas()));
    }

    final void failWithActual(Iterable<Fact> facts) {
        this.doFail(SubjectUtils.append(ImmutableList.copyOf(facts), this.butWas()));
    }

    @Deprecated
    final void fail(String check) {
        this.fail(check, new Object[0]);
    }

    @Deprecated
    final void fail(String verb, Object other) {
        this.fail(verb, new Object[]{other});
    }

    @Deprecated
    final void fail(String verb, Object ... messageParts) {
        StringBuilder message = new StringBuilder("Not true that <");
        message.append(this.actualCustomStringRepresentation()).append("> ").append(verb);
        for (Object part : messageParts) {
            message.append(" <").append(part).append(">");
        }
        this.failWithoutActual(Fact.simpleFact(message.toString()), new Fact[0]);
    }

    final void failEqualityCheckForEqualsWithoutDescription(@Nullable Object expected) {
        this.failEqualityCheck(EqualityCheck.EQUAL, expected, ComparisonResult.differentNoDescription());
    }

    private void failEqualityCheck(EqualityCheck equalityCheck, @Nullable Object expected, ComparisonResult difference) {
        String actualString = this.actualCustomStringRepresentation();
        String expectedString = this.formatActualOrExpected(expected);
        String actualClass = this.actual == null ? "(null reference)" : this.actual.getClass().getName();
        String expectedClass = expected == null ? "(null reference)" : expected.getClass().getName();
        boolean sameToStrings = actualString.equals(expectedString);
        boolean sameClassNames = actualClass.equals(expectedClass);
        boolean equal = difference.valuesAreEqual();
        if (equalityCheck == EqualityCheck.EQUAL && (this.tryFailForTrailingWhitespaceOnly(expected) || this.tryFailForEmptyString(expected))) {
            return;
        }
        if (sameToStrings) {
            if (sameClassNames) {
                String doppelgangerDescription = equal ? "(different but equal instance of same class with same string representation)" : "(non-equal instance of same class with same string representation)";
                this.failEqualityCheckNoComparisonFailure(difference, Fact.fact(equalityCheck.keyForExpected, expectedString), Fact.fact("but was", doppelgangerDescription));
            } else {
                this.failEqualityCheckNoComparisonFailure(difference, Fact.fact(equalityCheck.keyForExpected, expectedString), Fact.fact("an instance of", expectedClass), Fact.fact("but was", "(non-equal value with same string representation)"), Fact.fact("an instance of", actualClass));
            }
        } else if (equalityCheck == EqualityCheck.EQUAL && this.actual != null && expected != null) {
            ((FailureMetadata)Preconditions.checkNotNull((Object)this.metadata)).failEqualityCheck(difference.factsOrEmpty(), expectedString, actualString);
        } else {
            this.failEqualityCheckNoComparisonFailure(difference, Fact.fact(equalityCheck.keyForExpected, expectedString), Fact.fact("but was", actualString));
        }
    }

    private boolean tryFailForTrailingWhitespaceOnly(@Nullable Object expected) {
        if (!(this.actual instanceof String) || !(expected instanceof String)) {
            return false;
        }
        String actualString = (String)this.actual;
        String expectedString = (String)expected;
        String actualNoTrailing = CharMatcher.whitespace().trimTrailingFrom((CharSequence)actualString);
        String expectedNoTrailing = CharMatcher.whitespace().trimTrailingFrom((CharSequence)expectedString);
        String expectedTrailing = Subject.escapeWhitespace(expectedString.substring(expectedNoTrailing.length()));
        String actualTrailing = Subject.escapeWhitespace(actualString.substring(actualNoTrailing.length()));
        if (!actualNoTrailing.equals(expectedNoTrailing)) {
            return false;
        }
        if (actualString.startsWith(expectedString)) {
            this.failWithoutActual(Fact.fact("expected", expectedString), Fact.fact("but contained extra trailing whitespace", actualTrailing));
        } else if (expectedString.startsWith(actualString)) {
            this.failWithoutActual(Fact.fact("expected", expectedString), Fact.fact("but was missing trailing whitespace", expectedTrailing));
        } else {
            this.failWithoutActual(Fact.fact("expected", expectedString), Fact.fact("with trailing whitespace", expectedTrailing), Fact.fact("but trailing whitespace was", actualTrailing));
        }
        return true;
    }

    private static String escapeWhitespace(String in) {
        StringBuilder out = new StringBuilder();
        for (char c : in.toCharArray()) {
            out.append(Subject.escapeWhitespace(c));
        }
        return out.toString();
    }

    private static String escapeWhitespace(char c) {
        switch (c) {
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case ' ': {
                return "\u2423";
            }
        }
        return new String(Subject.asUnicodeHexEscape(c));
    }

    private boolean tryFailForEmptyString(@Nullable Object expected) {
        if (!(this.actual instanceof String) || !(expected instanceof String)) {
            return false;
        }
        String actualString = (String)this.actual;
        String expectedString = (String)expected;
        if (actualString.isEmpty()) {
            this.failWithoutActual(Fact.fact("expected", expectedString), Fact.simpleFact("but was an empty string"));
            return true;
        }
        if (expectedString.isEmpty()) {
            this.failWithoutActual(Fact.simpleFact("expected an empty string"), Fact.fact("but was", actualString));
            return true;
        }
        return false;
    }

    private static char[] asUnicodeHexEscape(char c) {
        char[] r = new char[6];
        r[0] = 92;
        r[1] = 117;
        r[5] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[4] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[3] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[2] = HEX_DIGITS[c & 0xF];
        return r;
    }

    private void failEqualityCheckNoComparisonFailure(ComparisonResult difference, Fact ... facts) {
        this.doFail(SubjectUtils.concat(new Iterable[]{Arrays.asList(facts), difference.factsOrEmpty()}));
    }

    @Deprecated
    final void failWithBadResults(String verb, Object expected, String failVerb, Object actual) {
        String message = Strings.lenientFormat((String)"Not true that <%s> %s <%s>. It %s <%s>", (Object[])new Object[]{this.actualCustomStringRepresentation(), verb, expected, failVerb, actual == null ? "null reference" : actual});
        this.failWithoutActual(Fact.simpleFact(message), new Fact[0]);
    }

    @Deprecated
    final void failWithCustomSubject(String verb, Object expected, Object actual) {
        String message = Strings.lenientFormat((String)"Not true that <%s> %s <%s>", (Object[])new Object[]{actual == null ? "null reference" : actual, verb, expected});
        this.failWithoutActual(Fact.simpleFact(message), new Fact[0]);
    }

    @Deprecated
    final void failWithoutSubject(String check) {
        this.failWithoutActual(Fact.simpleFact(Strings.lenientFormat((String)"Not true that the subject %s", (Object[])new Object[]{check})), new Fact[0]);
    }

    protected final void failWithoutActual(Fact first, Fact ... rest) {
        this.doFail((ImmutableList<Fact>)ImmutableList.copyOf((Collection)Lists.asList((Object)first, (Object[])rest)));
    }

    final void failWithoutActual(Iterable<Fact> facts) {
        this.doFail((ImmutableList<Fact>)ImmutableList.copyOf(facts));
    }

    @Deprecated
    final void failWithoutActual(String check) {
        this.failWithoutSubject(check);
    }

    @Deprecated
    @DoNotCall(value="Subject.equals() is not supported. Did you mean to call assertThat(actual).isEqualTo(expected) instead of assertThat(actual).equals(expected)?")
    public final boolean equals(@Nullable Object o) {
        throw new UnsupportedOperationException("Subject.equals() is not supported. Did you mean to call assertThat(actual).isEqualTo(expected) instead of assertThat(actual).equals(expected)?");
    }

    @Deprecated
    @DoNotCall(value="Subject.hashCode() is not supported.")
    public final int hashCode() {
        throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
    }

    @Deprecated
    public String toString() {
        throw new UnsupportedOperationException("Subject.toString() is not supported. Did you mean to call assertThat(foo.toString()) instead of assertThat(foo).toString()?");
    }

    final Fact butWas() {
        return Fact.fact("but was", this.actualCustomStringRepresentation());
    }

    final String typeDescription() {
        return Subject.typeDescriptionOrGuess(this.getClass(), this.typeDescriptionOverride);
    }

    private static String typeDescriptionOrGuess(Class<? extends Subject> clazz, @Nullable String typeDescriptionOverride) {
        if (typeDescriptionOverride != null) {
            return typeDescriptionOverride;
        }
        String subjectClass = clazz.getSimpleName().replaceFirst(".*[$]", "");
        String actualClass = subjectClass.endsWith("Subject") && !subjectClass.equals("Subject") ? subjectClass.substring(0, subjectClass.length() - "Subject".length()) : "Object";
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, actualClass);
    }

    private static boolean classMetadataUnsupported() {
        return String.class.getSuperclass() == null;
    }

    private void doFail(ImmutableList<Fact> facts) {
        ((FailureMetadata)Preconditions.checkNotNull((Object)this.metadata)).fail(facts);
    }

    static enum EqualityCheck {
        EQUAL("expected"),
        SAME_INSTANCE("expected specific instance");

        final String keyForExpected;

        private EqualityCheck(String keyForExpected) {
            this.keyForExpected = keyForExpected;
        }
    }

    private static final class ComparisonResult {
        private static final ComparisonResult EQUAL = new ComparisonResult(null);
        private static final ComparisonResult DIFFERENT_NO_DESCRIPTION = new ComparisonResult((ImmutableList<Fact>)ImmutableList.of());
        private final @Nullable ImmutableList<Fact> facts;

        static ComparisonResult fromEqualsResult(boolean equal) {
            return equal ? EQUAL : DIFFERENT_NO_DESCRIPTION;
        }

        static ComparisonResult differentWithDescription(Fact ... facts) {
            return new ComparisonResult((ImmutableList<Fact>)ImmutableList.copyOf((Object[])facts));
        }

        static ComparisonResult equal() {
            return EQUAL;
        }

        static ComparisonResult differentNoDescription() {
            return DIFFERENT_NO_DESCRIPTION;
        }

        private ComparisonResult(@Nullable ImmutableList<Fact> facts) {
            this.facts = facts;
        }

        boolean valuesAreEqual() {
            return this.facts == null;
        }

        ImmutableList<Fact> factsOrEmpty() {
            return (ImmutableList)MoreObjects.firstNonNull(this.facts, (Object)ImmutableList.of());
        }

        ComparisonResult withoutDescription() {
            return ComparisonResult.fromEqualsResult(this.valuesAreEqual());
        }
    }

    public static interface Factory<SubjectT extends Subject, ActualT> {
        public SubjectT createSubject(FailureMetadata var1, @Nullable ActualT var2);
    }
}

