/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;

final class LazyMessage {
    private final String format;
    private final @Nullable Object[] args;

    LazyMessage(String format, Object ... args) {
        this.format = format;
        this.args = args;
        int placeholders = LazyMessage.countPlaceholders(format);
        Preconditions.checkArgument((placeholders == args.length ? 1 : 0) != 0, (String)"Incorrect number of args (%s) for the given placeholders (%s) in string template:\"%s\"", (Object)args.length, (Object)placeholders, (Object)format);
    }

    public String toString() {
        return Strings.lenientFormat((String)this.format, (Object[])this.args);
    }

    @VisibleForTesting
    static int countPlaceholders(String template) {
        int index = 0;
        int count = 0;
        while ((index = template.indexOf("%s", index)) != -1) {
            ++index;
            ++count;
        }
        return count;
    }

    static ImmutableList<String> evaluateAll(ImmutableList<LazyMessage> messages) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (LazyMessage message : messages) {
            result.add((Object)message.toString());
        }
        return result.build();
    }
}

