/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.Fact;
import com.google.common.truth.MathUtil;
import com.google.common.truth.Platform;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Correspondence<A, E> {
    public static <A, E> Correspondence<A, E> from(BinaryPredicate<A, E> predicate, String description) {
        return new FromBinaryPredicate(predicate, description);
    }

    public static <A, E> Correspondence<A, E> transforming(Function<A, ? extends E> actualTransform, String description) {
        return new Transforming(actualTransform, Functions.identity(), description);
    }

    public static <A, E> Correspondence<A, E> transforming(Function<A, ?> actualTransform, Function<E, ?> expectedTransform, String description) {
        return new Transforming(actualTransform, expectedTransform, description);
    }

    public static Correspondence<Number, Number> tolerance(double tolerance) {
        return new TolerantNumericEquality(tolerance);
    }

    static <T> Correspondence<T, T> equality() {
        return Equality.INSTANCE;
    }

    @Deprecated
    Correspondence() {
    }

    public Correspondence<A, E> formattingDiffsUsing(DiffFormatter<? super A, ? super E> formatter) {
        return new FormattingDiffs<A, E>(this, formatter);
    }

    public abstract boolean compare(A var1, E var2);

    final boolean safeCompare(A actual, E expected, ExceptionStore exceptions) {
        try {
            return this.compare(actual, expected);
        }
        catch (RuntimeException e) {
            exceptions.addCompareException(Correspondence.class, e, actual, expected);
            return false;
        }
    }

    public @Nullable String formatDiff(A actual, E expected) {
        return null;
    }

    final @Nullable String safeFormatDiff(A actual, E expected, ExceptionStore exceptions) {
        try {
            return this.formatDiff(actual, expected);
        }
        catch (RuntimeException e) {
            exceptions.addFormatDiffException(Correspondence.class, e, actual, expected);
            return null;
        }
    }

    public abstract String toString();

    boolean isEquality() {
        return false;
    }

    final ImmutableList<Fact> describeForIterable() {
        if (!this.isEquality()) {
            return ImmutableList.of((Object)Fact.fact("testing whether", "actual element " + this + " expected element"));
        }
        return ImmutableList.of();
    }

    final ImmutableList<Fact> describeForMapValues() {
        if (!this.isEquality()) {
            return ImmutableList.of((Object)Fact.fact("testing whether", "actual value " + this + " expected value"));
        }
        return ImmutableList.of();
    }

    @Deprecated
    public final boolean equals(@Nullable Object o) {
        throw new UnsupportedOperationException("Correspondence.equals(object) is not supported. If you meant to compare objects, use .compare(actual, expected) instead.");
    }

    @Deprecated
    public final int hashCode() {
        throw new UnsupportedOperationException("Correspondence.hashCode() is not supported.");
    }

    static final class ExceptionStore {
        private final String argumentLabel;
        private @Nullable StoredException firstCompareException = null;
        private @Nullable StoredException firstPairingException = null;
        private @Nullable StoredException firstFormatDiffException = null;

        static ExceptionStore forIterable() {
            return new ExceptionStore("elements");
        }

        static ExceptionStore forMapValues() {
            return new ExceptionStore("values");
        }

        private ExceptionStore(String argumentLabel) {
            this.argumentLabel = argumentLabel;
        }

        void addCompareException(Class<?> callingClass, Exception exception, @Nullable Object actual, @Nullable Object expected) {
            if (this.firstCompareException == null) {
                ExceptionStore.truncateStackTrace(exception, callingClass);
                this.firstCompareException = new StoredException(exception, "compare", Arrays.asList(actual, expected));
            }
        }

        void addActualKeyFunctionException(Class<?> callingClass, Exception exception, @Nullable Object actual) {
            if (this.firstPairingException == null) {
                ExceptionStore.truncateStackTrace(exception, callingClass);
                this.firstPairingException = new StoredException(exception, "actualKeyFunction.apply", Arrays.asList(actual));
            }
        }

        void addExpectedKeyFunctionException(Class<?> callingClass, Exception exception, @Nullable Object expected) {
            if (this.firstPairingException == null) {
                ExceptionStore.truncateStackTrace(exception, callingClass);
                this.firstPairingException = new StoredException(exception, "expectedKeyFunction.apply", Arrays.asList(expected));
            }
        }

        void addFormatDiffException(Class<?> callingClass, Exception exception, @Nullable Object actual, @Nullable Object expected) {
            if (this.firstFormatDiffException == null) {
                ExceptionStore.truncateStackTrace(exception, callingClass);
                this.firstFormatDiffException = new StoredException(exception, "formatDiff", Arrays.asList(actual, expected));
            }
        }

        boolean hasCompareException() {
            return this.firstCompareException != null;
        }

        ImmutableList<Fact> describeAsMainCause() {
            Preconditions.checkState((this.firstCompareException != null ? 1 : 0) != 0);
            Preconditions.checkState((this.firstPairingException == null ? 1 : 0) != 0);
            Preconditions.checkState((this.firstFormatDiffException == null ? 1 : 0) != 0);
            return ImmutableList.of((Object)Fact.simpleFact("one or more exceptions were thrown while comparing " + this.argumentLabel), (Object)Fact.fact("first exception", this.firstCompareException.describe()));
        }

        ImmutableList<Fact> describeAsAdditionalInfo() {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (this.firstCompareException != null) {
                builder.add((Object)Fact.simpleFact("additionally, one or more exceptions were thrown while comparing " + this.argumentLabel));
                builder.add((Object)Fact.fact("first exception", this.firstCompareException.describe()));
            }
            if (this.firstPairingException != null) {
                builder.add((Object)Fact.simpleFact("additionally, one or more exceptions were thrown while keying " + this.argumentLabel + " for pairing"));
                builder.add((Object)Fact.fact("first exception", this.firstPairingException.describe()));
            }
            if (this.firstFormatDiffException != null) {
                builder.add((Object)Fact.simpleFact("additionally, one or more exceptions were thrown while formatting diffs"));
                builder.add((Object)Fact.fact("first exception", this.firstFormatDiffException.describe()));
            }
            return builder.build();
        }

        private static void truncateStackTrace(Exception exception, Class<?> callingClass) {
            int keep;
            StackTraceElement[] original = exception.getStackTrace();
            for (keep = 0; keep < original.length && !original[keep].getClassName().equals(callingClass.getName()); ++keep) {
            }
            exception.setStackTrace(Arrays.copyOf(original, keep));
        }
    }

    private static class StoredException {
        private static final Joiner ARGUMENT_JOINER = Joiner.on((String)", ").useForNull("null");
        private final Exception exception;
        private final String methodName;
        private final List<@Nullable Object> methodArguments;

        StoredException(Exception exception, String methodName, List<@Nullable Object> methodArguments) {
            this.exception = (Exception)Preconditions.checkNotNull((Object)exception);
            this.methodName = (String)Preconditions.checkNotNull((Object)methodName);
            this.methodArguments = (List)Preconditions.checkNotNull(methodArguments);
        }

        private String describe() {
            return Strings.lenientFormat((String)"%s(%s) threw %s\n---", (Object[])new Object[]{this.methodName, ARGUMENT_JOINER.join(this.methodArguments), Platform.getStackTraceAsString(this.exception)});
        }
    }

    private static class FormattingDiffs<A, E>
    extends Correspondence<A, E> {
        private final Correspondence<A, E> delegate;
        private final DiffFormatter<? super A, ? super E> formatter;

        FormattingDiffs(Correspondence<A, E> delegate, DiffFormatter<? super A, ? super E> formatter) {
            this.delegate = (Correspondence)Preconditions.checkNotNull(delegate);
            this.formatter = (DiffFormatter)Preconditions.checkNotNull(formatter);
        }

        @Override
        public boolean compare(A actual, E expected) {
            return this.delegate.compare(actual, expected);
        }

        @Override
        public @Nullable String formatDiff(A actual, E expected) {
            return this.formatter.formatDiff(actual, expected);
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        boolean isEquality() {
            return this.delegate.isEquality();
        }
    }

    public static interface DiffFormatter<A, E> {
        public @Nullable String formatDiff(A var1, E var2);
    }

    private static final class Equality<T>
    extends Correspondence<T, T> {
        private static final Equality<Object> INSTANCE = new Equality();

        private Equality() {
        }

        @Override
        public boolean compare(T actual, T expected) {
            return Objects.equal(actual, expected);
        }

        @Override
        public String toString() {
            return "is equal to";
        }

        @Override
        boolean isEquality() {
            return true;
        }
    }

    private static final class TolerantNumericEquality
    extends Correspondence<Number, Number> {
        private final double tolerance;

        private TolerantNumericEquality(double tolerance) {
            DoubleSubject.checkTolerance(tolerance);
            this.tolerance = tolerance;
        }

        @Override
        public boolean compare(Number actual, Number expected) {
            double actualDouble = ((Number)Preconditions.checkNotNull((Object)actual)).doubleValue();
            double expectedDouble = ((Number)Preconditions.checkNotNull((Object)expected)).doubleValue();
            return MathUtil.equalWithinTolerance(actualDouble, expectedDouble, this.tolerance);
        }

        @Override
        public String toString() {
            return "is a finite number within " + this.tolerance + " of";
        }
    }

    private static final class Transforming<A, E>
    extends Correspondence<A, E> {
        private final Function<? super A, ?> actualTransform;
        private final Function<? super E, ?> expectedTransform;
        private final String description;

        private Transforming(Function<? super A, ?> actualTransform, Function<? super E, ?> expectedTransform, String description) {
            this.actualTransform = actualTransform;
            this.expectedTransform = expectedTransform;
            this.description = description;
        }

        @Override
        public boolean compare(A actual, E expected) {
            return Objects.equal((Object)this.actualTransform.apply(actual), (Object)this.expectedTransform.apply(expected));
        }

        @Override
        public String toString() {
            return this.description;
        }
    }

    private static final class FromBinaryPredicate<A, E>
    extends Correspondence<A, E> {
        private final BinaryPredicate<A, E> predicate;
        private final String description;

        private FromBinaryPredicate(BinaryPredicate<A, E> correspondencePredicate, String description) {
            this.predicate = (BinaryPredicate)Preconditions.checkNotNull(correspondencePredicate);
            this.description = (String)Preconditions.checkNotNull((Object)description);
        }

        @Override
        public boolean compare(A actual, E expected) {
            return this.predicate.apply(actual, expected);
        }

        @Override
        public String toString() {
            return this.description;
        }
    }

    public static interface BinaryPredicate<A, E> {
        public boolean apply(A var1, E var2);
    }
}

