/*******************************************************************************
 * Copyright (c) Contributors to the Eclipse Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 *******************************************************************************/
package org.osgi.service.feature;

import org.osgi.annotation.versioning.ProviderType;

/**
 * A builder for Feature Model {@link FeatureExtension} objects.
 * @NotThreadSafe
 */
@ProviderType
public interface FeatureExtensionBuilder {

    /**
	 * Add a line of text to the extension. Can only be called for extensions of
	 * type {@link FeatureExtension.Type#TEXT}.
	 *
	 * @param text The text to be added.
	 * @return This builder.
	 */
    FeatureExtensionBuilder addText(String text);

    /**
	 * Add JSON in String form to the extension. Can only be called for
	 * extensions of type {@link FeatureExtension.Type#JSON}.
	 *
	 * @param json The JSON to be added.
	 * @return This builder.
	 */
    FeatureExtensionBuilder setJSON(String json);

    /**
	 * Add an Artifact to the extension. Can only be called for extensions of
	 * type {@link FeatureExtension.Type#ARTIFACTS}.
	 *
	 * @param artifact The artifact to add.
	 * @return This builder.
	 */
	FeatureExtensionBuilder addArtifact(FeatureArtifact artifact);

    /**
     * Build the Extension. Can only be called once on a builder. After
     * calling this method the current builder instance cannot be used any more.
     * @return The Extension.
     */
    FeatureExtension build();

}
