/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.preferences.ListProperty;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Pair;

public class OverlappingWays
extends Test {
    private MultiMap<Pair<Node, Node>, WaySegment> nodePairs;
    private boolean onlyKnownLinear;
    private boolean includeOther;
    private boolean ignoreLayer;
    protected static final int OVERLAPPING_HIGHWAY = 101;
    protected static final int OVERLAPPING_RAILWAY = 102;
    protected static final int OVERLAPPING_WAY = 103;
    protected static final int OVERLAPPING_WATERWAY = 104;
    protected static final int OVERLAPPING_HIGHWAY_AREA = 111;
    protected static final int OVERLAPPING_RAILWAY_AREA = 112;
    protected static final int OVERLAPPING_WAY_AREA = 113;
    protected static final int OVERLAPPING_WATERWAY_AREA = 114;
    protected static final int DUPLICATE_WAY_SEGMENT = 121;
    protected static final int OVERLAPPING_HIGHWAY_LINEAR_WAY = 131;
    protected static final int OVERLAPPING_RAILWAY_LINEAR_WAY = 132;
    protected static final int OVERLAPPING_WATERWAY_LINEAR_WAY = 133;
    protected static final ListProperty IGNORED_KEYS = new ListProperty("overlapping-ways.ignored-keys", Arrays.asList("barrier", "indoor", "building", "building:part", "historic:building", "demolished:building", "removed:building", "disused:building", "abandoned:building", "proposed:building", "man_made"));
    protected static final Predicate<OsmPrimitive> IGNORED = primitive -> IGNORED_KEYS.get().stream().anyMatch(primitive::hasKey) || primitive.hasTag("tourism", "camp_site");

    public OverlappingWays() {
        super(I18n.tr("Overlapping ways", new Object[0]), I18n.tr("This test checks that a connection between two nodes is not used by more than one way.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.nodePairs = new MultiMap(1000);
        this.includeOther = this.isBeforeUpload ? ValidatorPrefHelper.PREF_OTHER_UPLOAD.get() : ValidatorPrefHelper.PREF_OTHER.get();
        this.onlyKnownLinear = Config.getPref().getBoolean("overlapping-ways.only-known-linear", true);
        this.ignoreLayer = Config.getPref().getBoolean("overlapping-ways.ignore-layer", false);
    }

    private static boolean parentMultipolygonConcernsArea(OsmPrimitive p) {
        return p.referrers(Relation.class).anyMatch(IRelation::isMultipolygon);
    }

    @Override
    public void endTest() {
        HashMap<List<Way>, Set<WaySegment>> seenWays = new HashMap<List<Way>, Set<WaySegment>>(500);
        for (Set<WaySegment> duplicated : this.nodePairs.values()) {
            if (duplicated.size() <= 1) continue;
            if (this.ignoreLayer) {
                this.analyseOverlaps(duplicated, seenWays);
                continue;
            }
            HashMap<String, Set> grouped = new HashMap<String, Set>();
            for (WaySegment ws : duplicated) {
                grouped.computeIfAbsent(OsmUtils.getLayer(ws.getWay()), k -> new LinkedHashSet()).add(ws);
            }
            grouped.values().forEach(group -> this.analyseOverlaps((Set<WaySegment>)group, (Map<List<Way>, Set<WaySegment>>)seenWays));
        }
        this.nodePairs = null;
        super.endTest();
    }

    private void analyseOverlaps(Set<WaySegment> duplicated, Map<List<Way>, Set<WaySegment>> seenWays) {
        int ways = duplicated.size();
        if (ways <= 1) {
            return;
        }
        List currentWays = duplicated.stream().map(ws -> (Way)ws.getWay()).collect(Collectors.toList());
        Collection highlight = seenWays.get(currentWays);
        if (highlight != null) {
            highlight.addAll(duplicated);
        } else {
            Severity severity;
            int type;
            String errortype;
            int countHighway = 0;
            int countRailway = 0;
            int countWaterway = 0;
            int countOther = 0;
            int numAreas = 0;
            for (WaySegment ws2 : duplicated) {
                boolean isArea = ((Way)ws2.getWay()).concernsArea();
                if (((Way)ws2.getWay()).hasKey("highway")) {
                    if (!isArea) {
                        ++countHighway;
                    }
                } else if (((Way)ws2.getWay()).hasKey("railway")) {
                    if (!isArea) {
                        ++countRailway;
                    }
                } else if (((Way)ws2.getWay()).hasKey("waterway")) {
                    if (!isArea) {
                        ++countWaterway;
                    }
                } else {
                    if (((Way)ws2.getWay()).getInterestingTags().isEmpty() && OverlappingWays.parentMultipolygonConcernsArea((OsmPrimitive)ws2.getWay())) {
                        isArea = true;
                    }
                    if (!isArea && OverlappingWays.isOtherLinear((Way)ws2.getWay())) {
                        ++countOther;
                    }
                }
                if (!isArea) continue;
                ++numAreas;
            }
            if (numAreas == ways) {
                return;
            }
            int allKnownLinear = countHighway + countRailway + countWaterway + countOther;
            if (countHighway > 1) {
                errortype = I18n.tr("Overlapping highways", new Object[0]);
                type = 101;
                severity = Severity.ERROR;
            } else if (countRailway > 1) {
                errortype = I18n.tr("Overlapping railways", new Object[0]);
                type = 102;
                severity = Severity.ERROR;
            } else if (countWaterway > 1) {
                errortype = I18n.tr("Overlapping waterways", new Object[0]);
                type = 104;
                severity = Severity.ERROR;
            } else if (countHighway > 0 && countHighway < allKnownLinear) {
                errortype = I18n.tr("Highway shares segment with linear way", new Object[0]);
                type = 131;
                severity = Severity.WARNING;
            } else if (countRailway > 0 && countRailway < allKnownLinear) {
                errortype = I18n.tr("Railway shares segment with linear way", new Object[0]);
                type = 131;
                severity = Severity.WARNING;
            } else if (countWaterway > 0 && countWaterway < allKnownLinear) {
                errortype = I18n.tr("Waterway shares segment with linear way", new Object[0]);
                type = 133;
                severity = Severity.WARNING;
            } else {
                if (!this.includeOther || this.onlyKnownLinear) {
                    return;
                }
                if (countHighway > 0) {
                    errortype = I18n.tr("Highway shares segment with other way", new Object[0]);
                    type = 111;
                    severity = Severity.OTHER;
                } else if (countRailway > 0) {
                    errortype = I18n.tr("Railway shares segment with other way", new Object[0]);
                    type = 112;
                    severity = Severity.OTHER;
                } else if (countWaterway > 0) {
                    errortype = I18n.tr("Waterway shares segment with other way", new Object[0]);
                    type = 114;
                    severity = Severity.OTHER;
                } else {
                    errortype = I18n.tr("Ways share segment", new Object[0]);
                    type = 103;
                    severity = Severity.OTHER;
                }
            }
            ArrayList prims = new ArrayList(currentWays);
            this.errors.add(TestError.builder(this, severity, type).message(errortype).primitives(prims).highlightWaySegments(duplicated).build());
            seenWays.put(currentWays, duplicated);
        }
    }

    private static boolean isOtherLinear(Way way) {
        return way.hasKey("barrier", "addr:interpolation", "route", "ford") || way.hasTag("natural", "tree_row", "cliff", "ridge") || way.hasTag("power", "line", "minor_line", "cable", "portal") || way.hasTag("man_made", "pipeline");
    }

    protected static Set<WaySegment> checkDuplicateWaySegment(Way w) {
        TreeSet<WaySegment> segments = new TreeSet<WaySegment>((o1, o2) -> {
            List<Node> n1 = Arrays.asList((Node)o1.getFirstNode(), (Node)o1.getSecondNode());
            List<Node> n2 = Arrays.asList((Node)o2.getFirstNode(), (Node)o2.getSecondNode());
            Collections.sort(n1);
            Collections.sort(n2);
            int first = n1.get(0).compareTo((IPrimitive)n2.get(0));
            int second = n1.get(1).compareTo((IPrimitive)n2.get(1));
            return first != 0 ? first : second;
        });
        HashSet<WaySegment> duplicateWaySegments = new HashSet<WaySegment>();
        for (int i = 0; i < w.getNodesCount() - 1; ++i) {
            boolean wasInSet;
            WaySegment segment = new WaySegment(w, i);
            boolean bl = wasInSet = !segments.add(segment);
            if (!wasInSet) continue;
            duplicateWaySegments.add(segment);
        }
        return duplicateWaySegments;
    }

    @Override
    public void visit(Way w) {
        Set<WaySegment> duplicateWaySegment = OverlappingWays.checkDuplicateWaySegment(w);
        if (!duplicateWaySegment.isEmpty()) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 121).message(I18n.tr("Way contains segment twice", new Object[0])).primitives(w).highlightWaySegments(duplicateWaySegment).build());
            return;
        }
        if (IGNORED.test(w)) {
            return;
        }
        if (this.onlyKnownLinear && (w.concernsArea() || w.getInterestingTags().isEmpty())) {
            return;
        }
        Node lastN = null;
        int i = -2;
        for (Node n : w.getNodes()) {
            ++i;
            if (lastN == null) {
                lastN = n;
                continue;
            }
            this.nodePairs.put(Pair.sort(new Pair<Node, Node>(lastN, n)), new WaySegment(w, i));
            lastN = n;
        }
    }
}

