/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.regexp;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.ClasspathUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.regexp.RegexpMatcher;

public class RegexpMatcherFactory {
    public RegexpMatcher newRegexpMatcher() throws BuildException {
        return this.newRegexpMatcher(null);
    }

    public RegexpMatcher newRegexpMatcher(Project p) throws BuildException {
        String systemDefault = null;
        systemDefault = p == null ? System.getProperty("ant.regexp.regexpimpl") : p.getProperty("ant.regexp.regexpimpl");
        if (systemDefault != null) {
            return this.createInstance(systemDefault);
        }
        Throwable cause = null;
        try {
            this.testAvailability("java.util.regex.Matcher");
            return this.createInstance("org.apache.tools.ant.util.regexp.Jdk14RegexpMatcher");
        }
        catch (BuildException be) {
            cause = RegexpMatcherFactory.orCause(cause, be, JavaEnvUtils.getJavaVersionNumber() < 14);
            try {
                this.testAvailability("org.apache.oro.text.regex.Pattern");
                return this.createInstance("org.apache.tools.ant.util.regexp.JakartaOroMatcher");
            }
            catch (BuildException be2) {
                cause = RegexpMatcherFactory.orCause(cause, be2, true);
                try {
                    this.testAvailability("org.apache.regexp.RE");
                    return this.createInstance("org.apache.tools.ant.util.regexp.JakartaRegexpMatcher");
                }
                catch (BuildException be3) {
                    cause = RegexpMatcherFactory.orCause(cause, be3, true);
                    throw new BuildException("No supported regular expression matcher found" + (cause != null ? ": " + cause : ""), cause);
                }
            }
        }
    }

    static Throwable orCause(Throwable deflt, BuildException be, boolean ignoreCnfe) {
        if (deflt != null) {
            return deflt;
        }
        Throwable t = be.getException();
        return ignoreCnfe && t instanceof ClassNotFoundException ? null : t;
    }

    protected RegexpMatcher createInstance(String className) throws BuildException {
        return (RegexpMatcher)ClasspathUtils.newInstance(className, RegexpMatcherFactory.class.getClassLoader(), RegexpMatcher.class);
    }

    protected void testAvailability(String className) throws BuildException {
        try {
            Class.forName(className);
        }
        catch (Throwable t) {
            throw new BuildException(t);
        }
    }

    public static boolean regexpMatcherPresent(Project project) {
        try {
            new RegexpMatcherFactory().newRegexpMatcher(project);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

