/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.util.FileUtils;

public class JavaResource
extends Resource {
    private Path classpath;
    private Reference loader;

    public JavaResource() {
    }

    public JavaResource(String name, Path path) {
        this.setName(name);
        this.classpath = path;
    }

    public void setClasspath(Path classpath) {
        this.checkAttributesAllowed();
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        this.checkChildrenAllowed();
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.checkAttributesAllowed();
        this.createClasspath().setRefid(r);
    }

    public Path getClasspath() {
        return this.isReference() ? ((JavaResource)this.getCheckedRef()).getClasspath() : this.classpath;
    }

    public void setLoaderRef(Reference r) {
        this.checkAttributesAllowed();
        this.loader = r;
    }

    public void setRefid(Reference r) {
        if (this.loader != null || this.classpath != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExists() {
        boolean bl;
        InputStream is = null;
        try {
            bl = this.isReference() ? ((Resource)this.getCheckedRef()).isExists() : (is = this.getInputStream()) != null;
        }
        catch (IOException ex) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileUtils.close(is);
                throw throwable;
            }
            FileUtils.close(is);
            return bl2;
        }
        FileUtils.close(is);
        return bl;
    }

    public InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        ClassLoader cl = null;
        if (this.loader != null) {
            cl = (ClassLoader)this.loader.getReferencedObject();
        }
        if (cl == null) {
            cl = this.getClasspath() != null ? this.getProject().createClassLoader(this.classpath) : JavaResource.class.getClassLoader();
            if (this.loader != null && cl != null) {
                this.getProject().addReference(this.loader.getRefId(), cl);
            }
        }
        return cl == null ? ClassLoader.getSystemResourceAsStream(this.getName()) : cl.getResourceAsStream(this.getName());
    }

    public int compareTo(Object another) {
        if (this.isReference()) {
            return ((Comparable)this.getCheckedRef()).compareTo(another);
        }
        if (another.getClass().equals(this.getClass())) {
            Path op;
            JavaResource otherjr = (JavaResource)another;
            if (!this.getName().equals(otherjr.getName())) {
                return this.getName().compareTo(otherjr.getName());
            }
            if (this.loader != otherjr.loader) {
                if (this.loader == null) {
                    return -1;
                }
                if (otherjr.loader == null) {
                    return 1;
                }
                return this.loader.getRefId().compareTo(otherjr.loader.getRefId());
            }
            Path p = this.getClasspath();
            if (p != (op = otherjr.getClasspath())) {
                if (p == null) {
                    return -1;
                }
                if (op == null) {
                    return 1;
                }
                return p.toString().compareTo(op.toString());
            }
            return 0;
        }
        return super.compareTo(another);
    }
}

