/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.util.StringUtils;

public class Parallel
extends Task
implements TaskContainer {
    private Vector nestedTasks = new Vector();
    private final Object semaphore = new Object();
    private int numThreads = 0;
    private int numThreadsPerProcessor = 0;
    private long timeout;
    private volatile boolean stillRunning;
    private boolean timedOut;
    private boolean failOnAny;
    private TaskList daemonTasks;
    private StringBuffer exceptionMessage;
    private int numExceptions = 0;
    private Throwable firstException;
    private Location firstLocation;

    public void addDaemons(TaskList daemonTasks) {
        if (this.daemonTasks != null) {
            throw new BuildException("Only one daemon group is supported");
        }
        this.daemonTasks = daemonTasks;
    }

    public void setPollInterval(int pollInterval) {
    }

    public void setFailOnAny(boolean failOnAny) {
        this.failOnAny = failOnAny;
    }

    public void addTask(Task nestedTask) {
        this.nestedTasks.addElement(nestedTask);
    }

    public void setThreadsPerProcessor(int numThreadsPerProcessor) {
        this.numThreadsPerProcessor = numThreadsPerProcessor;
    }

    public void setThreadCount(int numThreads) {
        this.numThreads = numThreads;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void execute() throws BuildException {
        this.updateThreadCounts();
        if (this.numThreads == 0) {
            this.numThreads = this.nestedTasks.size();
        }
        this.spinThreads();
    }

    private void updateThreadCounts() {
        int numProcessors;
        if (this.numThreadsPerProcessor != 0 && (numProcessors = this.getNumProcessors()) != 0) {
            this.numThreads = numProcessors * this.numThreadsPerProcessor;
        }
    }

    private void processExceptions(TaskRunnable[] runnables) {
        if (runnables == null) {
            return;
        }
        for (int i = 0; i < runnables.length; ++i) {
            Throwable t = runnables[i].getException();
            if (t == null) continue;
            ++this.numExceptions;
            if (this.firstException == null) {
                this.firstException = t;
            }
            if (t instanceof BuildException && this.firstLocation == Location.UNKNOWN_LOCATION) {
                this.firstLocation = ((BuildException)t).getLocation();
            }
            this.exceptionMessage.append(StringUtils.LINE_SEP);
            this.exceptionMessage.append(t.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spinThreads() throws BuildException {
        int numTasks = this.nestedTasks.size();
        TaskRunnable[] runnables = new TaskRunnable[numTasks];
        this.stillRunning = true;
        this.timedOut = false;
        int threadNumber = 0;
        Enumeration e = this.nestedTasks.elements();
        while (e.hasMoreElements()) {
            Task nestedTask = (Task)e.nextElement();
            runnables[threadNumber] = new TaskRunnable(nestedTask);
            ++threadNumber;
        }
        int maxRunning = numTasks < this.numThreads ? numTasks : this.numThreads;
        TaskRunnable[] running = new TaskRunnable[maxRunning];
        threadNumber = 0;
        ThreadGroup group = new ThreadGroup("parallel");
        TaskRunnable[] daemons = null;
        if (this.daemonTasks != null && this.daemonTasks.tasks.size() != 0) {
            daemons = new TaskRunnable[this.daemonTasks.tasks.size()];
        }
        Object object = this.semaphore;
        synchronized (object) {
        }
        object = this.semaphore;
        synchronized (object) {
            Thread thread;
            int i;
            if (daemons != null) {
                for (i = 0; i < daemons.length; ++i) {
                    daemons[i] = new TaskRunnable((Task)this.daemonTasks.tasks.get(i));
                    Thread daemonThread = new Thread(group, daemons[i]);
                    daemonThread.setDaemon(true);
                    daemonThread.start();
                }
            }
            for (i = 0; i < maxRunning; ++i) {
                running[i] = runnables[threadNumber++];
                thread = new Thread(group, running[i]);
                thread.start();
            }
            if (this.timeout != 0L) {
                Thread timeoutThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public synchronized void run() {
                        try {
                            this.wait(Parallel.this.timeout);
                            Object object = Parallel.this.semaphore;
                            synchronized (object) {
                                Parallel.this.stillRunning = false;
                                Parallel.this.timedOut = true;
                                Parallel.this.semaphore.notifyAll();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                };
                timeoutThread.start();
            }
            block13: while (threadNumber < numTasks && this.stillRunning) {
                for (int i2 = 0; i2 < maxRunning; ++i2) {
                    if (running[i2] != null && !running[i2].isFinished()) continue;
                    running[i2] = runnables[threadNumber++];
                    thread = new Thread(group, running[i2]);
                    thread.start();
                    continue block13;
                }
                try {
                    this.semaphore.wait();
                }
                catch (InterruptedException ie) {}
            }
            block15: while (this.stillRunning) {
                for (int i3 = 0; i3 < maxRunning; ++i3) {
                    if (running[i3] == null || running[i3].isFinished()) continue;
                    try {
                        this.semaphore.wait();
                    }
                    catch (InterruptedException ie) {}
                    continue block15;
                }
                this.stillRunning = false;
            }
        }
        if (this.timedOut) {
            throw new BuildException("Parallel execution timed out");
        }
        this.exceptionMessage = new StringBuffer();
        this.numExceptions = 0;
        this.firstException = null;
        this.firstLocation = Location.UNKNOWN_LOCATION;
        this.processExceptions(daemons);
        this.processExceptions(runnables);
        if (this.numExceptions == 1) {
            if (this.firstException instanceof BuildException) {
                throw (BuildException)this.firstException;
            }
            throw new BuildException(this.firstException);
        }
        if (this.numExceptions > 1) {
            throw new BuildException(this.exceptionMessage.toString(), this.firstLocation);
        }
    }

    private int getNumProcessors() {
        try {
            Class[] paramTypes = new Class[]{};
            Method availableProcessors = Runtime.class.getMethod("availableProcessors", paramTypes);
            Object[] args = new Object[]{};
            Integer ret = (Integer)availableProcessors.invoke((Object)Runtime.getRuntime(), args);
            return ret;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private class TaskRunnable
    implements Runnable {
        private Throwable exception;
        private Task task;
        private boolean finished;

        TaskRunnable(Task task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.task.perform();
            }
            catch (Throwable t) {
                this.exception = t;
                if (Parallel.this.failOnAny) {
                    Parallel.this.stillRunning = false;
                }
            }
            finally {
                Object object = Parallel.this.semaphore;
                synchronized (object) {
                    this.finished = true;
                    Parallel.this.semaphore.notifyAll();
                }
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        boolean isFinished() {
            return this.finished;
        }
    }

    public static class TaskList
    implements TaskContainer {
        private List tasks = new ArrayList();

        public void addTask(Task nestedTask) {
            this.tasks.add(nestedTask);
        }
    }
}

