/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.DynamicAttributeNS;
import org.apache.tools.ant.DynamicElement;
import org.apache.tools.ant.DynamicElementNS;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.UnsupportedAttributeException;
import org.apache.tools.ant.UnsupportedElementException;
import org.apache.tools.ant.taskdefs.PreSetDef;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.StringUtils;

public final class IntrospectionHelper {
    private static final Map HELPERS = new Hashtable();
    private static final Map PRIMITIVE_TYPE_MAP = new HashMap(8);
    private static final int MAX_REPORT_NESTED_TEXT = 20;
    private static final String ELLIPSIS = "...";
    private Hashtable attributeTypes = new Hashtable();
    private Hashtable attributeSetters = new Hashtable();
    private Hashtable nestedTypes = new Hashtable();
    private Hashtable nestedCreators = new Hashtable();
    private List addTypeMethods = new ArrayList();
    private Method addText = null;
    private Class bean;
    static /* synthetic */ Class class$org$apache$tools$ant$ProjectComponent;
    static /* synthetic */ Class class$org$apache$tools$ant$Task;

    private IntrospectionHelper(Class bean) {
        this.bean = bean;
        Method[] methods = bean.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String propName;
            Constructor<?> constructor;
            String propName2;
            Method m = methods[i];
            String name = m.getName();
            Class<?> returnType = m.getReturnType();
            Class<?>[] args = m.getParameterTypes();
            if (args.length == 1 && Void.TYPE.equals(returnType) && ("add".equals(name) || "addConfigured".equals(name))) {
                this.insertAddTypeMethod(m);
                continue;
            }
            if ((class$org$apache$tools$ant$ProjectComponent == null ? IntrospectionHelper.class$("org.apache.tools.ant.ProjectComponent") : class$org$apache$tools$ant$ProjectComponent).isAssignableFrom(bean) && args.length == 1 && this.isHiddenSetMethod(name, args[0]) || this.isContainer() && args.length == 1 && "addTask".equals(name) && (class$org$apache$tools$ant$Task == null ? IntrospectionHelper.class$("org.apache.tools.ant.Task") : class$org$apache$tools$ant$Task).equals(args[0])) continue;
            if ("addText".equals(name) && Void.TYPE.equals(returnType) && args.length == 1 && (class$java$lang$String == null ? IntrospectionHelper.class$("java.lang.String") : class$java$lang$String).equals(args[0])) {
                this.addText = methods[i];
                continue;
            }
            if (name.startsWith("set") && Void.TYPE.equals(returnType) && args.length == 1 && !args[0].isArray()) {
                AttributeSetter as;
                propName2 = IntrospectionHelper.getPropertyName(name, "set");
                if (this.attributeSetters.get(propName2) != null && (class$java$lang$String == null ? IntrospectionHelper.class$("java.lang.String") : class$java$lang$String).equals(args[0]) || (as = this.createAttributeSetter(m, args[0], propName2)) == null) continue;
                this.attributeTypes.put(propName2, args[0]);
                this.attributeSetters.put(propName2, as);
                continue;
            }
            if (name.startsWith("create") && !returnType.isArray() && !returnType.isPrimitive() && args.length == 0) {
                propName2 = IntrospectionHelper.getPropertyName(name, "create");
                if (this.nestedCreators.get(propName2) != null) continue;
                this.nestedTypes.put(propName2, returnType);
                this.nestedCreators.put(propName2, new CreateNestedCreator(m));
                continue;
            }
            if (name.startsWith("addConfigured") && Void.TYPE.equals(returnType) && args.length == 1 && !(class$java$lang$String == null ? IntrospectionHelper.class$("java.lang.String") : class$java$lang$String).equals(args[0]) && !args[0].isArray() && !args[0].isPrimitive()) {
                try {
                    constructor = null;
                    try {
                        constructor = args[0].getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException ex) {
                        constructor = args[0].getConstructor(class$org$apache$tools$ant$Project == null ? IntrospectionHelper.class$("org.apache.tools.ant.Project") : class$org$apache$tools$ant$Project);
                    }
                    propName = IntrospectionHelper.getPropertyName(name, "addConfigured");
                    this.nestedTypes.put(propName, args[0]);
                    this.nestedCreators.put(propName, new AddNestedCreator(m, constructor, 2));
                }
                catch (NoSuchMethodException nse) {}
                continue;
            }
            if (!name.startsWith("add") || !Void.TYPE.equals(returnType) || args.length != 1 || (class$java$lang$String == null ? IntrospectionHelper.class$("java.lang.String") : class$java$lang$String).equals(args[0]) || args[0].isArray() || args[0].isPrimitive()) continue;
            try {
                constructor = null;
                try {
                    constructor = args[0].getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    constructor = args[0].getConstructor(class$org$apache$tools$ant$Project == null ? IntrospectionHelper.class$("org.apache.tools.ant.Project") : class$org$apache$tools$ant$Project);
                }
                propName = IntrospectionHelper.getPropertyName(name, "add");
                if (this.nestedTypes.get(propName) != null) continue;
                this.nestedTypes.put(propName, args[0]);
                this.nestedCreators.put(propName, new AddNestedCreator(m, constructor, 1));
                continue;
            }
            catch (NoSuchMethodException nse) {
                // empty catch block
            }
        }
    }

    private boolean isHiddenSetMethod(String name, Class type) {
        if ("setLocation".equals(name) && Location.class.equals(type)) {
            return true;
        }
        return "setTaskType".equals(name) && String.class.equals(type);
    }

    public static synchronized IntrospectionHelper getHelper(Class c) {
        return IntrospectionHelper.getHelper(null, c);
    }

    public static IntrospectionHelper getHelper(Project p, Class c) {
        IntrospectionHelper ih = (IntrospectionHelper)HELPERS.get(c.getName());
        if (ih == null || ih.bean != c) {
            ih = new IntrospectionHelper(c);
            if (p != null) {
                HELPERS.put(c.getName(), ih);
            }
        }
        return ih;
    }

    public void setAttribute(Project p, Object element, String attributeName, String value) throws BuildException {
        AttributeSetter as = (AttributeSetter)this.attributeSetters.get(attributeName.toLowerCase(Locale.US));
        if (as == null) {
            if (element instanceof DynamicAttributeNS) {
                DynamicAttributeNS dc = (DynamicAttributeNS)element;
                String uriPlusPrefix = ProjectHelper.extractUriFromComponentName(attributeName);
                String uri = ProjectHelper.extractUriFromComponentName(uriPlusPrefix);
                String localName = ProjectHelper.extractNameFromComponentName(attributeName);
                String qName = "".equals(uri) ? localName : uri + ":" + localName;
                dc.setDynamicAttribute(uri, localName, qName, value);
                return;
            }
            if (element instanceof DynamicAttribute) {
                DynamicAttribute dc = (DynamicAttribute)element;
                dc.setDynamicAttribute(attributeName.toLowerCase(Locale.US), value);
                return;
            }
            if (attributeName.indexOf(58) != -1) {
                return;
            }
            String msg = this.getElementName(p, element) + " doesn't support the \"" + attributeName + "\" attribute.";
            throw new UnsupportedAttributeException(msg, attributeName);
        }
        try {
            as.set(p, element, value);
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InvocationTargetException ite) {
            throw IntrospectionHelper.extractBuildException(ite);
        }
    }

    public void addText(Project project, Object element, String text) throws BuildException {
        if (this.addText == null) {
            if ((text = text.trim()).length() == 0) {
                return;
            }
            throw new BuildException(project.getElementName(element) + " doesn't support nested text data (\"" + this.condenseText(text) + "\").");
        }
        try {
            this.addText.invoke(element, text);
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InvocationTargetException ite) {
            throw IntrospectionHelper.extractBuildException(ite);
        }
    }

    public void throwNotSupported(Project project, Object parent, String elementName) {
        String msg = project.getElementName(parent) + " doesn't support the nested \"" + elementName + "\" element.";
        throw new UnsupportedElementException(msg, elementName);
    }

    private NestedCreator getNestedCreator(Project project, String parentUri, Object parent, String elementName, UnknownElement child) throws BuildException {
        Object nestedElement;
        String qName;
        Object dc;
        Object nestedElement2;
        String uri = ProjectHelper.extractUriFromComponentName(elementName);
        String name = ProjectHelper.extractNameFromComponentName(elementName);
        if (uri.equals("antlib:org.apache.tools.ant")) {
            uri = "";
        }
        if (parentUri.equals("antlib:org.apache.tools.ant")) {
            parentUri = "";
        }
        NestedCreator nc = null;
        if (uri.equals(parentUri) || uri.length() == 0) {
            nc = (NestedCreator)this.nestedCreators.get(name.toLowerCase(Locale.US));
        }
        if (nc == null) {
            nc = this.createAddTypeCreator(project, parent, elementName);
        }
        if (nc == null && parent instanceof DynamicElementNS && (nestedElement2 = (dc = (DynamicElementNS)parent).createDynamicElement(child == null ? "" : child.getNamespace(), name, qName = child == null ? name : child.getQName())) != null) {
            nc = new NestedCreator(null){

                Object create(Project project, Object parent, Object ignore) {
                    return nestedElement2;
                }
            };
        }
        if (nc == null && parent instanceof DynamicElement && (nestedElement = (dc = (DynamicElement)parent).createDynamicElement(name.toLowerCase(Locale.US))) != null) {
            nc = new NestedCreator(null){

                Object create(Project project, Object parent, Object ignore) {
                    return nestedElement;
                }
            };
        }
        if (nc == null) {
            this.throwNotSupported(project, parent, elementName);
        }
        return nc;
    }

    public Object createElement(Project project, Object parent, String elementName) throws BuildException {
        NestedCreator nc = this.getNestedCreator(project, "", parent, elementName, null);
        try {
            Object nestedElement = nc.create(project, parent, null);
            if (project != null) {
                project.setProjectReference(nestedElement);
            }
            return nestedElement;
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InstantiationException ine) {
            throw new BuildException(ine);
        }
        catch (InvocationTargetException ite) {
            throw IntrospectionHelper.extractBuildException(ite);
        }
    }

    public Creator getElementCreator(Project project, String parentUri, Object parent, String elementName, UnknownElement ue) {
        NestedCreator nc = this.getNestedCreator(project, parentUri, parent, elementName, ue);
        return new Creator(project, parent, nc);
    }

    public boolean isDynamic() {
        return DynamicElement.class.isAssignableFrom(this.bean) || DynamicElementNS.class.isAssignableFrom(this.bean);
    }

    public boolean isContainer() {
        return TaskContainer.class.isAssignableFrom(this.bean);
    }

    public boolean supportsNestedElement(String elementName) {
        return this.supportsNestedElement("", elementName);
    }

    public boolean supportsNestedElement(String parentUri, String elementName) {
        if (this.isDynamic() || this.addTypeMethods.size() > 0) {
            return true;
        }
        String name = ProjectHelper.extractNameFromComponentName(elementName);
        if (!this.nestedCreators.containsKey(name.toLowerCase(Locale.US))) {
            return false;
        }
        String uri = ProjectHelper.extractUriFromComponentName(elementName);
        if (uri.equals("antlib:org.apache.tools.ant")) {
            uri = "";
        }
        if ("".equals(uri)) {
            return true;
        }
        if (parentUri.equals("antlib:org.apache.tools.ant")) {
            parentUri = "";
        }
        return uri.equals(parentUri);
    }

    public void storeElement(Project project, Object parent, Object child, String elementName) throws BuildException {
        if (elementName == null) {
            return;
        }
        NestedCreator ns = (NestedCreator)this.nestedCreators.get(elementName.toLowerCase(Locale.US));
        if (ns == null) {
            return;
        }
        try {
            ns.store(parent, child);
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InstantiationException ine) {
            throw new BuildException(ine);
        }
        catch (InvocationTargetException ite) {
            throw IntrospectionHelper.extractBuildException(ite);
        }
    }

    private static BuildException extractBuildException(InvocationTargetException ite) {
        Throwable t = ite.getTargetException();
        if (t instanceof BuildException) {
            return (BuildException)t;
        }
        return new BuildException(t);
    }

    public Class getElementType(String elementName) throws BuildException {
        Class nt = (Class)this.nestedTypes.get(elementName);
        if (nt == null) {
            throw new UnsupportedElementException("Class " + this.bean.getName() + " doesn't support the nested \"" + elementName + "\" element.", elementName);
        }
        return nt;
    }

    public Class getAttributeType(String attributeName) throws BuildException {
        Class at = (Class)this.attributeTypes.get(attributeName);
        if (at == null) {
            throw new UnsupportedAttributeException("Class " + this.bean.getName() + " doesn't support the \"" + attributeName + "\" attribute.", attributeName);
        }
        return at;
    }

    public Method getAddTextMethod() throws BuildException {
        if (!this.supportsCharacters()) {
            throw new BuildException("Class " + this.bean.getName() + " doesn't support nested text data.");
        }
        return this.addText;
    }

    public Method getElementMethod(String elementName) throws BuildException {
        Object creator = this.nestedCreators.get(elementName);
        if (creator == null) {
            throw new UnsupportedElementException("Class " + this.bean.getName() + " doesn't support the nested \"" + elementName + "\" element.", elementName);
        }
        return ((NestedCreator)creator).method;
    }

    public Method getAttributeMethod(String attributeName) throws BuildException {
        Object setter = this.attributeSetters.get(attributeName);
        if (setter == null) {
            throw new UnsupportedAttributeException("Class " + this.bean.getName() + " doesn't support the \"" + attributeName + "\" attribute.", attributeName);
        }
        return ((AttributeSetter)setter).method;
    }

    public boolean supportsCharacters() {
        return this.addText != null;
    }

    public Enumeration getAttributes() {
        return this.attributeSetters.keys();
    }

    public Map getAttributeMap() {
        return this.attributeTypes.isEmpty() ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this.attributeTypes);
    }

    public Enumeration getNestedElements() {
        return this.nestedTypes.keys();
    }

    public Map getNestedElementMap() {
        return this.nestedTypes.isEmpty() ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this.nestedTypes);
    }

    public List getExtensionPoints() {
        return this.addTypeMethods.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.addTypeMethods);
    }

    private AttributeSetter createAttributeSetter(final Method m, Class arg, final String attrName) {
        boolean includeProject;
        Constructor c;
        Class reflectedArg;
        if (String.class.equals(reflectedArg = PRIMITIVE_TYPE_MAP.containsKey(arg) ? (Class)PRIMITIVE_TYPE_MAP.get(arg) : arg)) {
            return new AttributeSetter(m){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new String[]{value});
                }
            };
        }
        if (Character.class.equals(reflectedArg)) {
            return new AttributeSetter(m){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    if (value.length() == 0) {
                        throw new BuildException("The value \"\" is not a legal value for attribute \"" + attrName + "\"");
                    }
                    m.invoke(parent, (Object[])new Character[]{new Character(value.charAt(0))});
                }
            };
        }
        if (Boolean.class.equals(reflectedArg)) {
            return new AttributeSetter(m){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new Boolean[]{Project.toBoolean(value) ? Boolean.TRUE : Boolean.FALSE});
                }
            };
        }
        if (Class.class.equals(reflectedArg)) {
            return new AttributeSetter(m){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        m.invoke(parent, Class.forName(value));
                    }
                    catch (ClassNotFoundException ce) {
                        throw new BuildException(ce);
                    }
                }
            };
        }
        if (File.class.equals(reflectedArg)) {
            return new AttributeSetter(m){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, p.resolveFile(value));
                }
            };
        }
        if (EnumeratedAttribute.class.isAssignableFrom(reflectedArg)) {
            return new AttributeSetter(m){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        EnumeratedAttribute ea = (EnumeratedAttribute)reflectedArg.newInstance();
                        ea.setValue(value);
                        m.invoke(parent, ea);
                    }
                    catch (InstantiationException ie) {
                        throw new BuildException(ie);
                    }
                }
            };
        }
        Class<?> enumClass = null;
        try {
            enumClass = Class.forName("java.lang.Enum");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (enumClass != null && enumClass.isAssignableFrom(reflectedArg)) {
            return new AttributeSetter(m){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        m.invoke(parent, reflectedArg.getMethod("valueOf", class$java$lang$String == null ? (class$java$lang$String = IntrospectionHelper.class$("java.lang.String")) : class$java$lang$String).invoke(null, value));
                    }
                    catch (InvocationTargetException x) {
                        if (x.getTargetException() instanceof IllegalArgumentException) {
                            throw new BuildException("'" + value + "' is not a permitted value for " + reflectedArg.getName());
                        }
                        throw IntrospectionHelper.extractBuildException(x);
                    }
                    catch (Exception x) {
                        throw new BuildException(x);
                    }
                }
            };
        }
        if (Long.class.equals(reflectedArg)) {
            return new AttributeSetter(m){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        m.invoke(parent, new Long(StringUtils.parseHumanSizes(value)));
                    }
                    catch (InvocationTargetException e) {
                        throw e;
                    }
                    catch (IllegalAccessException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new BuildException(e);
                    }
                }
            };
        }
        try {
            c = reflectedArg.getConstructor(Project.class, String.class);
            includeProject = true;
        }
        catch (NoSuchMethodException nme) {
            try {
                c = reflectedArg.getConstructor(String.class);
                includeProject = false;
            }
            catch (NoSuchMethodException nme2) {
                return null;
            }
        }
        final boolean finalIncludeProject = includeProject;
        final Constructor finalConstructor = c;
        return new AttributeSetter(m){

            public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                try {
                    Object[] objectArray;
                    if (finalIncludeProject) {
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = p;
                        objectArray = objectArray2;
                        objectArray2[1] = value;
                    } else {
                        Object[] objectArray3 = new Object[1];
                        objectArray = objectArray3;
                        objectArray3[0] = value;
                    }
                    Object[] args = objectArray;
                    Object attribute = finalConstructor.newInstance(args);
                    if (p != null) {
                        p.setProjectReference(attribute);
                    }
                    m.invoke(parent, attribute);
                }
                catch (InstantiationException ie) {
                    throw new BuildException(ie);
                }
            }
        };
    }

    private String getElementName(Project project, Object element) {
        return project.getElementName(element);
    }

    private static String getPropertyName(String methodName, String prefix) {
        return methodName.substring(prefix.length()).toLowerCase(Locale.US);
    }

    public static void clearCache() {
        HELPERS.clear();
    }

    private NestedCreator createAddTypeCreator(Project project, Object parent, String elementName) throws BuildException {
        if (this.addTypeMethods.size() == 0) {
            return null;
        }
        ComponentHelper helper = ComponentHelper.getComponentHelper(project);
        Object addedObject = null;
        Method addMethod = null;
        Class clazz = helper.getComponentClass(elementName);
        if (clazz == null) {
            return null;
        }
        addMethod = this.findMatchingMethod(clazz, this.addTypeMethods);
        if (addMethod == null) {
            return null;
        }
        addedObject = helper.createComponent(elementName);
        if (addedObject == null) {
            return null;
        }
        Object rObject = addedObject;
        if (addedObject instanceof PreSetDef.PreSetDefinition) {
            rObject = ((PreSetDef.PreSetDefinition)addedObject).createObject(project);
        }
        final Object nestedObject = addedObject;
        final Object realObject = rObject;
        return new NestedCreator(addMethod){

            Object create(Project project, Object parent, Object ignore) throws InvocationTargetException, IllegalAccessException {
                if (!this.getMethod().getName().endsWith("Configured")) {
                    this.getMethod().invoke(parent, realObject);
                }
                return nestedObject;
            }

            Object getRealObject() {
                return realObject;
            }

            void store(Object parent, Object child) throws InvocationTargetException, IllegalAccessException, InstantiationException {
                if (this.getMethod().getName().endsWith("Configured")) {
                    this.getMethod().invoke(parent, realObject);
                }
            }
        };
    }

    private void insertAddTypeMethod(Method method) {
        Class<?> argClass = method.getParameterTypes()[0];
        for (int c = 0; c < this.addTypeMethods.size(); ++c) {
            Method current = (Method)this.addTypeMethods.get(c);
            if (current.getParameterTypes()[0].equals(argClass)) {
                if (method.getName().equals("addConfigured")) {
                    this.addTypeMethods.set(c, method);
                }
                return;
            }
            if (!current.getParameterTypes()[0].isAssignableFrom(argClass)) continue;
            this.addTypeMethods.add(c, method);
            return;
        }
        this.addTypeMethods.add(method);
    }

    private Method findMatchingMethod(Class paramClass, List methods) {
        Class<?> matchedClass = null;
        Method matchedMethod = null;
        for (int i = 0; i < methods.size(); ++i) {
            Method method = (Method)methods.get(i);
            Class<?> methodClass = method.getParameterTypes()[0];
            if (!methodClass.isAssignableFrom(paramClass)) continue;
            if (matchedClass == null) {
                matchedClass = methodClass;
                matchedMethod = method;
                continue;
            }
            if (methodClass.isAssignableFrom(matchedClass)) continue;
            throw new BuildException("ambiguous: types " + matchedClass.getName() + " and " + methodClass.getName() + " match " + paramClass.getName());
        }
        return matchedMethod;
    }

    private String condenseText(String text) {
        if (text.length() <= 20) {
            return text;
        }
        int ends = (20 - ELLIPSIS.length()) / 2;
        return new StringBuffer(text).replace(ends, text.length() - ends, ELLIPSIS).toString();
    }

    static {
        Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        Class[] wrappers = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class};
        for (int i = 0; i < primitives.length; ++i) {
            PRIMITIVE_TYPE_MAP.put(primitives[i], wrappers[i]);
        }
    }

    private static abstract class AttributeSetter {
        private Method method;

        protected AttributeSetter(Method m) {
            this.method = m;
        }

        abstract void set(Project var1, Object var2, String var3) throws InvocationTargetException, IllegalAccessException, BuildException;
    }

    private static class AddNestedCreator
    extends NestedCreator {
        static final int ADD = 1;
        static final int ADD_CONFIGURED = 2;
        private Constructor constructor;
        private int behavior;

        AddNestedCreator(Method m, Constructor c, int behavior) {
            super(m);
            this.constructor = c;
            this.behavior = behavior;
        }

        boolean isPolyMorphic() {
            return true;
        }

        Object create(Project project, Object parent, Object child) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            if (child == null) {
                Object[] objectArray;
                if (this.constructor.getParameterTypes().length == 0) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = project;
                }
                child = this.constructor.newInstance(objectArray);
            }
            if (child instanceof PreSetDef.PreSetDefinition) {
                child = ((PreSetDef.PreSetDefinition)child).createObject(project);
            }
            if (this.behavior == 1) {
                this.istore(parent, child);
            }
            return child;
        }

        void store(Object parent, Object child) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            if (this.behavior == 2) {
                this.istore(parent, child);
            }
        }

        private void istore(Object parent, Object child) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            this.getMethod().invoke(parent, child);
        }
    }

    private static class CreateNestedCreator
    extends NestedCreator {
        CreateNestedCreator(Method m) {
            super(m);
        }

        Object create(Project project, Object parent, Object ignore) throws InvocationTargetException, IllegalAccessException {
            return this.getMethod().invoke(parent, new Object[0]);
        }
    }

    private static abstract class NestedCreator {
        private Method method;

        protected NestedCreator(Method m) {
            this.method = m;
        }

        Method getMethod() {
            return this.method;
        }

        boolean isPolyMorphic() {
            return false;
        }

        Object getRealObject() {
            return null;
        }

        abstract Object create(Project var1, Object var2, Object var3) throws InvocationTargetException, IllegalAccessException, InstantiationException;

        void store(Object parent, Object child) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        }
    }

    public static final class Creator {
        private NestedCreator nestedCreator;
        private Object parent;
        private Project project;
        private Object nestedObject;
        private String polyType;

        private Creator(Project project, Object parent, NestedCreator nestedCreator) {
            this.project = project;
            this.parent = parent;
            this.nestedCreator = nestedCreator;
        }

        public void setPolyType(String polyType) {
            this.polyType = polyType;
        }

        public Object create() {
            if (this.polyType != null) {
                if (!this.nestedCreator.isPolyMorphic()) {
                    throw new BuildException("Not allowed to use the polymorphic form for this element");
                }
                ComponentHelper helper = ComponentHelper.getComponentHelper(this.project);
                this.nestedObject = helper.createComponent(this.polyType);
                if (this.nestedObject == null) {
                    throw new BuildException("Unable to create object of type " + this.polyType);
                }
            }
            try {
                this.nestedObject = this.nestedCreator.create(this.project, this.parent, this.nestedObject);
                if (this.project != null) {
                    this.project.setProjectReference(this.nestedObject);
                }
                return this.nestedObject;
            }
            catch (IllegalAccessException ex) {
                throw new BuildException(ex);
            }
            catch (InstantiationException ex) {
                throw new BuildException(ex);
            }
            catch (IllegalArgumentException ex) {
                if (this.polyType == null) {
                    throw ex;
                }
                throw new BuildException("Invalid type used " + this.polyType);
            }
            catch (InvocationTargetException ex) {
                throw IntrospectionHelper.extractBuildException(ex);
            }
        }

        public Object getRealObject() {
            return this.nestedCreator.getRealObject();
        }

        public void store() {
            try {
                this.nestedCreator.store(this.parent, this.nestedObject);
            }
            catch (IllegalAccessException ex) {
                throw new BuildException(ex);
            }
            catch (InstantiationException ex) {
                throw new BuildException(ex);
            }
            catch (IllegalArgumentException ex) {
                if (this.polyType == null) {
                    throw ex;
                }
                throw new BuildException("Invalid type used " + this.polyType);
            }
            catch (InvocationTargetException ex) {
                throw IntrospectionHelper.extractBuildException(ex);
            }
        }
    }
}

