/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;

public class OrthogonalRepresentation<N, E> {
    private Map<Face, OrthogonalShape> shapes = new LinkedHashMap<Face, OrthogonalShape>();
    private EmbeddedPlanarGraph<N, E> originalGraph;
    private MGraph.Vertex<N> cornerVertex;

    public static <N, E> OrthogonalRepresentation<N, E> createGraph(EmbeddedPlanarGraph<N, E> embeddedPlanarGraph) {
        return new OrthogonalRepresentation<N, E>(embeddedPlanarGraph);
    }

    private OrthogonalRepresentation(EmbeddedPlanarGraph<N, E> embeddedPlanarGraph) {
        this.originalGraph = embeddedPlanarGraph;
    }

    public EmbeddedPlanarGraph<N, E> getOriginalGraph() {
        return this.originalGraph;
    }

    public OrthogonalShape getShape(Face face) {
        OrthogonalShape orthogonalShape = this.shapes.get(face);
        if (orthogonalShape == null) {
            orthogonalShape = new OrthogonalShape(face);
            this.shapes.put(face, orthogonalShape);
        }
        return orthogonalShape;
    }

    public Collection<OrthogonalShape> getShapes() {
        return this.shapes.values();
    }

    public void setCornerVertex(MGraph.Vertex<N> vertex) {
        this.cornerVertex = vertex;
    }

    public MGraph.Vertex<N> getCornerVertex() {
        return this.cornerVertex;
    }

    public String toString() {
        String string = "Orthogonal Representation:\n";
        for (OrthogonalShape orthogonalShape : this.shapes.values()) {
            string = string + orthogonalShape;
        }
        return string;
    }

    public static class Tuple {
        private Face.Dart dart;
        private BitSet bends;
        private int angles;

        public Tuple(Face.Dart dart) {
            this.dart = dart;
            this.bends = new BitSet();
        }

        public Face.Dart getDart() {
            return this.dart;
        }

        public BitSet getBends() {
            return this.bends;
        }

        public int getNumberOfBends() {
            int n = this.bends.length();
            if (n > 0) {
                --n;
            }
            return n;
        }

        public int getAngles() {
            return this.angles;
        }

        public void setAngles(int n) {
            if (n == 0) {
                new Exception().printStackTrace();
            }
            this.angles = n;
        }

        public String toString() {
            String string = "Tuple:\n";
            string = string + this.dart + "\n";
            string = string + "angles = " + this.angles + "\n";
            string = string + "bends = " + this.bends + "\n";
            string = string + "# of bends = " + this.getNumberOfBends() + "\n";
            string = string + "direction = " + (Object)((Object)this.dart.getEdge().getDirection()) + "\n";
            return string;
        }
    }

    public static class OrthogonalShape {
        private Map<Face.Dart, Tuple> tupleMap;
        private Face face;

        OrthogonalShape(Face face) {
            this.face = face;
            this.tupleMap = new LinkedHashMap<Face.Dart, Tuple>();
            for (Face.Dart dart : face.getDarts()) {
                Tuple tuple = new Tuple(dart);
                this.tupleMap.put(dart, tuple);
            }
        }

        public Face getFace() {
            return this.face;
        }

        public Tuple getTuple(Face.Dart dart) {
            return this.tupleMap.get(dart);
        }

        public void updateTuple(Tuple tuple, Collection<MGraph.Edge<?>> collection) {
            Object object;
            Face.Dart dart = tuple.getDart();
            MGraph.Edge<?> edge = dart.getEdge();
            List<Face.Dart> list = this.face.replaceDart(dart, collection);
            this.tupleMap.remove(dart);
            BitSet bitSet = tuple.getBends();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                object = list.get(i);
                Tuple tuple2 = new Tuple((Face.Dart)object);
                this.tupleMap.put((Face.Dart)object, tuple2);
                if (i == 0) {
                    tuple2.setAngles(tuple.getAngles());
                    continue;
                }
                if (bitSet.length() > 0) {
                    boolean bl = bitSet.get(i - 1);
                    if (bl) {
                        tuple2.setAngles(3);
                        continue;
                    }
                    tuple2.setAngles(1);
                    continue;
                }
                tuple2.setAngles(2);
            }
            Face.Dart dart2 = this.face.getDart(edge);
            if (dart2 != null) {
                object = this.getTuple(dart2);
                this.updateTuple((Tuple)object, collection);
            }
        }

        public void insertEdge(MGraph.Edge<?> edge) {
            List<Face.Dart> list = this.face.replaceDarts(edge);
            if (list.isEmpty()) {
                return;
            }
            for (Face.Dart object2 : list) {
                this.tupleMap.remove(object2);
            }
            Face.Dart dart = this.face.getDart(edge);
            Tuple tuple = new Tuple(dart);
            this.tupleMap.put(dart, tuple);
            tuple.setAngles(1);
            Face.Dart dart2 = this.face.getNextDart(dart);
            Tuple tuple2 = this.getTuple(dart2);
            tuple2.setAngles(2);
        }

        public String toString() {
            String string = "Shape:\n";
            string = string + this.face;
            return string;
        }
    }
}

