/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.htmlui;

import java.net.URL;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.netbeans.api.htmlui.HTMLDialog;
import org.netbeans.modules.htmlui.ContextAccessor;
import org.openide.util.Lookup;

public interface HTMLViewerSpi<HtmlView, HtmlButton> {
    public HtmlView newView(Context var1);

    public <C> C component(HtmlView var1, Class<C> var2);

    public HtmlButton createButton(HtmlView var1, String var2);

    public String getId(HtmlView var1, HtmlButton var2);

    public void setText(HtmlView var1, HtmlButton var2, String var3);

    public void setEnabled(HtmlView var1, HtmlButton var2, boolean var3);

    public void runLater(HtmlView var1, Runnable var2);

    public static final class Context {
        private final ClassLoader loader;
        private final URL url;
        private final String[] techIds;
        private final HTMLDialog.OnSubmit onSubmit;
        private final Consumer<String> lifeCycleCallback;
        private final Callable<Lookup> onPageLoad;
        private final Class<?> component;

        private Context(ClassLoader classLoader, URL uRL, String[] stringArray, HTMLDialog.OnSubmit onSubmit, Consumer<String> consumer, Callable<Lookup> callable, Class<?> clazz) {
            this.loader = classLoader;
            this.url = uRL;
            this.techIds = stringArray;
            this.onSubmit = onSubmit;
            this.lifeCycleCallback = consumer;
            this.onPageLoad = callable;
            this.component = clazz;
        }

        public boolean isWindow() {
            return this.component == null && this.lifeCycleCallback == null;
        }

        public boolean isDialog() {
            return this.component == null && this.lifeCycleCallback != null;
        }

        public boolean isBlocking() {
            return this.isDialog() && this.onSubmit == null;
        }

        public boolean onSubmit(String string) {
            if (this.onSubmit != null && string != null && !this.onSubmit.onSubmit(string)) {
                return false;
            }
            if (this.lifeCycleCallback != null) {
                this.lifeCycleCallback.accept(string);
            }
            return true;
        }

        public Lookup onPageLoad() {
            if (this.onPageLoad != null) {
                try {
                    return this.onPageLoad.call();
                }
                catch (Exception exception) {
                    throw Context.raise(RuntimeException.class, exception);
                }
            }
            return null;
        }

        public URL getPage() {
            return this.url;
        }

        public ClassLoader getClassLoader() {
            return this.loader;
        }

        public String[] getTechIds() {
            return (String[])this.techIds.clone();
        }

        private static <T extends Exception> T raise(Class<T> clazz, Exception exception) throws T {
            throw exception;
        }

        static {
            new ContextAccessor(){

                @Override
                public Context newContext(ClassLoader classLoader, URL uRL, String[] stringArray, HTMLDialog.OnSubmit onSubmit, Consumer<String> consumer, Callable<Lookup> callable, Class<?> clazz) {
                    return new Context(classLoader, uRL, stringArray, onSubmit, consumer, callable, clazz);
                }
            };
        }
    }
}

