/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.htmlui;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.netbeans.api.htmlui.HTMLComponent;
import org.netbeans.api.htmlui.HTMLDialog;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGenerationException;

public class HTMLDialogProcessor
extends AbstractProcessor
implements Comparator<ExecutableElement> {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(HTMLDialog.class.getCanonicalName());
        hashSet.add(HTMLComponent.class.getCanonicalName());
        return hashSet;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private Set<Element> annotatedWith(RoundEnvironment roundEnvironment, Class<? extends Annotation> clazz) {
        HashSet<Element> hashSet = new HashSet<Element>();
        HTMLDialogProcessor.findAllElements(roundEnvironment.getElementsAnnotatedWith(clazz), hashSet, clazz);
        return hashSet;
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Element element;
        Object object;
        Set<ExecutableElement> set2;
        Object object2;
        Object object3;
        TreeMap<Object, Set<ExecutableElement>> treeMap = new TreeMap<Object, Set<ExecutableElement>>();
        for (Element object4 : this.annotatedWith(roundEnvironment, HTMLDialog.class)) {
            object3 = object4.getAnnotation(HTMLDialog.class);
            if (object3 == null || object4.getKind() != ElementKind.METHOD) continue;
            object2 = (ExecutableElement)object4;
            if (!object4.getModifiers().contains((Object)Modifier.STATIC)) {
                this.error("Method annotated by @HTMLDialog needs to be static", object4);
            }
            if (object4.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.error("Method annotated by @HTMLDialog cannot be private", object4);
            }
            if (!object2.getThrownTypes().isEmpty()) {
                this.error("Method annotated by @HTMLDialog cannot throw exceptions", object4);
            }
            if ((set2 = (Set)treeMap.get(object = (element = HTMLDialogProcessor.findPkg((Element)object2)).getQualifiedName() + "." + object3.className())) == null) {
                set2 = new TreeSet<ExecutableElement>(this);
                treeMap.put(object, set2);
            }
            set2.add((ExecutableElement)object2);
        }
        for (Element element2 : this.annotatedWith(roundEnvironment, HTMLComponent.class)) {
            object3 = element2.getAnnotation(HTMLComponent.class);
            if (object3 == null || element2.getKind() != ElementKind.METHOD) continue;
            object2 = (ExecutableElement)element2;
            if (!element2.getModifiers().contains((Object)Modifier.STATIC)) {
                this.error("Method annotated by @HTMLComponent needs to be static", element2);
            }
            if (element2.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.error("Method annotated by @HTMLComponent cannot be private", element2);
            }
            if (!object2.getThrownTypes().isEmpty()) {
                this.error("Method annotated by @HTMLComponent cannot throw exceptions", element2);
            }
            if ((set2 = (Set)treeMap.get(object = (element = HTMLDialogProcessor.findPkg((Element)object2)).getQualifiedName() + "." + object3.className())) == null) {
                set2 = new TreeSet<ExecutableElement>(this);
                treeMap.put(object, set2);
            }
            set2.add((ExecutableElement)object2);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            object3 = (String)entry.getKey();
            object2 = (Set)entry.getValue();
            element = (Element)object2.iterator().next();
            try {
                object = this.processingEnv.getFiler().createSourceFile((CharSequence)object3, object2.toArray(new Element[0]));
                set2 = object.openWriter();
                String[] stringArray = this.splitPkg((String)object3, element);
                ((Writer)((Object)set2)).append("package ").append(stringArray[0]).append(";\n");
                ((Writer)((Object)set2)).append("\n");
                ((Writer)((Object)set2)).append("import org.netbeans.api.htmlui.HTMLDialog.Builder;\n");
                ((Writer)((Object)set2)).append("class ").append(stringArray[1]).append(" {\n");
                ((Writer)((Object)set2)).append("  private ").append(stringArray[1]).append("() {\n  }\n");
                ((Writer)((Object)set2)).append("\n");
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    String string;
                    String string2;
                    ExecutableElement executableElement = (ExecutableElement)iterator.next();
                    HTMLDialog hTMLDialog = executableElement.getAnnotation(HTMLDialog.class);
                    HTMLComponent hTMLComponent = executableElement.getAnnotation(HTMLComponent.class);
                    if (hTMLDialog != null) {
                        string2 = this.findURL(hTMLDialog.url(), executableElement);
                        if (string2 == null) continue;
                        this.generateDialog((Writer)((Object)set2), executableElement, string2, hTMLDialog.techIds());
                    }
                    if (hTMLComponent == null || (string2 = this.findURL(hTMLComponent.url(), executableElement)) == null) continue;
                    try {
                        string = hTMLComponent.type().getName();
                    }
                    catch (MirroredTypeException mirroredTypeException) {
                        string = mirroredTypeException.getTypeMirror().toString();
                    }
                    if (!string.equals("javafx.scene.Node") && !string.equals("javax.swing.JComponent")) {
                        this.error("type() can be either Node.class or JComponent.class", executableElement);
                    }
                    this.generateComponent((Writer)((Object)set2), executableElement, string, string2, hTMLComponent.techIds());
                }
                ((Writer)((Object)set2)).append("}\n");
                ((Writer)((Object)set2)).close();
            }
            catch (IOException iOException) {
                this.error("Cannot create " + (String)object3, element);
            }
        }
        return true;
    }

    private String findURL(String string, ExecutableElement executableElement) {
        String string2;
        try {
            URL uRL = new URL(string);
            string2 = uRL.toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            try {
                String string3 = LayerBuilder.absolutizeResource((Element)executableElement, (String)string);
                this.validateResource(string3, executableElement, null, null, false);
                string2 = "nbresloc:/" + string3;
            }
            catch (LayerGenerationException layerGenerationException) {
                this.error("Cannot find resource " + string, executableElement);
                string2 = null;
            }
        }
        return string2;
    }

    private void generateDialog(Writer writer, ExecutableElement executableElement, String string, String[] stringArray) throws IOException {
        boolean bl;
        TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(HTMLDialog.OnSubmit.class.getCanonicalName());
        TypeMirror typeMirror = executableElement.getReturnType();
        boolean bl2 = bl = typeMirror.getKind() != TypeKind.ERROR && this.processingEnv.getTypeUtils().isSubtype(typeMirror, typeElement.asType());
        if (!bl) {
            this.warning("Rather modify the method to return HTMLDialog.OnSubmit callback!", executableElement);
        }
        writer.append("  public static ");
        if (bl) {
            writer.append("void ");
        } else {
            writer.append("String ");
        }
        writer.append(executableElement.getSimpleName());
        writer.append("(");
        String string2 = "";
        for (VariableElement variableElement : executableElement.getParameters()) {
            writer.append(string2);
            writer.append("final ").append(variableElement.asType().toString()).append(" ").append(variableElement.getSimpleName());
            string2 = ", ";
        }
        writer.append(") {\n");
        writer.append("    class DialogImpl implements Runnable");
        if (bl) {
            writer.append(", org.netbeans.api.htmlui.HTMLDialog.OnSubmit {\n");
            writer.append("        private volatile org.netbeans.api.htmlui.HTMLDialog.OnSubmit delegate;\n");
            writer.append("\n");
            writer.append("        @Override\n");
            writer.append("        public boolean onSubmit(String id) {\n");
            writer.append("          return delegate == null || delegate.onSubmit(id);\n");
            writer.append("        }\n");
        } else {
            writer.append(" {\n");
        }
        writer.append("        @Override\n");
        writer.append("        public void run() {\n");
        writer.append("          ");
        if (bl) {
            writer.append("delegate = ");
        }
        writer.append(executableElement.getEnclosingElement().getSimpleName()).append(".").append(executableElement.getSimpleName()).append("(");
        string2 = "";
        for (VariableElement variableElement : executableElement.getParameters()) {
            writer.append(string2);
            writer.append(variableElement.getSimpleName());
            string2 = ", ";
        }
        writer.append(");\n");
        writer.append("        }\n");
        writer.append("    }\n");
        writer.append("    DialogImpl impl = new DialogImpl();\n");
        if (bl) {
            writer.append("    ");
        } else {
            writer.append("    return ");
        }
        writer.append("Builder.newDialog(\"").append(string).append("\").\n");
        this.generateTechIds(writer, stringArray);
        writer.append("      loadFinished(impl).\n");
        if (bl) {
            writer.append("      show(impl);\n");
        } else {
            writer.append("      showAndWait();\n");
        }
        writer.append("  }\n");
    }

    private void generateComponent(Writer writer, ExecutableElement executableElement, String string, String string2, String[] stringArray) throws IOException {
        writer.append("  public static ").append(string).append(" ").append(executableElement.getSimpleName());
        writer.append("(");
        String string3 = "";
        for (VariableElement variableElement : executableElement.getParameters()) {
            writer.append(string3);
            writer.append("final ").append(variableElement.asType().toString()).append(" ").append(variableElement.getSimpleName());
            string3 = ", ";
        }
        writer.append(") {\n");
        writer.append("    return Builder.newDialog(\"").append(string2).append("\").\n");
        this.generateTechIds(writer, stringArray);
        writer.append("      loadFinished(new Runnable() {\n");
        writer.append("        public void run() {\n");
        writer.append("          ").append(executableElement.getEnclosingElement().getSimpleName()).append(".").append(executableElement.getSimpleName()).append("(");
        string3 = "";
        for (VariableElement variableElement : executableElement.getParameters()) {
            writer.append(string3);
            writer.append(variableElement.getSimpleName());
            string3 = ", ";
        }
        writer.append(");\n");
        writer.append("        }\n");
        writer.append("      }).\n");
        writer.append("      component(").append(string).append(".class);\n");
        writer.append("  }\n");
    }

    private void error(String string, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, string, element);
    }

    private void warning(String string, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, string, element);
    }

    private static PackageElement findPkg(Element element) {
        while (element.getKind() != ElementKind.PACKAGE) {
            element = element.getEnclosingElement();
        }
        return (PackageElement)element;
    }

    private String[] splitPkg(String string, Element element) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            this.error("Cannot generate " + string + " into default package!", element);
            return new String[]{"x", string};
        }
        return new String[]{string.substring(0, n), string.substring(n + 1)};
    }

    @Override
    public int compare(ExecutableElement executableElement, ExecutableElement executableElement2) {
        int n;
        if (executableElement == executableElement2) {
            return 0;
        }
        int n2 = executableElement.getSimpleName().toString().compareTo(executableElement2.getSimpleName().toString());
        if (n2 != 0) {
            return n2;
        }
        n2 = executableElement.getEnclosingElement().getSimpleName().toString().compareTo(executableElement2.getEnclosingElement().getSimpleName().toString());
        if (n2 != 0) {
            return n2;
        }
        int n3 = System.identityHashCode(executableElement);
        if (n3 == (n = System.identityHashCode(executableElement2))) {
            throw new IllegalStateException("Cannot order " + executableElement + " and " + executableElement2);
        }
        return n3 - n;
    }

    FileObject validateResource(String string, Element element, Annotation annotation, String string2, boolean bl) throws LayerGenerationException {
        if (string.startsWith("/")) {
            throw new LayerGenerationException("do not use leading slashes on resource paths", element, this.processingEnv, annotation, string2);
        }
        if (bl) {
            for (JavaFileManager.Location location : new JavaFileManager.Location[]{StandardLocation.SOURCE_PATH, StandardLocation.CLASS_OUTPUT, StandardLocation.CLASS_PATH, StandardLocation.PLATFORM_CLASS_PATH}) {
                try {
                    FileObject fileObject = this.processingEnv.getFiler().getResource(location, "", string);
                    if (location.isOutputLocation()) {
                        fileObject.openInputStream().close();
                    }
                    return fileObject;
                }
                catch (IOException iOException) {
                }
            }
            throw new LayerGenerationException("Cannot find resource " + string, element, this.processingEnv, annotation, string2);
        }
        try {
            try {
                FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", string);
                fileObject.openInputStream().close();
                return fileObject;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", string);
                    fileObject.openInputStream().close();
                    return fileObject;
                }
                catch (IOException iOException) {
                    throw fileNotFoundException;
                }
            }
        }
        catch (IOException iOException) {
            throw new LayerGenerationException("Cannot find resource " + string, element, this.processingEnv, annotation, string2);
        }
    }

    private static void findAllElements(Set<? extends Element> set, Set<Element> set2, Class<? extends Annotation> clazz) {
        for (Element element : set) {
            PackageElement packageElement = HTMLDialogProcessor.findPkg(element);
            if (!set2.add(packageElement)) continue;
            HTMLDialogProcessor.searchSubTree(packageElement, set2, clazz);
        }
    }

    private static void searchSubTree(Element element, Set<Element> set, Class<? extends Annotation> clazz) {
        if (element.getAnnotation(clazz) != null) {
            set.add(element);
        }
        for (Element element2 : element.getEnclosedElements()) {
            HTMLDialogProcessor.searchSubTree(element2, set, clazz);
        }
    }

    private void generateTechIds(Writer writer, String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            return;
        }
        writer.append("addTechIds(");
        String string = "";
        for (String string2 : stringArray) {
            writer.append(string);
            writer.append('\"');
            writer.append(string2);
            writer.append('\"');
            string = ", ";
        }
        writer.append(").\n");
    }
}

