/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.htmlui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.netbeans.api.htmlui.HTMLDialog;
import org.netbeans.modules.htmlui.Buttons;
import org.netbeans.modules.htmlui.ContextAccessor;
import org.netbeans.modules.htmlui.HtmlPair;
import org.netbeans.spi.htmlui.HTMLViewerSpi;
import org.openide.util.Lookup;

public final class HTMLDialogBase {
    private final Buttons<?, ?> buttons;
    private final HtmlPair<?, ?> view;

    private HTMLDialogBase(HtmlPair<?, ?> htmlPair, Buttons<?, ?> buttons) {
        this.buttons = buttons;
        this.view = htmlPair;
    }

    public static HTMLDialogBase create(String string, final Runnable runnable, HTMLDialog.OnSubmit onSubmit, String[] stringArray, final Class<?> clazz) {
        URL uRL;
        ClassLoader classLoader = runnable.getClass().getClassLoader();
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(string, malformedURLException);
        }
        class AcceptAndInit
        implements Consumer<String>,
        Callable<Lookup> {
            private Buttons<?, ?> buttons;

            AcceptAndInit() {
            }

            synchronized <A, B> Buttons<A, B> assignButtons(Buttons<A, B> buttons) {
                if (this.buttons != null) {
                    throw new IllegalStateException();
                }
                this.buttons = buttons;
                this.notifyAll();
                return buttons;
            }

            private Buttons<?, ?> awaitButtons() {
                assert (Thread.holdsLock(this));
                while (this.buttons == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.buttons;
            }

            @Override
            public synchronized void accept(String string) {
                this.awaitButtons().accept(string);
            }

            @Override
            public Lookup call() throws Exception {
                runnable.run();
                this.initializeButtons();
                return null;
            }

            private synchronized void initializeButtons() {
                if (clazz != null) {
                    return;
                }
                this.awaitButtons().buttons();
            }
        }
        AcceptAndInit acceptAndInit = new AcceptAndInit();
        HTMLViewerSpi.Context context = ContextAccessor.getDefault().newContext(classLoader, uRL, stringArray, onSubmit, acceptAndInit, acceptAndInit, clazz);
        HtmlPair<?, ?> htmlPair = HtmlPair.newView(context);
        Buttons buttons = clazz == null ? new Buttons(htmlPair, onSubmit) : null;
        HTMLDialogBase hTMLDialogBase = new HTMLDialogBase(htmlPair, acceptAndInit.assignButtons(buttons));
        htmlPair.component(Void.class);
        return hTMLDialogBase;
    }

    public <C> C component(Class<C> clazz) {
        return this.view.component(clazz);
    }

    protected void onSubmit(String string) {
        this.buttons.accept(string);
    }

    public void show(HTMLDialog.OnSubmit onSubmit) {
    }

    public String showAndWait() {
        return this.buttons.obtainResult();
    }
}

